/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.util.Date;
import sun.rmi.runtime.NewThreadAction;
import sun.security.action.GetPropertyAction;

class PipeWriter
implements Runnable {
    private ByteArrayOutputStream bufOut;
    private int cLast;
    private byte[] currSep;
    private PrintWriter out;
    private InputStream in;
    private String pipeString;
    private String execString;
    private static String lineSeparator;
    private static int lineSeparatorLength;
    private static int numExecs;

    private PipeWriter(InputStream inputStream, OutputStream outputStream, String string, int n) {
        this.in = inputStream;
        this.out = new PrintWriter(outputStream);
        this.bufOut = new ByteArrayOutputStream();
        this.currSep = new byte[lineSeparatorLength];
        this.execString = ":ExecGroup-" + Integer.toString(n) + ':' + string + ':';
    }

    @Override
    public void run() {
        byte[] byArray = new byte[256];
        try {
            int n;
            while ((n = this.in.read(byArray)) != -1) {
                this.write(byArray, 0, n);
            }
            String string = this.bufOut.toString();
            this.bufOut.reset();
            if (string.length() > 0) {
                this.out.println(this.createAnnotation() + string);
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.write(byArray[n + i]);
        }
    }

    private void write(byte by) throws IOException {
        int n = 0;
        for (n = 1; n < this.currSep.length; ++n) {
            this.currSep[n - 1] = this.currSep[n];
        }
        this.currSep[n - 1] = by;
        this.bufOut.write(by);
        if (this.cLast >= lineSeparatorLength - 1 && lineSeparator.equals(new String(this.currSep))) {
            this.cLast = 0;
            this.out.print(this.createAnnotation() + this.bufOut.toString());
            this.out.flush();
            this.bufOut.reset();
            if (this.out.checkError()) {
                throw new IOException("PipeWriter: IO Exception when writing to output stream.");
            }
        } else {
            ++this.cLast;
        }
    }

    private String createAnnotation() {
        return new Date().toString() + this.execString;
    }

    static void plugTogetherPair(InputStream inputStream, OutputStream outputStream, InputStream inputStream2, OutputStream outputStream2) {
        Thread thread = null;
        Thread thread2 = null;
        int n = PipeWriter.getNumExec();
        thread = AccessController.doPrivileged(new NewThreadAction(new PipeWriter(inputStream, outputStream, "out", n), "out", true));
        thread2 = AccessController.doPrivileged(new NewThreadAction(new PipeWriter(inputStream2, outputStream2, "err", n), "err", true));
        thread.start();
        thread2.start();
    }

    private static synchronized int getNumExec() {
        return numExecs++;
    }

    static {
        numExecs = 0;
        lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        lineSeparatorLength = lineSeparator.length();
    }
}

