/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

public class MonitorListModel
extends AbstractListModel {
    private final List<String> monitors = new ArrayList<String>();

    MonitorListModel(Environment environment) {
        MonitorListListener monitorListListener = new MonitorListListener();
        environment.getContextManager().addContextListener(monitorListListener);
    }

    @Override
    public Object getElementAt(int n) {
        return this.monitors.get(n);
    }

    @Override
    public int getSize() {
        return this.monitors.size();
    }

    public void add(String string) {
        this.monitors.add(string);
        int n = this.monitors.size() - 1;
        this.fireIntervalAdded(this, n, n);
    }

    public void remove(String string) {
        int n = this.monitors.indexOf(string);
        this.remove(n);
    }

    public void remove(int n) {
        this.monitors.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public List<String> monitors() {
        return Collections.unmodifiableList(this.monitors);
    }

    public Iterator iterator() {
        return this.monitors().iterator();
    }

    private void invalidate() {
        this.fireContentsChanged(this, 0, this.monitors.size() - 1);
    }

    private class MonitorListListener
    implements ContextListener {
        private MonitorListListener() {
        }

        @Override
        public void currentFrameChanged(CurrentFrameChangedEvent currentFrameChangedEvent) {
            MonitorListModel.this.invalidate();
        }
    }
}

