/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.ByteField;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CheckedExceptionElement;
import sun.jvm.hotspot.oops.CompressedLineNumberReadStream;
import sun.jvm.hotspot.oops.LineNumberTableElement;
import sun.jvm.hotspot.oops.LocalVariableTableElement;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class ConstMethod
extends Oop {
    private static int HAS_LINENUMBER_TABLE;
    private static int HAS_CHECKED_EXCEPTIONS;
    private static int HAS_LOCALVARIABLE_TABLE;
    private static OopField method;
    private static OopField exceptionTable;
    private static CIntField constMethodSize;
    private static ByteField flags;
    private static CIntField codeSize;
    private static CIntField nameIndex;
    private static CIntField signatureIndex;
    private static CIntField genericSignatureIndex;
    private static long bytecodeOffset;
    private static long checkedExceptionElementSize;
    private static long localVariableTableElementSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("constMethodOopDesc");
        method = new OopField(type.getOopField("_method"), 0L);
        exceptionTable = new OopField(type.getOopField("_exception_table"), 0L);
        constMethodSize = new CIntField(type.getCIntegerField("_constMethod_size"), 0L);
        flags = new ByteField(type.getJByteField("_flags"), 0L);
        HAS_LINENUMBER_TABLE = db.lookupIntConstant("constMethodOopDesc::_has_linenumber_table");
        HAS_CHECKED_EXCEPTIONS = db.lookupIntConstant("constMethodOopDesc::_has_checked_exceptions");
        HAS_LOCALVARIABLE_TABLE = db.lookupIntConstant("constMethodOopDesc::_has_localvariable_table");
        codeSize = new CIntField(type.getCIntegerField("_code_size"), 0L);
        nameIndex = new CIntField(type.getCIntegerField("_name_index"), 0L);
        signatureIndex = new CIntField(type.getCIntegerField("_signature_index"), 0L);
        genericSignatureIndex = new CIntField(type.getCIntegerField("_generic_signature_index"), 0L);
        bytecodeOffset = type.getSize();
        type = db.lookupType("CheckedExceptionElement");
        checkedExceptionElementSize = type.getSize();
        type = db.lookupType("LocalVariableTableElement");
        localVariableTableElementSize = type.getSize();
    }

    ConstMethod(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public Method getMethod() {
        return (Method)method.getValue(this);
    }

    public TypeArray getExceptionTable() {
        return (TypeArray)exceptionTable.getValue(this);
    }

    public long getConstMethodSize() {
        return constMethodSize.getValue(this);
    }

    public byte getFlags() {
        return flags.getValue(this);
    }

    public long getCodeSize() {
        return codeSize.getValue(this);
    }

    public long getNameIndex() {
        return nameIndex.getValue(this);
    }

    public long getSignatureIndex() {
        return signatureIndex.getValue(this);
    }

    public long getGenericSignatureIndex() {
        return genericSignatureIndex.getValue(this);
    }

    public Symbol getName() {
        return this.getMethod().getName();
    }

    public Symbol getSignature() {
        return this.getMethod().getSignature();
    }

    public Symbol getGenericSignature() {
        return this.getMethod().getGenericSignature();
    }

    public int getBytecodeOrBPAt(int bci) {
        return this.getHandle().getJByteAt(bytecodeOffset + (long)bci) & 0xFF;
    }

    public byte getBytecodeByteArg(int bci) {
        return (byte)this.getBytecodeOrBPAt(bci);
    }

    public short getBytecodeShortArg(int bci) {
        int hi = this.getBytecodeOrBPAt(bci);
        int lo = this.getBytecodeOrBPAt(bci + 1);
        return (short)(hi << 8 | lo);
    }

    public int getBytecodeIntArg(int bci) {
        int b4 = this.getBytecodeOrBPAt(bci);
        int b3 = this.getBytecodeOrBPAt(bci + 1);
        int b2 = this.getBytecodeOrBPAt(bci + 2);
        int b1 = this.getBytecodeOrBPAt(bci + 3);
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    public byte[] getByteCode() {
        byte[] bc = new byte[(int)this.getCodeSize()];
        for (int i = 0; i < bc.length; ++i) {
            long offs = bytecodeOffset + (long)i;
            bc[i] = this.getHandle().getJByteAt(offs);
        }
        return bc;
    }

    public long getObjectSize() {
        return this.getConstMethodSize() * this.getHeap().getOopSize();
    }

    public void printValueOn(PrintStream tty) {
        tty.print("ConstMethod " + this.getName().asString() + this.getSignature().asString() + "@" + this.getHandle());
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doOop(method, true);
            visitor.doOop(exceptionTable, true);
            visitor.doCInt(constMethodSize, true);
            visitor.doByte(flags, true);
            visitor.doCInt(codeSize, true);
            visitor.doCInt(nameIndex, true);
            visitor.doCInt(signatureIndex, true);
            visitor.doCInt(genericSignatureIndex, true);
            visitor.doCInt(codeSize, true);
        }
    }

    public boolean hasLineNumberTable() {
        return (this.getFlags() & HAS_LINENUMBER_TABLE) != 0;
    }

    public int getLineNumberFromBCI(int bci) {
        if (!VM.getVM().isCore() && bci == -1) {
            bci = 0;
        }
        if (this.isNative()) {
            return -1;
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(bci == 0 || 0 <= bci && (long)bci < this.getCodeSize(), "illegal bci");
        }
        int bestBCI = 0;
        int bestLine = -1;
        if (this.hasLineNumberTable()) {
            CompressedLineNumberReadStream stream = new CompressedLineNumberReadStream(this.getHandle(), (int)this.offsetOfCompressedLineNumberTable());
            while (stream.readPair()) {
                if (stream.bci() == bci) {
                    return stream.line();
                }
                if (stream.bci() >= bci || stream.bci() < bestBCI) continue;
                bestBCI = stream.bci();
                bestLine = stream.line();
            }
        }
        return bestLine;
    }

    public LineNumberTableElement[] getLineNumberTable() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasLineNumberTable(), "should only be called if table is present");
        }
        int len = this.getLineNumberTableLength();
        CompressedLineNumberReadStream stream = new CompressedLineNumberReadStream(this.getHandle(), (int)this.offsetOfCompressedLineNumberTable());
        LineNumberTableElement[] ret = new LineNumberTableElement[len];
        for (int idx = 0; idx < len; ++idx) {
            stream.readPair();
            ret[idx] = new LineNumberTableElement(stream.bci(), stream.line());
        }
        return ret;
    }

    public boolean hasLocalVariableTable() {
        return (this.getFlags() & HAS_LOCALVARIABLE_TABLE) != 0;
    }

    public Symbol getLocalVariableName(int bci, int slot) {
        return this.getMethod().getLocalVariableName(bci, slot);
    }

    public LocalVariableTableElement[] getLocalVariableTable() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasLocalVariableTable(), "should only be called if table is present");
        }
        LocalVariableTableElement[] ret = new LocalVariableTableElement[this.getLocalVariableTableLength()];
        long offset = this.offsetOfLocalVariableTable();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new LocalVariableTableElement(this.getHandle(), offset);
            offset += localVariableTableElementSize;
        }
        return ret;
    }

    public boolean hasCheckedExceptions() {
        return (this.getFlags() & HAS_CHECKED_EXCEPTIONS) != 0;
    }

    public CheckedExceptionElement[] getCheckedExceptions() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasCheckedExceptions(), "should only be called if table is present");
        }
        CheckedExceptionElement[] ret = new CheckedExceptionElement[this.getCheckedExceptionsLength()];
        long offset = this.offsetOfCheckedExceptions();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new CheckedExceptionElement(this.getHandle(), offset);
            offset += checkedExceptionElementSize;
        }
        return ret;
    }

    private boolean isNative() {
        return this.getMethod().isNative();
    }

    private long offsetOfCodeEnd() {
        return bytecodeOffset + this.getCodeSize();
    }

    private long offsetOfCompressedLineNumberTable() {
        return this.offsetOfCodeEnd() + (this.isNative() ? 2L * VM.getVM().getAddressSize() : 0L);
    }

    private long offsetOfLastU2Element() {
        return this.getObjectSize() - 2L;
    }

    private long offsetOfCheckedExceptionsLength() {
        return this.offsetOfLastU2Element();
    }

    private int getCheckedExceptionsLength() {
        if (this.hasCheckedExceptions()) {
            return (int)this.getHandle().getCIntegerAt(this.offsetOfCheckedExceptionsLength(), 2L, true);
        }
        return 0;
    }

    private long offsetOfCheckedExceptions() {
        long offset = this.offsetOfCheckedExceptionsLength();
        long length = this.getCheckedExceptionsLength();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(length > 0L, "should only be called if table is present");
        }
        return offset -= length * checkedExceptionElementSize;
    }

    private int getLineNumberTableLength() {
        int len = 0;
        if (this.hasLineNumberTable()) {
            CompressedLineNumberReadStream stream = new CompressedLineNumberReadStream(this.getHandle(), (int)this.offsetOfCompressedLineNumberTable());
            while (stream.readPair()) {
                ++len;
            }
        }
        return len;
    }

    private int getLocalVariableTableLength() {
        if (this.hasLocalVariableTable()) {
            return (int)this.getHandle().getCIntegerAt(this.offsetOfLocalVariableTableLength(), 2L, true);
        }
        return 0;
    }

    private long offsetOfLocalVariableTableLength() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.hasLocalVariableTable(), "should only be called if table is present");
        }
        if (this.hasCheckedExceptions()) {
            return this.offsetOfCheckedExceptions() - 2L;
        }
        return this.offsetOfLastU2Element();
    }

    private long offsetOfLocalVariableTable() {
        long offset = this.offsetOfLocalVariableTableLength();
        long length = this.getLocalVariableTableLength();
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(length > 0L, "should only be called if table is present");
        }
        return offset -= length * localVariableTableElementSize;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ConstMethod.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

