/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class JobDispatcher {
    private static JobDispatcher instance;
    protected BlockingQueue<Runnable> jobQueue = new LinkedBlockingQueue<Runnable>();
    public static int WORKER_THREAD_MAX_COUNT;
    public static int WORKER_THREAD_TIMEOUT;
    protected int workerThreadCount = 0;
    protected int workerThreadIdleCount = 0;
    protected int workerThreadId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobDispatcher getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<JobDispatcher> clazz = JobDispatcher.class;
        synchronized (JobDispatcher.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            new JobDispatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private JobDispatcher() {
        instance = this;
        this.addWorkerThread().firstThread = true;
    }

    public void cancelOutstandingJobs() {
        this.jobQueue.clear();
    }

    public void addJob(Runnable job) {
        try {
            this.jobQueue.put(job);
            if (this.workerThreadIdleCount == 0 && this.workerThreadCount < WORKER_THREAD_MAX_COUNT) {
                this.addWorkerThread();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JobThread addWorkerThread() {
        JobThread jobThread = new JobThread(++this.workerThreadId);
        JobDispatcher jobDispatcher = this;
        synchronized (jobDispatcher) {
            ++this.workerThreadCount;
        }
        return jobThread;
    }

    static {
        WORKER_THREAD_MAX_COUNT = 8;
        WORKER_THREAD_TIMEOUT = 30;
    }

    public class JobThread
    extends Thread {
        Runnable job;
        boolean firstThread;

        public JobThread(int threadId) {
            super("OSMJobThread " + threadId);
            this.firstThread = false;
            this.setDaemon(true);
            this.job = null;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.executeJobs();
            JobDispatcher jobDispatcher = instance;
            synchronized (jobDispatcher) {
                --JobDispatcher.this.workerThreadCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void executeJobs() {
            while (!this.isInterrupted()) {
                JobDispatcher jobDispatcher;
                try {
                    jobDispatcher = instance;
                    synchronized (jobDispatcher) {
                        ++JobDispatcher.this.workerThreadIdleCount;
                    }
                    this.job = this.firstThread ? JobDispatcher.this.jobQueue.take() : JobDispatcher.this.jobQueue.poll(WORKER_THREAD_TIMEOUT, TimeUnit.SECONDS);
                }
                catch (InterruptedException e1) {
                    return;
                }
                finally {
                    jobDispatcher = instance;
                    synchronized (jobDispatcher) {
                        --JobDispatcher.this.workerThreadIdleCount;
                    }
                }
                if (this.job == null) {
                    return;
                }
                try {
                    this.job.run();
                    this.job = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

