/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;

public class TileController {
    protected TileLoader tileLoader;
    protected TileCache tileCache;
    protected TileSource tileSource = new OsmTileSource.Mapnik();
    JobDispatcher jobDispatcher;

    public TileController(TileSource source, TileCache tileCache, TileLoaderListener listener) {
        this.tileLoader = new OsmTileLoader(listener);
        this.tileCache = tileCache;
        this.jobDispatcher = JobDispatcher.getInstance();
    }

    public Tile getTile(int tilex, int tiley, int zoom) {
        int max = 1 << zoom;
        if (tilex < 0 || tilex >= max || tiley < 0 || tiley >= max) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, tilex, tiley, zoom);
        if (tile == null) {
            tile = new Tile(this.tileSource, tilex, tiley, zoom);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        if (!tile.isLoaded()) {
            this.jobDispatcher.addJob(this.tileLoader.createTileLoaderJob(this.tileSource, tilex, tiley, zoom));
        }
        return tile;
    }

    public TileCache getTileCache() {
        return this.tileCache;
    }

    public void setTileCache(TileCache tileCache) {
        this.tileCache = tileCache;
    }

    public TileLoader getTileLoader() {
        return this.tileLoader;
    }

    public void setTileLoader(TileLoader tileLoader) {
        this.tileLoader = tileLoader;
    }

    public TileSource getTileLayerSource() {
        return this.tileSource;
    }

    public TileSource getTileSource() {
        return this.tileSource;
    }

    public void setTileSource(TileSource tileSource) {
        this.tileSource = tileSource;
    }

    public void cancelOutstandingJobs() {
        this.jobDispatcher.cancelOutstandingJobs();
    }
}

