/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.help.HelpBrowserProxy;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Main {
    public static Component parent;
    public static Main main;
    public static final ExecutorService worker;
    public static Preferences pref;
    public static PrimitiveDeepCopy pasteBuffer;
    public static Layer pasteSource;
    public static Projection proj;
    public static MapFrame map;
    public static boolean applet;
    public static ToolbarPreferences toolbar;
    public UndoRedoHandler undoRedo = new UndoRedoHandler();
    public final MainMenu menu;
    private GettingStarted gettingStarted = new GettingStarted();
    public static int debug_level;
    public static PlatformHook platform;
    public static final JPanel contentPane;
    public static JPanel panel;
    protected static Rectangle bounds;
    private final OsmDataLayer.CommandQueueListener redoUndoListener = new OsmDataLayer.CommandQueueListener(){

        public void commandChanged(int queueSize, int redoSize) {
            Main.this.menu.undo.setEnabled(queueSize > 0);
            Main.this.menu.redo.setEnabled(redoSize > 0);
        }
    };

    public static final void debug(String msg) {
        if (debug_level <= 0) {
            return;
        }
        System.out.println(msg);
    }

    public final void setMapFrame(MapFrame map) {
        MapFrame old = Main.map;
        Main.map = map;
        panel.setVisible(false);
        panel.removeAll();
        if (map != null) {
            map.fillPanel(panel);
        } else {
            old.destroy();
            panel.add((Component)this.gettingStarted, "Center");
        }
        panel.setVisible(true);
        this.redoUndoListener.commandChanged(0, 0);
        PluginHandler.setMapFrame(old, map);
    }

    public final void removeLayer(Layer layer) {
        if (map != null) {
            Main.map.mapView.removeLayer(layer);
            if (Main.map.mapView.getAllLayers().isEmpty()) {
                this.setMapFrame(null);
            }
        }
    }

    public Main() {
        this(null);
    }

    public Main(SplashScreen splash) {
        main = this;
        platform.startupHook();
        contentPane.add((Component)panel, "Center");
        panel.add((Component)this.gettingStarted, "Center");
        if (splash != null) {
            splash.setStatus(I18n.tr("Creating main GUI"));
        }
        this.menu = new MainMenu();
        this.undoRedo.listenerCommands.add(this.redoUndoListener);
        contentPane.add((Component)Main.toolbar.control, "North");
        contentPane.getInputMap(2).put(Shortcut.registerShortcut("system:help", I18n.tr("Help"), 112, 5).getKeyStroke(), "Help");
        contentPane.getActionMap().put("Help", this.menu.help);
        TaggingPresetPreference.initialize();
        MapPaintPreference.initialize();
        toolbar.refreshToolbarControl();
        Main.toolbar.control.updateUI();
        contentPane.updateUI();
    }

    public final void addLayer(Layer layer) {
        if (map == null) {
            MapFrame mapFrame = new MapFrame();
            this.setMapFrame(mapFrame);
            mapFrame.selectMapMode((MapMode)mapFrame.getDefaultButtonAction());
            mapFrame.setVisible(true);
            mapFrame.initializeDialogsPane();
            layer.addPropertyChangeListener(LayerListDialog.getInstance().getModel());
        }
        Main.map.mapView.addLayer(layer);
    }

    public boolean hasEditLayer() {
        if (map == null) {
            return false;
        }
        if (Main.map.mapView == null) {
            return false;
        }
        return Main.map.mapView.getEditLayer() != null;
    }

    public OsmDataLayer getEditLayer() {
        if (map == null) {
            return null;
        }
        if (Main.map.mapView == null) {
            return null;
        }
        return Main.map.mapView.getEditLayer();
    }

    public DataSet getCurrentDataSet() {
        if (!this.hasEditLayer()) {
            return null;
        }
        return this.getEditLayer().data;
    }

    public static void preConstructorInit(Map<String, Collection<String>> args) {
        ProjectionPreference.setProjection();
        try {
            try {
                String laf = pref.get("laf");
                if (laf != null && laf.length() > 0) {
                    UIManager.setLookAndFeel(laf);
                }
            }
            catch (UnsupportedLookAndFeelException e) {
                System.out.println("Look and Feel not supported: " + pref.get("laf"));
            }
            toolbar = new ToolbarPreferences();
            contentPane.updateUI();
            panel.updateUI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UIManager.put("OptionPane.okIcon", ImageProvider.get("ok"));
        UIManager.put("OptionPane.yesIcon", UIManager.get("OptionPane.okIcon"));
        UIManager.put("OptionPane.cancelIcon", ImageProvider.get("cancel"));
        UIManager.put("OptionPane.noIcon", UIManager.get("OptionPane.cancelIcon"));
        try {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.valueOf(pref.get("coordinates")));
        }
        catch (IllegalArgumentException iae) {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.DECIMAL_DEGREES);
        }
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        String geometry = pref.get("gui.geometry");
        if (args.containsKey("geometry")) {
            geometry = args.get("geometry").iterator().next();
        }
        if (geometry.length() != 0) {
            Matcher m = Pattern.compile("(\\d+)x(\\d+)(([+-])(\\d+)([+-])(\\d+))?").matcher(geometry);
            if (m.matches()) {
                int w = Integer.valueOf(m.group(1));
                int h = Integer.valueOf(m.group(2));
                int x = 0;
                int y = 0;
                if (m.group(3) != null) {
                    x = Integer.valueOf(m.group(5));
                    y = Integer.valueOf(m.group(7));
                    if (m.group(4).equals("-")) {
                        x = screenDimension.width - x - w;
                    }
                    if (m.group(6).equals("-")) {
                        y = screenDimension.height - y - h;
                    }
                }
                bounds = new Rectangle(x, y, w, h);
                if (!pref.get("gui.geometry").equals(geometry)) {
                    pref.put("gui.geometry", geometry);
                }
            } else {
                System.out.println("Ignoring malformed geometry: " + geometry);
            }
        }
        if (bounds == null) {
            bounds = !args.containsKey("no-maximize") ? new Rectangle(0, 0, screenDimension.width, screenDimension.height) : new Rectangle(1000, 740);
        }
    }

    public void postConstructorProcessCmdLine(Map<String, Collection<String>> args) {
        if (args.containsKey("download")) {
            for (String s : args.get("download")) {
                Main.downloadFromParamString(false, s);
            }
        }
        if (args.containsKey("downloadgps")) {
            for (String s : args.get("downloadgps")) {
                Main.downloadFromParamString(true, s);
            }
        }
        if (args.containsKey("selection")) {
            for (String s : args.get("selection")) {
                SearchAction.search(s, SearchAction.SearchMode.add, false, false);
            }
        }
    }

    public static void cleanupBeforeExit() {
        HelpBrowserProxy.getInstance().exit();
    }

    public static boolean saveUnsavedModifications() {
        if (map == null) {
            return true;
        }
        SaveLayersDialog dialog = new SaveLayersDialog(parent);
        ArrayList<OsmDataLayer> layersWithUnmodifiedChanges = new ArrayList<OsmDataLayer>();
        for (OsmDataLayer l : Main.map.mapView.getLayersOfType(OsmDataLayer.class)) {
            if (!l.requiresSaveToFile() && !l.requiresUploadToServer()) continue;
            layersWithUnmodifiedChanges.add(l);
        }
        dialog.prepareForSavingAndUpdatingLayersBeforeExit();
        if (!layersWithUnmodifiedChanges.isEmpty()) {
            dialog.getModel().populate(layersWithUnmodifiedChanges);
            dialog.setVisible(true);
            switch (dialog.getUserAction()) {
                case CANCEL: {
                    return false;
                }
                case PROCEED: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static void downloadFromParamString(boolean rawGps, String s) {
        if (s.startsWith("http:")) {
            Bounds b = OsmUrlToBounds.parse(s);
            if (b == null) {
                JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed URL: \"{0}\"", s), I18n.tr("Warning"), 2);
            } else {
                DownloadOsmTask osmTask = new DownloadOsmTask();
                osmTask.download(Main.main.menu.download, b.min.lat(), b.min.lon(), b.max.lat(), b.max.lon(), null);
            }
            return;
        }
        if (s.startsWith("file:")) {
            File f = null;
            try {
                f = new File(new URI(s));
            }
            catch (URISyntaxException e) {
                JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed file URL: \"{0}\"", s), I18n.tr("Warning"), 2);
            }
            try {
                if (f != null) {
                    OpenFileAction.openFile(f);
                }
            }
            catch (IllegalDataException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(parent, I18n.tr("<html>Could not read file ''{0}''.<br> Error is: <br>{1}</html>", f.getName(), e.getMessage()), I18n.tr("Error"), 0);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(parent, I18n.tr("<html>Could not read file ''{0}''.<br> Error is: <br>{1}</html>", f.getName(), e.getMessage()), I18n.tr("Error"), 0);
            }
            return;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        if (st.countTokens() == 4) {
            try {
                DownloadDialog.DownloadTask task = rawGps ? new DownloadGpsTask() : new DownloadOsmTask();
                task.download(Main.main.menu.download, Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()), null);
                return;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        File f = new File(s);
        try {
            OpenFileAction.openFile(f);
        }
        catch (IllegalDataException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(parent, I18n.tr("<html>Could not read file ''{0}''.<br> Error is: <br>{1}</html>", f.getName(), e.getMessage()), I18n.tr("Error"), 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(parent, I18n.tr("<html>Could not read file ''{0}''.<br> Error is: <br>{1}</html>", f.getName(), e.getMessage()), I18n.tr("Error"), 0);
        }
    }

    public static void determinePlatformHook() {
        String os = System.getProperty("os.name");
        if (os == null) {
            System.err.println("Your operating system has no name, so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        } else if (os.toLowerCase().startsWith("windows")) {
            platform = new PlatformHookWindows();
        } else if (os.equals("Linux") || os.equals("Solaris") || os.equals("SunOS") || os.equals("AIX") || os.equals("FreeBSD") || os.equals("NetBSD") || os.equals("OpenBSD")) {
            platform = new PlatformHookUnixoid();
        } else if (os.toLowerCase().startsWith("mac os x")) {
            platform = new PlatformHookOsx();
        } else {
            System.err.println("I don't know your operating system '" + os + "', so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        }
    }

    public static void saveGuiGeometry() {
        String newGeometry = "";
        String newToggleDlgWidth = null;
        try {
            if (((JFrame)parent).getExtendedState() == 0) {
                Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
                Rectangle bounds = parent.getBounds();
                int width = (int)bounds.getWidth();
                int height = (int)bounds.getHeight();
                int x = (int)bounds.getX();
                int y = (int)bounds.getY();
                if (width > screenDimension.width) {
                    width = screenDimension.width;
                }
                if (height > screenDimension.height) {
                    width = screenDimension.height;
                }
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                newGeometry = width + "x" + height + "+" + x + "+" + y;
            }
            if (map != null && (newToggleDlgWidth = Integer.toString(map.getToggleDlgWidth())).equals(Integer.toString(Main.map.DEF_TOGGLE_DLG_WIDTH))) {
                newToggleDlgWidth = "";
            }
        }
        catch (Exception e) {
            System.out.println("Failed to save GUI geometry: " + e);
            e.printStackTrace();
        }
        pref.put("gui.geometry", newGeometry);
        if (newToggleDlgWidth != null) {
            pref.put("toggleDialogs.width", newToggleDlgWidth);
        }
    }

    static {
        worker = Executors.newSingleThreadExecutor();
        pref = new Preferences();
        pasteBuffer = new PrimitiveDeepCopy();
        applet = false;
        debug_level = 1;
        contentPane = new JPanel(new BorderLayout());
        panel = new JPanel(new BorderLayout());
    }
}

