/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AddNodeAction
extends JosmAction {
    public AddNodeAction() {
        super(I18n.tr("Add Node..."), "addnode", I18n.tr("Add a node by entering latitude and longitude."), Shortcut.registerShortcut("addnode", I18n.tr("Edit: {0}", I18n.tr("Add Node...")), 68, 3, 1), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel("<html>" + I18n.tr("Enter the coordinates for the new node.") + "<br>" + I18n.tr("Use decimal degrees.") + "<br>" + I18n.tr("Negative values denote Western/Southern hemisphere.")), GBC.eol());
        p.add((Component)new JLabel(I18n.tr("Latitude")), GBC.std().insets(0, 10, 5, 0));
        JTextField lat = new JTextField(12);
        p.add((Component)lat, GBC.eol().insets(0, 10, 0, 0));
        p.add((Component)new JLabel(I18n.tr("Longitude")), GBC.std().insets(0, 0, 5, 10));
        JTextField lon = new JTextField(12);
        p.add((Component)lon, GBC.eol().insets(0, 0, 0, 10));
        Node nnew = null;
        while (nnew == null) {
            JOptionPane pane = new JOptionPane(p, -1, 2);
            pane.createDialog(Main.parent, I18n.tr("Add Node...")).setVisible(true);
            if (!Integer.valueOf(0).equals(pane.getValue())) {
                return;
            }
            try {
                LatLon ll = new LatLon(Double.parseDouble(lat.getText()), Double.parseDouble(lon.getText()));
                if (ll.isOutSideWorld()) continue;
                nnew = new Node(ll);
            }
            catch (Exception ex) {}
        }
        Main.main.undoRedo.add(new AddCommand(nnew));
        this.getCurrentDataSet().setSelected(nnew);
        Main.map.mapView.repaint();
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }
}

