/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.WindowGeometry;

public class DownloadAction
extends JosmAction {
    public DownloadDialog dialog;

    public DownloadAction() {
        super(I18n.tr("Download from OSM..."), "download", I18n.tr("Download map data from the OSM server."), Shortcut.registerShortcut("file:download", I18n.tr("File: {0}", I18n.tr("Download from OSM...")), 68, 8), true);
    }

    protected ExtendedDialog createUploadDialog() {
        this.dialog = new DownloadDialog();
        JPanel downPanel = new JPanel(new BorderLayout());
        downPanel.add((Component)this.dialog, "Center");
        String prefName = this.dialog.getClass().getName() + ".geometry";
        WindowGeometry wg = WindowGeometry.centerInWindow(Main.parent, new Dimension(1000, 600));
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Download"), new String[]{I18n.tr("OK"), I18n.tr("Cancel")});
        dialog.setContent(downPanel, false);
        dialog.setButtonIcons(new String[]{"ok", "cancel"});
        dialog.setRememberWindowGeometry(prefName, wg);
        return dialog;
    }

    public void actionPerformed(ActionEvent e) {
        ExtendedDialog dlg = this.createUploadDialog();
        boolean finish = false;
        while (!finish) {
            dlg.showDialog();
            Main.pref.put("download.newlayer", this.dialog.newLayer.isSelected());
            if (dlg.getValue() == 1) {
                Main.pref.put("download.tab", Integer.toString(this.dialog.getSelectedTab()));
                for (DownloadDialog.DownloadTask task : this.dialog.downloadTasks) {
                    Main.pref.put("download." + task.getPreferencesSuffix(), task.getCheckBox().isSelected());
                    if (!task.getCheckBox().isSelected()) continue;
                    task.download(this, this.dialog.minlat, this.dialog.minlon, this.dialog.maxlat, this.dialog.maxlon, null);
                    finish = true;
                }
            } else {
                finish = true;
            }
            if (finish) continue;
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one task to download"), I18n.tr("Error"), 0);
        }
        this.dialog = null;
        dlg.dispose();
    }
}

