/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UpdateSelectionAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTaskList;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UpdateDataAction
extends JosmAction {
    public UpdateDataAction() {
        super(I18n.tr("Update data"), "updatedata", I18n.tr("Updates the objects in the current data layer from the server."), Shortcut.registerShortcut("file:updatedata", I18n.tr("Update data"), 85, 1), true);
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    public void actionPerformed(ActionEvent e) {
        int i;
        if (!this.isEnabled()) {
            return;
        }
        if (this.getEditLayer() == null) {
            return;
        }
        int bboxCount = 0;
        ArrayList<Area> areas = new ArrayList<Area>();
        for (DataSource ds : this.getEditLayer().data.dataSources) {
            areas.add(new Area(ds.bounds.asRect()));
        }
        for (i = 0; i < areas.size(); ++i) {
            for (int j = i + 1; j < areas.size(); ++j) {
                ((Area)areas.get(i)).subtract((Area)areas.get(j));
            }
        }
        for (i = areas.size() - 1; i > 0; --i) {
            for (int j = i - 1; j > 0; --j) {
                ((Area)areas.get(i)).subtract((Area)areas.get(j));
            }
        }
        for (Area a : areas) {
            if (a.isEmpty()) continue;
            ++bboxCount;
        }
        if (bboxCount == 0) {
            new UpdateSelectionAction().updatePrimitives(this.getEditLayer().data.allPrimitives());
        } else {
            new DownloadOsmTaskList().download(false, (Collection<Area>)areas, (ProgressMonitor)new PleaseWaitProgressMonitor(I18n.tr("Updating data")));
        }
    }
}

