/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadGpsTask
implements DownloadDialog.DownloadTask {
    private Future<Task> task = null;
    private JCheckBox checkBox = new JCheckBox(I18n.tr("Raw GPS data"));

    public void download(DownloadAction action, double minlat, double minlon, double maxlat, double maxlon, ProgressMonitor progressMonitor) {
        Task t = new Task(action.dialog.newLayer.isSelected(), new BoundingBoxDownloader(minlat, minlon, maxlat, maxlon), progressMonitor);
        this.task = Main.worker.submit(t, t);
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public String getPreferencesSuffix() {
        return "gps";
    }

    public void loadUrl(boolean a, String b, ProgressMonitor progressMonitor) {
    }

    public String getErrorMessage() {
        if (this.task == null) {
            return "";
        }
        try {
            Task t = this.task.get();
            return t.getProgressMonitor().getErrorMessage() == null ? "" : t.getProgressMonitor().getErrorMessage();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static class Task
    extends PleaseWaitRunnable {
        private BoundingBoxDownloader reader;
        private GpxData rawData;
        private final boolean newLayer;
        private OsmTransferException lastException;

        public Task(boolean newLayer, BoundingBoxDownloader reader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading GPS data"));
            this.reader = reader;
            this.newLayer = newLayer;
        }

        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                this.rawData = this.reader.parseRawGps(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (OsmTransferException e) {
                this.lastException = e;
            }
            catch (Exception e) {
                this.lastException = new OsmTransferException(e);
            }
        }

        protected void finish() {
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
                return;
            }
            if (this.rawData == null) {
                return;
            }
            this.rawData.recalculateBounds();
            String name = I18n.tr("Downloaded GPX Data");
            GpxLayer layer = new GpxLayer(this.rawData, name);
            Layer x = this.findMergeLayer();
            if (this.newLayer || x == null) {
                Main.main.addLayer(layer);
            } else {
                x.mergeFrom(layer);
            }
        }

        private Layer findMergeLayer() {
            boolean merge = Main.pref.getBoolean("download.gps.mergeWithLocal", false);
            if (Main.map == null) {
                return null;
            }
            Layer active = Main.map.mapView.getActiveLayer();
            if (active != null && active instanceof GpxLayer && (merge || ((GpxLayer)active).data.fromServer)) {
                return active;
            }
            for (Layer l : Main.map.mapView.getAllLayers()) {
                if (!(l instanceof GpxLayer) || !merge && !((GpxLayer)l).data.fromServer) continue;
                return l;
            }
            return null;
        }

        protected void cancel() {
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }
}

