/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DownloadAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadOsmTask
implements DownloadDialog.DownloadTask {
    private static final Logger logger = Logger.getLogger(DownloadOsmTask.class.getName());
    private static Bounds currentBounds;
    private Future<Task> task = null;
    private DataSet downloadedData;
    private boolean canceled = false;
    private boolean failed = false;
    private JCheckBox checkBox = new JCheckBox(I18n.tr("OpenStreetMap data"), true);

    private void rememberDownloadedData(DataSet ds) {
        this.downloadedData = ds;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public DataSet getDownloadedData() {
        return this.downloadedData;
    }

    public void download(DownloadAction action, double minlat, double minlon, double maxlat, double maxlon, ProgressMonitor progressMonitor) {
        double t;
        if (minlat > maxlat) {
            t = minlat;
            minlat = maxlat;
            maxlat = t;
        }
        if (minlon > maxlon) {
            t = minlon;
            minlon = maxlon;
            maxlon = t;
        }
        boolean newLayer = action != null && (action.dialog == null || action.dialog.newLayer.isSelected());
        Task t2 = new Task(newLayer, new BoundingBoxDownloader(minlat, minlon, maxlat, maxlon), progressMonitor);
        currentBounds = new Bounds(new LatLon(minlat, minlon), new LatLon(maxlat, maxlon));
        this.task = Main.worker.submit(t2, t2);
    }

    public void loadUrl(boolean new_layer, String url, ProgressMonitor progressMonitor) {
        Task t = new Task(new_layer, new OsmServerLocationReader(url), progressMonitor);
        currentBounds = new Bounds(new LatLon(0.0, 0.0), new LatLon(0.0, 0.0));
        this.task = Main.worker.submit(t, t);
    }

    public JCheckBox getCheckBox() {
        return this.checkBox;
    }

    public String getPreferencesSuffix() {
        return "osm";
    }

    public String getErrorMessage() {
        if (this.task == null) {
            return "";
        }
        try {
            Task t = this.task.get();
            return t.getProgressMonitor().getErrorMessage() == null ? "" : t.getProgressMonitor().getErrorMessage();
        }
        catch (Exception e) {
            return "";
        }
    }

    private class Task
    extends PleaseWaitRunnable {
        private OsmServerReader reader;
        private DataSet dataSet;
        private boolean newLayer;
        private boolean canceled;
        private Exception lastException;

        public Task(boolean newLayer, OsmServerReader reader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading data"), progressMonitor, false);
            this.reader = reader;
            this.newLayer = newLayer;
        }

        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                this.dataSet = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (Exception e) {
                if (this.canceled) {
                    logger.warning(I18n.tr("Ignoring exception because download has been cancelled. Exception was: {0}" + e.toString()));
                    return;
                }
                this.lastException = e instanceof OsmTransferException ? e : new OsmTransferException(e);
            }
        }

        protected OsmDataLayer getEditLayer() {
            if (Main.map == null) {
                return null;
            }
            if (Main.map.mapView == null) {
                return null;
            }
            return Main.map.mapView.getEditLayer();
        }

        protected int getNumDataLayers() {
            int count = 0;
            if (Main.map == null) {
                return 0;
            }
            if (Main.map.mapView == null) {
                return 0;
            }
            Collection<Layer> layers = Main.map.mapView.getAllLayers();
            for (Layer layer : layers) {
                if (!(layer instanceof OsmDataLayer)) continue;
                ++count;
            }
            return count;
        }

        protected OsmDataLayer getFirstDataLayer() {
            if (Main.map == null) {
                return null;
            }
            if (Main.map.mapView == null) {
                return null;
            }
            List<Layer> layers = Main.map.mapView.getAllLayersAsList();
            for (Layer layer : layers) {
                if (!(layer instanceof OsmDataLayer)) continue;
                return (OsmDataLayer)layer;
            }
            return null;
        }

        protected void finish() {
            if (this.canceled) {
                return;
            }
            if (this.lastException != null) {
                this.getProgressMonitor().setErrorMessage(ExceptionUtil.explainException(this.lastException));
                DownloadOsmTask.this.setFailed(true);
                return;
            }
            if (this.dataSet == null) {
                return;
            }
            if (currentBounds == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                this.progressMonitor.setErrorMessage(I18n.tr("No data found in this area."));
                this.dataSet.dataSources.add(new DataSource(currentBounds, "OpenStreetMap server"));
            }
            DownloadOsmTask.this.rememberDownloadedData(this.dataSet);
            int numDataLayers = this.getNumDataLayers();
            if (this.newLayer || numDataLayers == 0 || numDataLayers > 1 && this.getEditLayer() == null) {
                OsmDataLayer layer = new OsmDataLayer(this.dataSet, OsmDataLayer.createNewName(), null);
                Main.main.addLayer(layer);
            } else {
                OsmDataLayer target = this.getEditLayer();
                if (target == null) {
                    target = this.getFirstDataLayer();
                }
                target.mergeFrom(this.dataSet);
            }
        }

        protected void cancel() {
            this.canceled = true;
            if (this.reader != null) {
                this.reader.cancel();
            }
            DownloadOsmTask.this.setCanceled(true);
        }
    }
}

