/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.RotateCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.data.osm.visitor.SimplePaintVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAction
extends MapMode
implements SelectionManager.SelectionEnded {
    private static final Logger logger = Logger.getLogger(SelectAction.class.getName());
    private Mode mode = null;
    private long mouseDownTime = 0L;
    private boolean didMove = false;
    private boolean cancelDrawMode = false;
    Node virtualNode = null;
    Collection<WaySegment> virtualWays = new ArrayList<WaySegment>();
    SequenceCommand virtualCmds = null;
    private Cursor oldCursor;
    private Point mousePos;
    private SelectionManager selectionManager;
    private int initialMoveDelay;
    private int initialMoveThreshold;
    private boolean initialMoveThresholdExceeded = false;

    public static boolean isPlatformOsx() {
        return Main.platform != null && Main.platform instanceof PlatformHookOsx;
    }

    public SelectAction(MapFrame mapFrame) {
        super(I18n.tr("Select"), "move/move", I18n.tr("Select, move and rotate objects"), Shortcut.registerShortcut("mapmode:select", I18n.tr("Mode: {0}", I18n.tr("Select")), 83, 3), mapFrame, SelectAction.getCursor("normal", "selection", 0));
        this.putValue("help", "Action/Move/Move");
        this.selectionManager = new SelectionManager(this, false, mapFrame.mapView);
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.initialMoveThreshold = Main.pref.getInteger("edit.initial-move-threshold", 5);
    }

    private static Cursor getCursor(String name, String mod, int def) {
        try {
            return ImageProvider.getCursor(name, mod);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(def);
        }
    }

    private void setCursor(Cursor c) {
        if (this.oldCursor == null) {
            this.oldCursor = Main.map.mapView.getCursor();
            Main.map.mapView.setCursor(c);
        }
    }

    private void restoreCursor() {
        if (this.oldCursor != null) {
            Main.map.mapView.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.mapView.setVirtualNodesEnabled(Main.pref.getInteger("mappaint.node.virtual-size", 8) != 0);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.selectionManager.unregister(Main.map.mapView);
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.setVirtualNodesEnabled(false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        this.cancelDrawMode = true;
        if (this.mode == Mode.select) {
            return;
        }
        if (this.mode == Mode.move && System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.rotate && (e.getModifiersEx() & 0x400) == 0) {
            return;
        }
        if (this.mode == Mode.move) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
        if (this.mousePos == null) {
            this.mousePos = e.getPoint();
            return;
        }
        if (!this.initialMoveThresholdExceeded) {
            int dyp;
            int dxp = this.mousePos.x - e.getX();
            int dp = (int)Math.sqrt(dxp * dxp + (dyp = this.mousePos.y - e.getY()) * dyp);
            if (dp < this.initialMoveThreshold) {
                return;
            }
            this.initialMoveThresholdExceeded = true;
        }
        EastNorth mouseEN = Main.map.mapView.getEastNorth(e.getX(), e.getY());
        EastNorth mouseStartEN = Main.map.mapView.getEastNorth(this.mousePos.x, this.mousePos.y);
        double dx = mouseEN.east() - mouseStartEN.east();
        double dy = mouseEN.north() - mouseStartEN.north();
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        if (this.virtualWays.size() > 0) {
            LinkedList<Command> virtualCmds = new LinkedList<Command>();
            virtualCmds.add(new AddCommand(this.virtualNode));
            for (WaySegment virtualWay : this.virtualWays) {
                Way w = virtualWay.way;
                Way wnew = new Way(w);
                wnew.addNode(virtualWay.lowerIndex + 1, this.virtualNode);
                virtualCmds.add(new ChangeCommand(w, wnew));
            }
            virtualCmds.add(new MoveCommand(this.virtualNode, dx, dy));
            String text = I18n.trn("Add and move a virtual new node to way", "Add and move a virtual new node to {0} ways", this.virtualWays.size(), this.virtualWays.size());
            Main.main.undoRedo.add(new SequenceCommand(text, virtualCmds));
            this.selectPrims(Collections.singleton(this.virtualNode), false, false, false, false);
            this.virtualWays.clear();
            this.virtualNode = null;
        } else {
            Command c;
            Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelectedNodesAndWays();
            Collection<Node> affectedNodes = AllNodesVisitor.getAllNodes(selection);
            if (this.mode == Mode.rotate && affectedNodes.size() < 2) {
                return;
            }
            Command command = c = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
            if (c instanceof SequenceCommand) {
                c = ((SequenceCommand)c).getLastCommand();
            }
            if (this.mode == Mode.move) {
                if (c instanceof MoveCommand && affectedNodes.equals(((MoveCommand)c).getMovedNodes())) {
                    ((MoveCommand)c).moveAgain(dx, dy);
                } else {
                    c = new MoveCommand(selection, dx, dy);
                    Main.main.undoRedo.add(c);
                }
                for (Node n : affectedNodes) {
                    if (!n.getCoor().isOutSideWorld()) continue;
                    ((MoveCommand)c).moveAgain(-dx, -dy);
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world."), I18n.tr("Warning"), 2);
                    this.restoreCursor();
                    return;
                }
            } else if (this.mode == Mode.rotate) {
                if (c instanceof RotateCommand && affectedNodes.equals(((RotateCommand)c).getRotatedNodes())) {
                    ((RotateCommand)c).rotateAgain(mouseStartEN, mouseEN);
                } else {
                    Main.main.undoRedo.add(new RotateCommand(selection, mouseStartEN, mouseEN));
                }
            }
        }
        Main.map.mapView.repaint();
        this.mousePos = e.getPoint();
        this.didMove = true;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (SelectAction.isPlatformOsx() && this.mode == Mode.rotate) {
            this.mouseDragged(e);
        }
    }

    private Collection<OsmPrimitive> getNearestCollectionVirtual(Point p, boolean allSegements) {
        MapView c = Main.map.mapView;
        int snapDistance = Main.pref.getInteger("mappaint.node.virtual-snap-distance", 8);
        snapDistance *= snapDistance;
        OsmPrimitive osm = c.getNearestNode(p);
        this.virtualWays.clear();
        this.virtualNode = null;
        Node virtualWayNode = null;
        if (osm == null) {
            Collection<WaySegment> nearestWaySegs = allSegements ? c.getNearestWaySegments(p) : Collections.singleton(c.getNearestWaySegment(p));
            for (WaySegment nearestWS : nearestWaySegs) {
                Point pc;
                Point p2;
                Way w;
                Point p1;
                if (nearestWS == null) continue;
                osm = nearestWS.way;
                if (Main.pref.getInteger("mappaint.node.virtual-size", 8) <= 0 || !SimplePaintVisitor.isLargeSegment(p1 = c.getPoint((w = (Way)osm).getNode(nearestWS.lowerIndex)), p2 = c.getPoint(w.getNode(nearestWS.lowerIndex + 1)), Main.pref.getInteger("mappaint.node.virtual-space", 70)).booleanValue() || !(p.distanceSq(pc = new Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2)) < (double)snapDistance)) continue;
                if (virtualWayNode != null) {
                    if (!w.getNode(nearestWS.lowerIndex + 1).equals(virtualWayNode) && !w.getNode(nearestWS.lowerIndex).equals(virtualWayNode)) {
                        continue;
                    }
                } else {
                    virtualWayNode = w.getNode(nearestWS.lowerIndex + 1);
                }
                this.virtualWays.add(nearestWS);
                if (this.virtualNode != null) continue;
                this.virtualNode = new Node(Main.map.mapView.getLatLon(pc.x, pc.y));
            }
        }
        if (osm == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(osm);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean shift;
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        Main.map.mapView.requestFocus();
        this.cancelDrawMode = false;
        if (!((Boolean)this.getValue("active")).booleanValue()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        boolean ctrl = (e.getModifiers() & 2) != 0;
        boolean alt = (e.getModifiers() & 0x28) != 0;
        boolean bl = shift = (e.getModifiers() & 1) != 0;
        if (shift || ctrl) {
            this.cancelDrawMode = true;
        }
        this.mouseDownTime = System.currentTimeMillis();
        this.didMove = false;
        this.initialMoveThresholdExceeded = false;
        Collection<OsmPrimitive> osmColl = this.getNearestCollectionVirtual(e.getPoint(), alt);
        if (ctrl && shift) {
            if (this.getCurrentDataSet().getSelected().isEmpty()) {
                this.selectPrims(osmColl, true, false, false, false);
            }
            this.mode = Mode.rotate;
            this.setCursor(ImageProvider.getCursor("rotate", null));
        } else if (!osmColl.isEmpty()) {
            this.selectPrims(osmColl, shift || this.getCurrentDataSet().getSelected().containsAll(osmColl), ctrl, false, false);
            this.mode = Mode.move;
        } else {
            this.mode = Mode.select;
            this.oldCursor = Main.map.mapView.getCursor();
            this.selectionManager.register(Main.map.mapView);
            this.selectionManager.mousePressed(e);
        }
        if (this.mode != Mode.move || shift || ctrl) {
            this.virtualNode = null;
            this.virtualWays.clear();
        }
        this.updateStatusLine();
        if (this.mode == Mode.rotate) {
            Main.map.mapView.repaint();
        }
        this.mousePos = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        if (this.mode == Mode.select) {
            this.selectionManager.unregister(Main.map.mapView);
            if (this.getCurrentDataSet().getSelected().size() == 0 && !this.cancelDrawMode) {
                Main.map.selectDrawTool(true);
                return;
            }
        }
        this.restoreCursor();
        if (this.mode == Mode.move) {
            boolean shift;
            boolean ctrl = (e.getModifiers() & 2) != 0;
            boolean bl = shift = (e.getModifiers() & 1) != 0;
            if (!this.didMove) {
                this.selectPrims(Main.map.mapView.getNearestCollection(e.getPoint()), shift, ctrl, true, false);
                ArrayList<OsmPrimitive> sel = new ArrayList<OsmPrimitive>(this.getCurrentDataSet().getSelected());
                if (e.getClickCount() >= 2 && sel.size() == 1 && sel.get(0) instanceof Node) {
                    Main.worker.execute(new Runnable(){

                        public void run() {
                            Main.map.selectDrawTool(true);
                        }
                    });
                    return;
                }
            } else {
                Collection<OsmPrimitive> selection = this.getCurrentDataSet().getSelected();
                TreeSet<OsmPrimitive> s = new TreeSet<OsmPrimitive>();
                int max = Main.pref.getInteger("warn.move.maxelements", 20);
                for (OsmPrimitive osm : selection) {
                    if (osm instanceof Node) {
                        s.add(osm);
                    } else if (osm instanceof Way) {
                        s.add(osm);
                        s.addAll(((Way)osm).getNodes());
                    }
                    if (s.size() <= max) continue;
                    ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Move elements"), new String[]{I18n.tr("Move them"), I18n.tr("Undo move")});
                    ed.setButtonIcons(new String[]{"reorder.png", "cancel.png"});
                    ed.setContent(I18n.tr("You moved more than {0} elements. Moving a large number of elements is often an error.\nReally move them?", max));
                    ed.toggleEnable("movedManyElements");
                    ed.setToggleCheckboxText(I18n.tr("Always move and don't show dialog again"));
                    ed.showDialog();
                    if (ed.getValue() == 1 || ed.getValue() == -99) break;
                    Main.main.undoRedo.undo();
                    break;
                }
                if (ctrl) {
                    Set<Node> affectedNodes = OsmPrimitive.getFilteredSet(selection, Node.class);
                    Collection<Node> nn = Main.map.mapView.getNearestNodes(e.getPoint(), affectedNodes);
                    if (nn != null) {
                        Node targetNode = nn.iterator().next();
                        HashSet<Node> nodesToMerge = new HashSet<Node>(affectedNodes);
                        nodesToMerge.add(targetNode);
                        if (!nodesToMerge.isEmpty()) {
                            Command cmd = MergeNodesAction.mergeNodes(Main.main.getEditLayer(), nodesToMerge, targetNode);
                            Main.main.undoRedo.add(cmd);
                        }
                    }
                }
                DataSet.fireSelectionChanged(selection);
            }
        }
        this.mode = null;
        this.updateStatusLine();
    }

    @Override
    public void selectionEnded(Rectangle r, boolean alt, boolean shift, boolean ctrl) {
        this.selectPrims(this.selectionManager.getObjectsInRectangle(r, alt), shift, ctrl, true, true);
    }

    public void selectPrims(Collection<OsmPrimitive> selectionList, boolean shift, boolean ctrl, boolean released, boolean area) {
        if (shift && ctrl || ctrl && !released) {
            return;
        }
        Collection<OsmPrimitive> curSel = !ctrl && !shift ? new LinkedList<OsmPrimitive>() : this.getCurrentDataSet().getSelected();
        for (OsmPrimitive osm : selectionList) {
            if (ctrl) {
                if (curSel.contains(osm)) {
                    curSel.remove(osm);
                    continue;
                }
                if (area) continue;
                curSel.add(osm);
                continue;
            }
            curSel.add(osm);
        }
        this.getCurrentDataSet().setSelected(curSel);
        Main.map.mapView.repaint();
    }

    @Override
    public String getModeHelpText() {
        if (this.mode == Mode.select) {
            return I18n.tr("Release the mouse button to select the objects in the rectangle.");
        }
        if (this.mode == Mode.move) {
            return I18n.tr("Release the mouse button to stop moving. Ctrl to merge with nearest node.");
        }
        if (this.mode == Mode.rotate) {
            return I18n.tr("Release the mouse button to stop rotating.");
        }
        return I18n.tr("Move objects by dragging; Shift to add to selection (Ctrl to toggle); Shift-Ctrl to rotate selected; or change selection");
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        move,
        rotate,
        select;

    }
}

