/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.CyclicUploadDependencyException;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationUploadOrderHook
implements UploadHook {
    private APIDataSet data;

    protected JPanel buildWarningPanel(List<Relation> dep) {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        String msg = I18n.tr("<html>{0} relations build a cycle because they refer to each other.<br>JOSM can''t upload them. Please edit the relations and remove the cyclic dependency.</html>", dep.size() - 1);
        pnl.add((Component)new JLabel(msg), "North");
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(I18n.tr("Relation ..."));
        model.addColumn(I18n.tr("... refers to relation"));
        for (int i = 0; i < dep.size() - 1; ++i) {
            Relation r1 = dep.get(i);
            Relation r2 = dep.get(i + 1);
            model.addRow(new Relation[]{r1, r2});
        }
        JTable tbl = new JTable(model);
        OsmPrimitivRenderer renderer = new OsmPrimitivRenderer();
        tbl.getColumnModel().getColumn(0).setCellRenderer(renderer);
        tbl.getColumnModel().getColumn(1).setCellRenderer(renderer);
        pnl.add((Component)new JScrollPane(tbl), "Center");
        return pnl;
    }

    protected void warnCyclicUploadDependency(CyclicUploadDependencyException e) {
        List<Relation> dep = e.getCyclicUploadDependency();
        Relation last = dep.get(dep.size() - 1);
        Iterator<Relation> it = dep.iterator();
        while (it.hasNext() && it.next() != last) {
            it.remove();
        }
        JPanel pnl = this.buildWarningPanel(dep);
        ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Cycling dependencies"), new String[]{I18n.tr("OK")});
        dialog.setContent(pnl, false);
        dialog.setButtonIcons(new String[]{"ok"});
        dialog.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(300, 300)));
        dialog.showDialog();
    }

    @Override
    public boolean checkUpload(APIDataSet apiDataSet) {
        this.data = apiDataSet;
        try {
            this.data.adjustRelationUploadOrder();
            return true;
        }
        catch (CyclicUploadDependencyException e) {
            this.warnCyclicUploadDependency(e);
            return false;
        }
    }
}

