/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.ConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletedStateConflictResolveCommand
extends ConflictResolveCommand {
    private Conflict<OsmPrimitive> conflict;
    private final MergeDecisionType decision;

    public DeletedStateConflictResolveCommand(OsmPrimitive my, OsmPrimitive their, MergeDecisionType decision) {
        this.conflict = new Conflict<OsmPrimitive>(my, their);
        this.decision = decision;
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.tr("Resolve conflicts in deleted state in {0}", this.conflict.getMy().getId()), ImageProvider.get("data", "object"), 0));
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        OsmDataLayer layer = this.getLayer();
        if (this.decision.equals((Object)MergeDecisionType.KEEP_MINE)) {
            if (this.conflict.getMy().isDeleted()) {
                layer.data.unlinkReferencesToPrimitive(this.conflict.getMy());
            }
        } else if (this.decision.equals((Object)MergeDecisionType.KEEP_THEIR)) {
            if (this.conflict.getTheir().isDeleted()) {
                layer.data.unlinkReferencesToPrimitive(this.conflict.getMy());
                this.conflict.getMy().setDeleted(true);
            } else {
                this.conflict.getMy().setDeleted(this.conflict.getTheir().isDeleted());
            }
        } else {
            throw new IllegalStateException(I18n.tr("Cannot resolve undecided conflict."));
        }
        this.rememberConflict(this.conflict);
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add(this.conflict.getMy());
    }
}

