/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveRelationMemberCommand
extends Command {
    private final Relation relation;
    private final RelationMember member;
    private int location = -1;

    public RemoveRelationMemberCommand(Relation _relation, RelationMember _member) {
        this.relation = _relation;
        this.member = _member;
    }

    public RemoveRelationMemberCommand(Relation _relation, RelationMember _member, int _location) {
        this.relation = _relation;
        this.member = _member;
        this.location = _location;
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        int removeIndex = this.relation.getMembers().indexOf(this.member);
        if (this.location != -1 && removeIndex != this.location) {
            Main.debug("error removing relation member");
            return false;
        }
        this.relation.removeMember(removeIndex);
        this.relation.setModified(true);
        return true;
    }

    @Override
    public void undoCommand() {
        super.undoCommand();
        this.relation.addMember(this.member);
        this.relation.setModified(this.getOrig(this.relation).isModified());
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    @Override
    public MutableTreeNode description() {
        String msg = "";
        switch (OsmPrimitiveType.from(this.member.getMember())) {
            case NODE: {
                msg = I18n.marktr("Remove node ''{0}'' at position {1} from relation ''{2}''");
                break;
            }
            case WAY: {
                msg = I18n.marktr("Remove way ''{0}'' at position {1} from relation ''{2}''");
                break;
            }
            case RELATION: {
                msg = I18n.marktr("Remove relation ''{0}'' at position {1} from relation ''{2}''");
            }
        }
        return new DefaultMutableTreeNode(new JLabel(I18n.tr(msg, this.member.getMember().getDisplayName(DefaultNameFormatter.getInstance()), this.relation.getMembers().indexOf(this.member), this.relation.getDisplayName(DefaultNameFormatter.getInstance())), ImageProvider.get(OsmPrimitiveType.from(this.relation)), 0));
    }
}

