/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotateCommand
extends Command {
    private Collection<Node> nodes = new LinkedList<Node>();
    private EastNorth pivot;
    private double startAngle;
    private double rotationAngle;
    private Map<Node, OldState> oldState = new HashMap<Node, OldState>();

    public RotateCommand(Collection<OsmPrimitive> objects, EastNorth start, EastNorth end) {
        this.nodes = AllNodesVisitor.getAllNodes(objects);
        this.pivot = new EastNorth(0.0, 0.0);
        for (Node n : this.nodes) {
            OldState os = new OldState();
            os.latlon = new LatLon(n.getCoor());
            os.eastNorth = n.getEastNorth();
            os.modified = n.isModified();
            this.oldState.put(n, os);
            this.pivot = this.pivot.add(os.eastNorth.east(), os.eastNorth.north());
        }
        this.pivot = new EastNorth(this.pivot.east() / (double)this.nodes.size(), this.pivot.north() / (double)this.nodes.size());
        this.rotationAngle = 1.5707963267948966;
        this.rotateAgain(start, end);
    }

    public void rotateAgain(EastNorth start, EastNorth end) {
        this.startAngle = Math.atan2(start.east() - this.pivot.east(), start.north() - this.pivot.north());
        double endAngle = Math.atan2(end.east() - this.pivot.east(), end.north() - this.pivot.north());
        this.rotationAngle += this.startAngle - endAngle;
        this.rotateNodes(false);
    }

    private void rotateNodes(boolean setModified) {
        for (Node n : this.nodes) {
            double cosPhi = Math.cos(this.rotationAngle);
            double sinPhi = Math.sin(this.rotationAngle);
            EastNorth oldEastNorth = this.oldState.get((Object)n).eastNorth;
            double x = oldEastNorth.east() - this.pivot.east();
            double y = oldEastNorth.north() - this.pivot.north();
            double nx = sinPhi * x + cosPhi * y + this.pivot.east();
            double ny = -cosPhi * x + sinPhi * y + this.pivot.north();
            n.setEastNorth(new EastNorth(nx, ny));
            if (!setModified) continue;
            n.setModified(true);
        }
    }

    @Override
    public boolean executeCommand() {
        this.rotateNodes(true);
        return true;
    }

    @Override
    public void undoCommand() {
        for (Node n : this.nodes) {
            OldState os = this.oldState.get(n);
            n.setCoor(os.latlon);
            n.setModified(os.modified);
        }
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        for (OsmPrimitive osmPrimitive : this.nodes) {
            modified.add(osmPrimitive);
        }
    }

    @Override
    public MutableTreeNode description() {
        return new DefaultMutableTreeNode(new JLabel(I18n.trn("Rotate {0} node", "Rotate {0} nodes", this.nodes.size(), this.nodes.size()), ImageProvider.get("data", "node"), 0));
    }

    public Collection<Node> getRotatedNodes() {
        return this.nodes;
    }

    public static class OldState {
        LatLon latlon;
        EastNorth eastNorth;
        boolean modified;
    }
}

