/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

public final class Node
extends OsmPrimitive {
    private CachedLatLon coor;

    public final void setCoor(LatLon coor) {
        if (coor != null) {
            if (this.coor == null) {
                this.coor = new CachedLatLon(coor);
            } else {
                this.coor.setCoor(coor);
            }
        }
    }

    public final LatLon getCoor() {
        return this.coor;
    }

    public final void setEastNorth(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.coor != null) {
                this.coor.setEastNorth(eastNorth);
            } else {
                this.coor = new CachedLatLon(eastNorth);
            }
        }
    }

    public final EastNorth getEastNorth() {
        return this.coor != null ? this.coor.getEastNorth() : null;
    }

    protected Node(long id, boolean allowNegative) {
        super(id, allowNegative);
    }

    public Node() {
        this(0L, false);
    }

    public Node(long id) {
        super(id, false);
    }

    public Node(Node clone) {
        super(clone.getUniqueId(), true);
        this.cloneFrom(clone);
    }

    public Node(LatLon latlon) {
        super(0L, false);
        this.setCoor(latlon);
    }

    public Node(EastNorth eastNorth) {
        super(0L, false);
        this.setEastNorth(eastNorth);
    }

    public Node(NodeData data, DataSet dataSet) {
        super(data);
        this.load(data, dataSet);
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public void cloneFrom(OsmPrimitive osm) {
        super.cloneFrom(osm);
        this.setCoor(((Node)osm).coor);
    }

    public void load(PrimitiveData data, DataSet dataSet) {
        super.load(data, dataSet);
        this.setCoor(((NodeData)data).getCoor());
    }

    public NodeData save() {
        NodeData data = new NodeData();
        this.saveCommonAttributes(data);
        data.setCoor(this.getCoor());
        return data;
    }

    public String toString() {
        if (this.coor == null) {
            return "{Node id=" + this.getId() + "}";
        }
        return "{Node id=" + this.getId() + ",version=" + this.getVersion() + ",lat=" + this.coor.lat() + ",lon=" + this.coor.lon() + "}";
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        if (other == null || !(other instanceof Node)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(other)) {
            return false;
        }
        Node n = (Node)other;
        if (this.coor == null && n.coor == null) {
            return true;
        }
        if (this.coor != null && n.coor != null) {
            return this.coor.equals(n.coor);
        }
        return false;
    }

    public int compareTo(OsmPrimitive o) {
        return o instanceof Node ? Long.valueOf(this.getId()).compareTo(o.getId()) : 1;
    }

    public String getDisplayName(NameFormatter formatter) {
        return formatter.format(this);
    }
}

