/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsmPrimitive
implements Comparable<OsmPrimitive>,
Tagged {
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private static final int FLAG_MODIFIED = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_DISABLED = 4;
    private static final int FLAG_DELETED = 8;
    private static final int FLAG_FILTERED = 16;
    private static final int FLAG_HAS_DIRECTIONS = 32;
    private static final int FLAG_TAGGED = 64;
    public ElemStyle mappaintStyle = null;
    public Integer mappaintVisibleCode = 0;
    public Integer mappaintDrawnCode = 0;
    public Collection<String> errors;
    private long id = 0L;
    private volatile byte flags = (byte)2;
    private User user = null;
    public boolean incomplete = false;
    private int version = 0;
    public volatile boolean highlighted = false;
    private int timestamp;
    private static Collection<String> uninteresting = null;
    private static Collection<String> directionKeys = null;
    private Map<String, String> keys;

    static long generateUniqueId() {
        return idCounter.decrementAndGet();
    }

    public static <T extends OsmPrimitive> List<T> getFilteredList(Collection<OsmPrimitive> list, Class<T> type) {
        if (list == null) {
            return Collections.emptyList();
        }
        LinkedList<T> ret = new LinkedList<T>();
        for (OsmPrimitive p : list) {
            if (!type.isInstance(p)) continue;
            ret.add(type.cast(p));
        }
        return ret;
    }

    public static <T extends OsmPrimitive> Set<T> getFilteredSet(Collection<OsmPrimitive> set, Class<T> type) {
        if (set == null) {
            return Collections.emptySet();
        }
        HashSet<T> ret = new HashSet<T>();
        for (OsmPrimitive p : set) {
            if (!type.isInstance(p)) continue;
            ret.add(type.cast(p));
        }
        return ret;
    }

    public void putError(String text, Boolean isError) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        String s = isError != false ? I18n.tr("Error: {0}", text) : I18n.tr("Warning: {0}", text);
        this.errors.add(s);
    }

    public void clearErrors() {
        this.errors = null;
    }

    protected void clearCached() {
        this.mappaintVisibleCode = 0;
        this.mappaintDrawnCode = 0;
        this.mappaintStyle = null;
    }

    protected OsmPrimitive(long id, boolean allowNegativeId) throws IllegalArgumentException {
        if (allowNegativeId) {
            this.id = id;
        } else {
            if (id < 0L) {
                throw new IllegalArgumentException(I18n.tr("Expected ID >= 0. Got {0}.", id));
            }
            this.id = id == 0L ? OsmPrimitive.generateUniqueId() : id;
        }
        this.version = 0;
        this.incomplete = id > 0L;
    }

    protected OsmPrimitive(PrimitiveData data) {
        this.version = data.getVersion();
        this.id = data.getId();
    }

    public void setDisabled(boolean disabled) {
        this.flags = disabled ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public boolean isDisabled() {
        return (this.flags & 4) != 0;
    }

    public void setFiltered(boolean filtered) {
        this.flags = filtered ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    public boolean isFiltered() {
        return (this.flags & 0x10) != 0;
    }

    public void setModified(boolean modified) {
        this.flags = modified ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public boolean isModified() {
        return (this.flags & 1) != 0;
    }

    public boolean isDeleted() {
        return (this.flags & 8) != 0;
    }

    public boolean isUsable() {
        return !this.isDeleted() && !this.incomplete && !this.isDisabled();
    }

    public boolean isVisible() {
        return (this.flags & 2) != 0;
    }

    public void setVisible(boolean visible) throws IllegalStateException {
        if (this.isNew() && !visible) {
            throw new IllegalStateException(I18n.tr("A primitive with ID = 0 can't be invisible."));
        }
        this.flags = visible ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public long getVersion() {
        return this.version;
    }

    public long getId() {
        return this.id >= 0L ? this.id : 0L;
    }

    public long getUniqueId() {
        return this.id;
    }

    public boolean isNew() {
        return this.id <= 0L;
    }

    public void setOsmId(long id, int version) {
        if (id <= 0L) {
            throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", id));
        }
        if (version <= 0) {
            throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", version));
        }
        this.id = id;
        this.version = version;
        this.incomplete = false;
    }

    public void clearOsmId() {
        this.id = OsmPrimitive.generateUniqueId();
        this.version = 0;
        this.incomplete = false;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = (int)(timestamp.getTime() / 1000L);
    }

    public Date getTimestamp() {
        return new Date((long)this.timestamp * 1000L);
    }

    public boolean isTimestampEmpty() {
        return this.timestamp == 0;
    }

    public static Collection<String> getUninterestingKeys() {
        if (uninteresting == null) {
            uninteresting = Main.pref.getCollection("tags.uninteresting", Arrays.asList("source", "note", "comment", "converted_by", "created_by"));
        }
        return uninteresting;
    }

    public static Collection<String> getDirectionKeys() {
        if (directionKeys == null) {
            directionKeys = Main.pref.getCollection("tags.direction", Arrays.asList("oneway", "incline", "incline_steep", "aerialway"));
        }
        return directionKeys;
    }

    public abstract void visit(Visitor var1);

    public void setDeleted(boolean deleted) {
        this.flags = deleted ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
        this.setModified(deleted);
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean equals(Object obj) {
        if (this.isNew()) {
            return obj == this;
        }
        if (obj instanceof OsmPrimitive) {
            return ((OsmPrimitive)obj).id == this.id && obj.getClass() == this.getClass();
        }
        return false;
    }

    public final int hashCode() {
        if (this.id == 0L) {
            return super.hashCode();
        }
        final int[] ret = new int[1];
        Visitor v = new Visitor(){

            public void visit(Node n) {
                ret[0] = 0;
            }

            public void visit(Way w) {
                ret[0] = 1;
            }

            public void visit(Relation e) {
                ret[0] = 2;
            }

            public void visit(Changeset cs) {
                ret[0] = 3;
            }
        };
        this.visit(v);
        return this.id == 0L ? super.hashCode() : (int)(this.id << 2) + ret[0];
    }

    @Override
    public Map<String, String> getKeys() {
        if (this.keys == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(this.keys);
    }

    @Override
    public void setKeys(Map<String, String> keys) {
        this.keys = keys == null ? null : new HashMap<String, String>(keys);
        this.keysChangedImpl();
    }

    @Override
    public final void put(String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.remove(key);
        } else {
            if (this.keys == null) {
                this.keys = new HashMap<String, String>();
            }
            this.keys.put(key, value);
        }
        this.mappaintStyle = null;
        this.keysChangedImpl();
    }

    @Override
    public final void remove(String key) {
        if (this.keys != null) {
            this.keys.remove(key);
            if (this.keys.isEmpty()) {
                this.keys = null;
            }
        }
        this.mappaintStyle = null;
        this.keysChangedImpl();
    }

    @Override
    public final void removeAll() {
        this.keys = null;
        this.mappaintStyle = null;
        this.keysChangedImpl();
    }

    @Override
    public final String get(String key) {
        if (key == null) {
            return null;
        }
        return this.keys == null ? null : this.keys.get(key);
    }

    public final Collection<Map.Entry<String, String>> entrySet() {
        if (this.keys == null) {
            return Collections.emptyList();
        }
        return this.keys.entrySet();
    }

    @Override
    public final Collection<String> keySet() {
        if (this.keys == null) {
            return Collections.emptyList();
        }
        return this.keys.keySet();
    }

    @Override
    public final boolean hasKeys() {
        return this.keys != null && !this.keys.isEmpty();
    }

    private void keysChangedImpl() {
        this.updateHasDirectionKeys();
        this.updateTagged();
    }

    public void cloneFrom(OsmPrimitive osm) {
        this.keys = osm.keys == null ? null : new HashMap<String, String>(osm.keys);
        this.id = osm.id;
        this.timestamp = osm.timestamp;
        this.version = osm.version;
        this.incomplete = osm.incomplete;
        this.flags = osm.flags;
        this.user = osm.user;
        this.clearCached();
        this.clearErrors();
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive other) {
        if (!this.isNew() && this.id != other.id) {
            return false;
        }
        if (this.incomplete && !other.incomplete || !this.incomplete && other.incomplete) {
            return false;
        }
        return this.keys == null ? other.keys == null : this.keys.equals(other.keys);
    }

    public boolean hasEqualTechnicalAttributes(OsmPrimitive other) {
        if (other == null) {
            return false;
        }
        return this.isDeleted() == other.isDeleted() && this.isModified() == other.isModified() && this.timestamp == other.timestamp && this.version == other.version && this.isVisible() == other.isVisible() && (this.user == null ? other.user == null : this.user == other.user);
    }

    private void updateTagged() {
        OsmPrimitive.getUninterestingKeys();
        if (this.keys != null) {
            for (Map.Entry<String, String> e : this.keys.entrySet()) {
                if (uninteresting.contains(e.getKey())) continue;
                this.flags = (byte)(this.flags | 0x40);
                return;
            }
        }
        this.flags = (byte)(this.flags & 0xFFFFFFBF);
    }

    public boolean isTagged() {
        return (this.flags & 0x40) != 0;
    }

    private void updateHasDirectionKeys() {
        OsmPrimitive.getDirectionKeys();
        if (this.keys != null) {
            for (Map.Entry<String, String> e : this.keys.entrySet()) {
                if (!directionKeys.contains(e.getKey())) continue;
                this.flags = (byte)(this.flags | 0x20);
                return;
            }
        }
        this.flags = (byte)(this.flags & 0xFFFFFFDF);
    }

    public boolean hasDirectionKeys() {
        return (this.flags & 0x20) != 0;
    }

    public String getName() {
        if (this.get("name") != null) {
            return this.get("name");
        }
        return null;
    }

    public String getLocalName() {
        String key = "name:" + Locale.getDefault().toString();
        if (this.get(key) != null) {
            return this.get(key);
        }
        key = "name:" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        if (this.get(key) != null) {
            return this.get(key);
        }
        key = "name:" + Locale.getDefault().getLanguage();
        if (this.get(key) != null) {
            return this.get(key);
        }
        return this.getName();
    }

    public abstract String getDisplayName(NameFormatter var1);

    public void load(PrimitiveData data, DataSet dataSet) {
        this.setKeys(data.getKeys());
        this.timestamp = data.getTimestamp();
        this.user = data.getUser();
        this.setDeleted(data.isDeleted());
        this.setModified(data.isModified());
        this.setVisible(data.isVisible());
    }

    public abstract PrimitiveData save();

    protected void saveCommonAttributes(PrimitiveData data) {
        data.setId(this.id);
        data.getKeys().clear();
        data.getKeys().putAll(this.getKeys());
        data.setTimestamp(this.timestamp);
        data.setUser(this.user);
        data.setDeleted(this.isDeleted());
        data.setModified(this.isModified());
        data.setVisible(this.isVisible());
    }
}

