/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadBuckets<T extends OsmPrimitive>
implements Collection<T> {
    public static boolean debug = false;
    static boolean consistency_testing = false;
    long last_out = -1L;
    public static int NR_LEVELS = 24;
    public static double WORLD_PARTS = 1 << NR_LEVELS;
    public static int MAX_OBJECTS_PER_LEVEL = 16;
    public static int TILES_PER_LEVEL_SHIFT = 2;
    public static int TILES_PER_LEVEL = 1 << TILES_PER_LEVEL_SHIFT;
    private QBLevel root;
    private QBLevel search_cache;

    static void abort(String s) {
        QuadBuckets.out(s);
        Object o = null;
        o.hashCode();
    }

    static void out(String s) {
        System.out.println(s);
    }

    void pout(String s) {
        long now = System.currentTimeMillis();
        if (now - this.last_out < 300L) {
            return;
        }
        this.last_out = now;
        System.out.print(s + "\r");
    }

    void pout(String s, int i, int total) {
        long now = System.currentTimeMillis();
        if (now - this.last_out < 300L && i + 1 < total) {
            return;
        }
        this.last_out = now;
        System.out.print(s + " " + (float)((double)(i + 1) * 100.0 / (double)total) + "% done    \r");
    }

    public QuadBuckets() {
        this.clear();
    }

    @Override
    public void clear() {
        this.root = new QBLevel(null);
        this.search_cache = null;
        if (debug) {
            QuadBuckets.out("QuadBuckets() cleared: " + this);
            QuadBuckets.out("root: " + this.root + " level: " + this.root.level + " bbox: " + this.root.bbox());
        }
    }

    @Override
    public boolean add(T n) {
        if (debug) {
            QuadBuckets.out("QuadBuckets() add: " + n + " size now: " + this.size());
        }
        int before_size = -1;
        if (consistency_testing) {
            before_size = this.root.size();
        }
        boolean ret = !((OsmPrimitive)n).isUsable() ? this.root.add_content(n) : this.root.add(n);
        if (consistency_testing) {
            int end_size = this.root.size();
            if (ret) {
                --end_size;
            }
            if (before_size != end_size) {
                QuadBuckets.abort("size inconsistency before add: " + before_size + " after: " + end_size);
            }
        }
        if (debug) {
            QuadBuckets.out("QuadBuckets() add: " + n + " size after: " + this.size());
        }
        return ret;
    }

    public void reindex() {
        QBLevel newroot = new QBLevel(null);
        for (OsmPrimitive o : this) {
            newroot.add(o);
        }
        this.root = newroot;
    }

    public void unsupported() {
        QuadBuckets.out("unsupported operation");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection objects) {
        for (OsmPrimitive o : this) {
            if (objects.contains(o) || this.remove((T)o)) continue;
            return false;
        }
        return true;
    }

    boolean canStore(Object o) {
        if (o instanceof Way) {
            return true;
        }
        return o instanceof Node;
    }

    @Override
    public boolean removeAll(Collection objects) {
        for (Object o : objects) {
            if (!this.canStore(o)) {
                return false;
            }
            if (this.remove(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection objects) {
        for (Object o : objects) {
            if (!this.canStore(o)) {
                return false;
            }
            if (this.add(this.convert(o))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection objects) {
        boolean ret = true;
        for (Object o : objects) {
            if (!this.canStore(o)) {
                return false;
            }
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    private void check_type(Object o) {
        if (this.canStore(o)) {
            return;
        }
        this.unsupported();
    }

    private T convert(Object raw) {
        return (T)((OsmPrimitive)raw);
    }

    @Override
    public boolean remove(Object o) {
        this.check_type(o);
        return this.remove(this.convert(o));
    }

    @Override
    public boolean remove(T n) {
        QBLevel bucket = this.root.find_exact(n);
        if (bucket == null) {
            return false;
        }
        boolean ret = bucket.remove_content(n);
        return ret;
    }

    @Override
    public boolean contains(Object o) {
        if (!this.canStore(o)) {
            return false;
        }
        QBLevel bucket = this.root.find_exact(this.convert(o));
        return bucket != null;
    }

    public ArrayList<T> toArrayList() {
        ArrayList<OsmPrimitive> a = new ArrayList<OsmPrimitive>();
        for (OsmPrimitive n : this) {
            a.add(n);
        }
        if (debug) {
            QuadBuckets.out("returning array list with size: " + a.size());
        }
        return a;
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] template) {
        return this.toArrayList().toArray(template);
    }

    @Override
    public Iterator<T> iterator() {
        return new QuadBucketIterator(this);
    }

    @Override
    public int size() {
        int ret = this.root.size();
        if (debug) {
            QuadBuckets.out(this + " QuadBuckets size: " + ret);
        }
        return ret;
    }

    public int size_iter() {
        int count = 0;
        Iterator<T> i = this.iterator();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public BBox search_to_bbox(LatLon point, double radius) {
        BBox bbox = new BBox(point.lon() - radius, point.lat() - radius, point.lon() + radius, point.lat() + radius);
        if (debug) {
            QuadBuckets.out("search bbox before sanity: " + bbox);
        }
        bbox.sanity();
        if (debug) {
            QuadBuckets.out("search bbox after sanity: " + bbox);
        }
        return bbox;
    }

    List<T> search(Way w) {
        BBox way_bbox = new BBox(w);
        return this.search(way_bbox);
    }

    public List<T> search(Node n, double radius) {
        return this.search(n.getCoor(), radius);
    }

    public List<T> search(LatLon point, double radius) {
        if (point == null) {
            return Collections.emptyList();
        }
        return this.search(this.search_to_bbox(point, radius));
    }

    public List<T> search(LatLon b1, LatLon b2) {
        BBox bbox = new BBox(b1.lon(), b1.lat(), b2.lon(), b2.lat());
        bbox.sanity();
        return this.search(bbox);
    }

    List<T> search(BBox search_bbox) {
        ArrayList ret;
        boolean cache_searches;
        if (debug) {
            QuadBuckets.out("qb root search at " + search_bbox);
            QuadBuckets.out("root bbox: " + this.root.bbox());
        }
        if (cache_searches = true) {
            if (this.search_cache == null) {
                this.search_cache = this.root;
            }
            while (!this.search_cache.bbox().bounds(search_bbox)) {
                QuadBuckets.out("bbox: " + search_bbox);
                if (debug) {
                    QuadBuckets.out("search_cache: " + this.search_cache + " level: " + this.search_cache.level);
                    QuadBuckets.out("search_cache.bbox(): " + this.search_cache.bbox());
                }
                this.search_cache = this.search_cache.parent;
                if (!debug) continue;
                QuadBuckets.out("new search_cache: " + this.search_cache);
            }
        } else {
            this.search_cache = this.root;
        }
        if ((ret = this.search_cache.search(search_bbox)) == null) {
            ret = new ArrayList();
        }
        QBLevel tmp = this.search_cache.parent;
        while (tmp != null) {
            List content_result = tmp.search_contents(search_bbox);
            if (content_result != null) {
                ret.addAll(content_result);
            }
            tmp = tmp.parent;
        }
        if (ret == null || ret.size() == 0) {
            return Collections.emptyList();
        }
        if (debug) {
            QuadBuckets.out("search of QuadBuckets for " + search_bbox + " ret len: " + ret.size());
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QuadBucketIterator
    implements Iterator<T> {
        QBLevel current_node;
        int content_index;
        int iterated_over;

        QBLevel next_content_node(QBLevel q) {
            if (q == null) {
                return null;
            }
            QBLevel orig = q;
            QBLevel next = q.nextContentNode();
            if (orig == next) {
                QuadBuckets.abort("got same leaf back leaf: " + q.isLeaf());
            }
            return next;
        }

        public QuadBucketIterator(QuadBuckets<T> qb) {
            if (debug) {
                QuadBuckets.out(this + " is a new iterator qb: " + qb + " size: " + qb.size());
            }
            this.current_node = qb.root.isLeaf() || qb.root.hasContent() ? qb.root : this.next_content_node(qb.root);
            if (debug) {
                QuadBuckets.out("\titerator first leaf: " + this.current_node);
            }
            this.iterated_over = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.peek() == null) {
                if (debug) {
                    QuadBuckets.out(this + " no hasNext(), but iterated over so far: " + this.iterated_over);
                }
                return false;
            }
            return true;
        }

        T peek() {
            if (this.current_node == null) {
                if (debug) {
                    QuadBuckets.out("null current leaf, nowhere to go");
                }
                return null;
            }
            while (this.current_node.content == null || this.content_index >= this.current_node.content.size()) {
                if (debug) {
                    QuadBuckets.out("moving to next leaf");
                }
                this.content_index = 0;
                this.current_node = this.next_content_node(this.current_node);
                if (this.current_node != null) continue;
            }
            if (this.current_node == null || this.current_node.content == null) {
                if (debug) {
                    QuadBuckets.out("late nowhere to go " + this.current_node);
                }
                return null;
            }
            return (OsmPrimitive)this.current_node.content.get(this.content_index);
        }

        @Override
        public T next() {
            Object ret = this.peek();
            ++this.content_index;
            if (debug) {
                QuadBuckets.out("iteration[" + this.iterated_over + "] " + this.content_index + " leaf: " + this.current_node);
            }
            ++this.iterated_over;
            if (ret == null && debug) {
                QuadBuckets.out(this + " no next node, but iterated over so far: " + this.iterated_over);
            }
            return ret;
        }

        @Override
        public void remove() {
            --this.content_index;
            Object object = this.peek();
            this.current_node.content.remove(this.content_index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QBLevel {
        int level;
        long quad;
        QBLevel parent;
        public List<T> content;
        public QBLevel[] children;
        HashMap<Way, BBox> way_bbox_cache = new HashMap();
        double width = Double.NEGATIVE_INFINITY;
        BBox bbox = null;

        public String toString() {
            return super.toString() + "[" + this.level + "]: " + this.bbox;
        }

        public QBLevel(QBLevel parent) {
            this.init(parent);
        }

        String quads(T o) {
            if (o instanceof Node) {
                LatLon coor = ((Node)o).getCoor();
                if (coor == null) {
                    return "null node coordinates";
                }
                return Long.toHexString(QuadTiling.quadTile(coor));
            }
            return "Way??";
        }

        boolean remove_content(T o) {
            boolean ret = this.content.remove(o);
            if (this.content.size() == 0) {
                this.content = null;
            }
            return ret;
        }

        int get_index(T o, int level) {
            if (debug) {
                QuadBuckets.out("getting index for " + o + " at level: " + level);
            }
            if (o instanceof Node) {
                Node n = (Node)o;
                LatLon coor = ((Node)o).getCoor();
                if (coor == null) {
                    return -1;
                }
                return QuadTiling.index(coor, level);
            }
            if (o instanceof Way) {
                Way w = (Way)o;
                int index = -1;
                for (LatLon c : this.way_bbox(w).points()) {
                    if (debug) {
                        QuadBuckets.out("getting index for point: " + c);
                    }
                    if (index == -1) {
                        index = QuadTiling.index(c, level);
                        if (!debug) continue;
                        QuadBuckets.out("set initial way index to: " + index);
                        continue;
                    }
                    int node_index = QuadTiling.index(c, level);
                    if (debug) {
                        QuadBuckets.out("other node way index: " + node_index);
                    }
                    if (node_index == index) continue;
                    if (debug) {
                        QuadBuckets.out("way (" + w.getId() + ") would have gone across two quads " + node_index + "/" + index + " at level: " + level + "    ");
                        QuadBuckets.out("node count: " + w.getNodes().size());
                        for (LatLon c2 : this.way_bbox(w).points()) {
                            QuadBuckets.out("points: " + c2);
                        }
                    }
                    return -1;
                }
                return index;
            }
            QuadBuckets.abort("bad primitive: " + o);
            return -1;
        }

        void split() {
            if (debug) {
                QuadBuckets.out("splitting " + this.bbox() + " level " + this.level + " with " + this.content.size() + " entries (my dimensions: " + this.bbox.width() + ", " + this.bbox.height() + ")");
            }
            if (this.children != null) {
                QuadBuckets.abort("overwrote children");
            }
            this.children = (QBLevel[])Array.newInstance(this.getClass(), QuadTiling.TILES_PER_LEVEL);
            List tmpcontent = this.content;
            this.content = null;
            for (OsmPrimitive o : tmpcontent) {
                int new_index = this.get_index(o, this.level);
                if (new_index == -1) {
                    this.add_content(o);
                    continue;
                }
                if (this.children[new_index] == null) {
                    this.children[new_index] = new QBLevel(this, new_index);
                }
                QBLevel child = this.children[new_index];
                if (debug) {
                    QuadBuckets.out("putting " + o + "(q:" + this.quads(o) + ") into [" + new_index + "] " + child.bbox());
                }
                child.add(o);
            }
        }

        boolean add_content(T o) {
            boolean ret = false;
            if (this.content == null) {
                this.content = new LinkedList();
            }
            ret = this.content.add(o);
            if (debug && !this.isLeaf()) {
                QuadBuckets.this.pout("added " + o.getClass().getName() + " to non-leaf with size: " + this.content.size());
            }
            return ret;
        }

        void add_to_leaf(T o) {
            QBLevel ret = this;
            this.add_content(o);
            if (this.content.size() > MAX_OBJECTS_PER_LEVEL) {
                int after_size;
                if (debug) {
                    QuadBuckets.out("[" + this.level + "] deciding to split");
                }
                if (this.level >= NR_LEVELS - 1) {
                    QuadBuckets.out("can not split, but too deep: " + this.level + " size: " + this.content.size());
                    return;
                }
                int before_size = -1;
                if (consistency_testing) {
                    before_size = this.size();
                }
                this.split();
                if (consistency_testing && before_size != (after_size = this.size())) {
                    QuadBuckets.abort("[" + this.level + "] split done before: " + before_size + " after: " + after_size);
                }
                return;
            }
        }

        BBox way_bbox(Way w) {
            BBox b;
            if (this.way_bbox_cache.size() > 100) {
                this.way_bbox_cache.clear();
            }
            if ((b = this.way_bbox_cache.get(w)) == null) {
                b = new BBox(w);
                this.way_bbox_cache.put(w, b);
            }
            return b;
        }

        boolean matches(T o, BBox search_bbox) {
            if (o instanceof Node) {
                LatLon coor = ((Node)o).getCoor();
                if (coor == null) {
                    return false;
                }
                return search_bbox.bounds(coor);
            }
            if (o instanceof Way) {
                BBox bbox = this.way_bbox((Way)o);
                return bbox.intersects(search_bbox);
            }
            QuadBuckets.abort("matches() bad primitive: " + o);
            return false;
        }

        private List<T> search_contents(BBox search_bbox) {
            String size = "null";
            if (this.content != null) {
                size = "" + this.content.size();
            }
            if (debug) {
                QuadBuckets.out("searching contents (size: " + size + ") for " + search_bbox);
            }
            if (this.content == null) {
                return null;
            }
            LinkedList<OsmPrimitive> ret = new LinkedList<OsmPrimitive>();
            for (OsmPrimitive o : this.content) {
                if (!this.matches(o, search_bbox)) continue;
                ret.add(o);
            }
            if (debug) {
                QuadBuckets.out("done searching quad " + Long.toHexString(this.quad));
            }
            return ret;
        }

        boolean isLeaf() {
            return this.children == null;
        }

        QBLevel next_sibling() {
            boolean found_me = false;
            if (this.parent == null) {
                return null;
            }
            int __nr = 0;
            for (QBLevel sibling : this.parent.children) {
                int nr = ++__nr - 1;
                if (sibling == null) {
                    if (!debug) continue;
                    QuadBuckets.out("[" + this.level + "] null child nr: " + nr);
                    continue;
                }
                if (sibling == this) {
                    if (debug) {
                        QuadBuckets.out("[" + this.level + "] I was child nr: " + nr);
                    }
                    found_me = true;
                    continue;
                }
                if (found_me) {
                    if (debug) {
                        QuadBuckets.out("[" + this.level + "] next sibling was child nr: " + nr);
                    }
                    return sibling;
                }
                if (!debug) continue;
                QuadBuckets.out("[" + this.level + "] nr: " + nr + " is before me, ignoring...");
            }
            return null;
        }

        boolean hasContent() {
            return this.content != null;
        }

        QBLevel nextContentNode() {
            QBLevel next = this;
            if (this.isLeaf()) {
                QBLevel sibling = next.next_sibling();
                while (sibling == null) {
                    if (debug) {
                        QuadBuckets.out("no siblings at level[" + next.level + "], moving to parent");
                    }
                    if ((next = next.parent) == null) break;
                    sibling = next.next_sibling();
                }
                next = sibling;
            }
            if (next == null) {
                return null;
            }
            block1: while (!(next.isLeaf() || next.hasContent() && next != this)) {
                if (debug) {
                    QuadBuckets.out("[" + next.level + "] next node (" + next + ") is a branch (content: " + next.hasContent() + "), moving down...");
                }
                for (QBLevel child : next.children) {
                    if (child == null) continue;
                    next = child;
                    continue block1;
                }
            }
            return next;
        }

        int size() {
            if (this.isLeaf()) {
                return this.size_leaf();
            }
            return this.size_branch();
        }

        private int size_leaf() {
            if (this.content == null) {
                if (debug) {
                    QuadBuckets.out("[" + this.level + "] leaf size: null content, children? " + this.children);
                }
                return 0;
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] leaf size: " + this.content.size());
            }
            return this.content.size();
        }

        private int size_branch() {
            int ret = 0;
            for (QBLevel l : this.children) {
                if (l == null) continue;
                ret += l.size();
            }
            if (this.content != null) {
                ret += this.content.size();
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] branch size: " + ret);
            }
            return ret;
        }

        boolean contains(T n) {
            QBLevel res = this.find_exact(n);
            return res != null;
        }

        QBLevel find_exact(T n) {
            if (this.isLeaf()) {
                return this.find_exact_leaf(n);
            }
            return this.find_exact_branch(n);
        }

        QBLevel find_exact_leaf(T n) {
            QBLevel ret = null;
            if (this.content != null && this.content.contains(n)) {
                ret = this;
            }
            return ret;
        }

        QBLevel find_exact_branch(T n) {
            if (this.content != null && this.content.contains(n)) {
                return this;
            }
            QBLevel ret = null;
            for (QBLevel l : this.children) {
                if (l != null && (ret = l.find_exact(n)) != null) break;
            }
            return ret;
        }

        boolean add(T n) {
            if (consistency_testing && !this.matches(n, this.bbox())) {
                QuadBuckets.out("-----------------------------");
                debug = true;
                this.get_index(n, this.level);
                QuadBuckets.abort("object " + n + " does not belong in node at level: " + this.level + " bbox: " + this.bbox());
            }
            if (this.isLeaf()) {
                this.add_to_leaf(n);
            } else {
                this.add_to_branch(n);
            }
            return true;
        }

        QBLevel add_to_branch(T n) {
            int index = this.get_index(n, this.level);
            if (index == -1) {
                if (debug) {
                    QuadBuckets.out("unable to get index for " + n + "at level: " + this.level + ", adding content to branch: " + this);
                }
                this.add_content(n);
                return this;
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "]: " + n + " index " + index + " levelquad:" + this.quads() + " level bbox:" + this.bbox());
                QuadBuckets.out("   put in child[" + index + "]");
            }
            if (this.children[index] == null) {
                this.children[index] = new QBLevel(this, index);
            }
            this.children[index].add(n);
            return this;
        }

        private List<T> search(BBox search_bbox) {
            List ret = null;
            if (debug) {
                System.out.print("[" + this.level + "] qb bbox: " + this.bbox() + " ");
            }
            if (!this.bbox().intersects(search_bbox)) {
                if (debug) {
                    QuadBuckets.out("miss " + Long.toHexString(this.quad));
                }
                return ret;
            }
            if (this.hasContent()) {
                ret = this.search_contents(search_bbox);
            }
            if (this.isLeaf()) {
                return ret;
            }
            if (debug) {
                QuadBuckets.out("hit " + this.quads());
            }
            if (debug) {
                QuadBuckets.out("[" + this.level + "] not leaf, moving down");
            }
            for (int i = 0; i < this.children.length; ++i) {
                List coors;
                QBLevel q = this.children[i];
                if (debug) {
                    QuadBuckets.out("child[" + i + "]: " + q);
                }
                if (q == null) continue;
                if (debug) {
                    System.out.print(i + ": ");
                }
                if ((coors = q.search(search_bbox)) == null) continue;
                if (ret == null) {
                    ret = coors;
                } else {
                    ret.addAll(coors);
                }
                if (!q.bbox().bounds(search_bbox)) continue;
                QuadBuckets.this.search_cache = q;
                if (coors.size() <= 0) continue;
                if (!debug) break;
                QuadBuckets.out("break early");
                break;
            }
            return ret;
        }

        public String quads() {
            return Long.toHexString(this.quad);
        }

        public void init(QBLevel parent) {
            this.parent = parent;
            this.level = parent == null ? 0 : parent.level + 1;
            this.quad = 0L;
        }

        int index_of(QBLevel find_this) {
            if (this.isLeaf()) {
                return -1;
            }
            for (int i = 0; i < QuadTiling.TILES_PER_LEVEL; ++i) {
                if (this.children[i] != find_this) continue;
                return i;
            }
            return -1;
        }

        public QBLevel(QBLevel parent, int parent_index) {
            this.init(parent);
            int shift = (NR_LEVELS - this.level) * 2;
            long mult = 1L;
            if (shift >= 30) {
                shift -= 30;
                mult = 0x40000000L;
            }
            long this_quadpart = mult * (long)(parent_index << shift);
            this.quad = parent.quad | this_quadpart;
            if (debug) {
                QuadBuckets.out("new level[" + this.level + "] bbox[" + parent_index + "]: " + this.bbox() + " coor: " + this.coor() + " quadpart: " + Long.toHexString(this_quadpart) + " quad: " + Long.toHexString(this.quad));
            }
        }

        double width() {
            if (this.width != Double.NEGATIVE_INFINITY) {
                return this.width;
            }
            this.width = this.level == 0 ? this.bbox().width() : this.parent.width() / 2.0;
            return this.width;
        }

        double height() {
            return this.width() / 2.0;
        }

        public BBox bbox() {
            if (this.bbox != null) {
                this.bbox.sanity();
                return this.bbox;
            }
            if (this.level == 0) {
                this.bbox = new BBox(-180.0, 90.0, 180.0, -90.0);
            } else {
                LatLon bottom_left = this.coor();
                double lat = bottom_left.lat() + this.height();
                double lon = bottom_left.lon() + this.width();
                LatLon top_right = new LatLon(lat, lon);
                this.bbox = new BBox(bottom_left, top_right);
            }
            this.bbox.sanity();
            return this.bbox;
        }

        LatLon coor() {
            return QuadTiling.tile2LatLon(this.quad);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BBox {
        private double xmin;
        private double xmax;
        private double ymin;
        private double ymax;

        void sanity() {
            if (this.xmin < -180.0) {
                this.xmin = -180.0;
            }
            if (this.xmax > 180.0) {
                this.xmax = 180.0;
            }
            if (this.ymin < -90.0) {
                this.ymin = -90.0;
            }
            if (this.ymax > 90.0) {
                this.ymax = 90.0;
            }
            if (this.xmin < -180.0 || this.xmax > 180.0 || this.ymin < -90.0 || this.ymax > 90.0) {
                QuadBuckets.out("bad BBox: " + this);
                Object o = null;
                o.hashCode();
            }
        }

        public String toString() {
            return "[ x: " + this.xmin + " -> " + this.xmax + ", y: " + this.ymin + " -> " + this.ymax + " ]";
        }

        double min(double a, double b) {
            if (a < b) {
                return a;
            }
            return b;
        }

        double max(double a, double b) {
            if (a > b) {
                return a;
            }
            return b;
        }

        private void add(LatLon c) {
            this.xmin = this.min(this.xmin, c.lon());
            this.xmax = this.max(this.xmax, c.lon());
            this.ymin = this.min(this.ymin, c.lat());
            this.ymax = this.max(this.ymax, c.lat());
        }

        public BBox(LatLon a, LatLon b) {
            this.xmin = Double.POSITIVE_INFINITY;
            this.xmax = Double.NEGATIVE_INFINITY;
            this.ymin = Double.POSITIVE_INFINITY;
            this.ymax = Double.NEGATIVE_INFINITY;
            this.add(a);
            this.add(b);
            this.sanity();
        }

        public BBox(double a_x, double a_y, double b_x, double b_y) {
            this.xmin = Double.POSITIVE_INFINITY;
            this.xmax = Double.NEGATIVE_INFINITY;
            this.ymin = Double.POSITIVE_INFINITY;
            this.ymax = Double.NEGATIVE_INFINITY;
            this.xmin = this.min(a_x, b_x);
            this.xmax = this.max(a_x, b_x);
            this.ymin = this.min(a_y, b_y);
            this.ymax = this.max(a_y, b_y);
            this.sanity();
        }

        public BBox(Way w) {
            this.xmin = Double.POSITIVE_INFINITY;
            this.xmax = Double.NEGATIVE_INFINITY;
            this.ymin = Double.POSITIVE_INFINITY;
            this.ymax = Double.NEGATIVE_INFINITY;
            for (Node n : w.getNodes()) {
                LatLon coor = n.getCoor();
                if (coor == null) continue;
                this.add(coor);
            }
            this.sanity();
        }

        public double height() {
            return this.ymax - this.ymin;
        }

        public double width() {
            return this.xmax - this.xmin;
        }

        boolean bounds(BBox b) {
            return this.xmin <= b.xmin && this.xmax >= b.xmax && this.ymin <= b.ymin && this.ymax >= b.ymax;
        }

        boolean bounds(LatLon c) {
            return this.xmin <= c.lon() && this.xmax >= c.lon() && this.ymin <= c.lat() && this.ymax >= c.lat();
        }

        boolean inside(BBox b) {
            if (this.xmin >= b.xmax) {
                return false;
            }
            if (this.xmax <= b.xmin) {
                return false;
            }
            if (this.ymin >= b.ymax) {
                return false;
            }
            return !(this.ymax <= b.ymin);
        }

        boolean intersects(BBox b) {
            return this.inside(b) || b.inside(this);
        }

        List<LatLon> points() {
            LatLon p1 = new LatLon(this.ymin, this.xmin);
            LatLon p2 = new LatLon(this.ymin, this.xmax);
            LatLon p3 = new LatLon(this.ymax, this.xmin);
            LatLon p4 = new LatLon(this.ymax, this.xmax);
            ArrayList<LatLon> ret = new ArrayList<LatLon>();
            ret.add(p1);
            ret.add(p2);
            ret.add(p3);
            ret.add(p4);
            return ret;
        }
    }
}

