/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class HistoryDataSet {
    private static HistoryDataSet historyDataSet;
    private HashMap<Long, ArrayList<HistoryOsmPrimitive>> data = new HashMap();
    private CopyOnWriteArrayList<HistoryDataSetListener> listeners = new CopyOnWriteArrayList();

    public static HistoryDataSet getInstance() {
        if (historyDataSet == null) {
            historyDataSet = new HistoryDataSet();
        }
        return historyDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryDataSetListener(HistoryDataSetListener listener) {
        CopyOnWriteArrayList<HistoryDataSetListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryDataSetListener(HistoryDataSetListener listener) {
        CopyOnWriteArrayList<HistoryDataSetListener> copyOnWriteArrayList = this.listeners;
        synchronized (copyOnWriteArrayList) {
            if (this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
        }
    }

    protected void fireHistoryUpdated(long id) {
        for (HistoryDataSetListener l : this.listeners) {
            l.historyUpdated(this, id);
        }
    }

    public HistoryOsmPrimitive get(long id, long version) throws NoSuchElementException {
        ArrayList<HistoryOsmPrimitive> versions = this.data.get(id);
        if (versions == null) {
            throw new NoSuchElementException(I18n.tr("Didn't find an primitive with id {0} in this dataset", id));
        }
        for (HistoryOsmPrimitive primitive : versions) {
            if (!primitive.matches(id, version)) continue;
            return primitive;
        }
        throw new NoSuchElementException(I18n.tr("Didn't find an primitive with id {0} and version {1} in this dataset", id, version));
    }

    public void put(HistoryOsmPrimitive primitive) {
        if (this.data.get(primitive.getId()) == null) {
            this.data.put(primitive.getId(), new ArrayList());
        }
        this.data.get(primitive.getId()).add(primitive);
        this.fireHistoryUpdated(primitive.getId());
    }

    public History getHistory(long id) {
        ArrayList<HistoryOsmPrimitive> versions = this.data.get(id);
        if (versions == null) {
            return null;
        }
        return new History(id, versions);
    }

    public void mergeInto(HistoryDataSet other) {
        if (other == null) {
            return;
        }
        for (Long id : other.data.keySet()) {
            this.data.put(id, other.data.get(id));
        }
        this.fireHistoryUpdated(0L);
    }
}

