/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.SimplePaintVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.IconElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPaintVisitor
extends SimplePaintVisitor {
    protected boolean useRealWidth;
    protected boolean zoomLevelDisplay;
    protected int fillAreas;
    protected boolean drawMultipolygon;
    protected boolean drawRestriction;
    protected boolean leftHandTraffic;
    protected int showNames;
    protected int showIcons;
    protected int useStrokes;
    protected int fillAlpha;
    protected Color untaggedColor;
    protected Color textColor;
    protected Color areaTextColor;
    protected float[] currentDashed = new float[0];
    protected Color currentDashedColor;
    protected int currentWidth = 0;
    protected Stroke currentStroke = null;
    protected Font orderFont;
    protected ElemStyles.StyleSet styles;
    protected double circum;
    protected double dist;
    protected Collection<String> regionalNameOrder;
    protected Boolean selectedCall;
    protected Boolean useStyleCache;
    private static int paintid = 0;
    private static int viewid = 0;
    private EastNorth minEN;
    private EastNorth maxEN;
    DataSet data;

    protected boolean isZoomOk(ElemStyle e) {
        if (!this.zoomLevelDisplay) {
            return true;
        }
        if (e == null) {
            return this.circum < 1500.0;
        }
        return !(this.circum >= (double)e.maxScale) && !(this.circum < (double)e.minScale);
    }

    public ElemStyle getPrimitiveStyle(OsmPrimitive osm) {
        if (!this.useStyleCache.booleanValue()) {
            return this.styles != null ? this.styles.get(osm) : null;
        }
        if (osm.mappaintStyle == null && this.styles != null) {
            osm.mappaintStyle = this.styles.get(osm);
            if (osm instanceof Way) {
                ((Way)osm).isMappaintArea = this.styles.isArea(osm);
            }
        }
        return osm.mappaintStyle;
    }

    public IconElemStyle getPrimitiveNodeStyle(OsmPrimitive osm) {
        if (!this.useStyleCache.booleanValue()) {
            return this.styles != null ? this.styles.getIcon(osm) : null;
        }
        if (osm.mappaintStyle == null && this.styles != null) {
            osm.mappaintStyle = this.styles.getIcon(osm);
        }
        return (IconElemStyle)osm.mappaintStyle;
    }

    public boolean isPrimitiveArea(Way osm) {
        if (!this.useStyleCache.booleanValue()) {
            return this.styles.isArea(osm);
        }
        if (osm.mappaintStyle == null && this.styles != null) {
            osm.mappaintStyle = this.styles.get(osm);
            osm.isMappaintArea = this.styles.isArea(osm);
        }
        return osm.isMappaintArea;
    }

    @Override
    public void visit(Node n) {
        if (n.getEastNorth().east() > this.maxEN.east() || n.getEastNorth().north() > this.maxEN.north() || n.getEastNorth().east() < this.minEN.east() || n.getEastNorth().north() < this.minEN.north()) {
            n.mappaintVisibleCode = viewid;
            return;
        }
        n.mappaintVisibleCode = 0;
        IconElemStyle nodeStyle = (IconElemStyle)this.getPrimitiveStyle(n);
        if (nodeStyle != null && this.isZoomOk(nodeStyle) && (double)this.showIcons > this.dist) {
            this.drawNode(n, nodeStyle.icon, nodeStyle.annotate, this.data.isSelected(n));
        } else if (n.highlighted) {
            this.drawNode(n, this.highlightColor, this.selectedNodeSize, this.selectedNodeRadius, this.fillSelectedNode);
        } else if (this.data.isSelected(n)) {
            this.drawNode(n, this.selectedColor, this.selectedNodeSize, this.selectedNodeRadius, this.fillSelectedNode);
        } else if (n.isTagged()) {
            this.drawNode(n, this.nodeColor, this.taggedNodeSize, this.taggedNodeRadius, this.fillUnselectedNode);
        } else if (n.isDisabled()) {
            this.drawNode(n, this.inactiveColor, this.unselectedNodeSize, this.unselectedNodeRadius, this.fillUnselectedNode);
        } else {
            this.drawNode(n, this.nodeColor, this.unselectedNodeSize, this.unselectedNodeRadius, this.fillUnselectedNode);
        }
    }

    @Override
    public void visit(Way w) {
        if (w.getNodesCount() < 2) {
            w.mappaintVisibleCode = viewid;
            return;
        }
        double minx = 10000.0;
        double maxx = -10000.0;
        double miny = 10000.0;
        double maxy = -10000.0;
        for (Node n : w.getNodes()) {
            if (n.getEastNorth().east() > maxx) {
                maxx = n.getEastNorth().east();
            }
            if (n.getEastNorth().north() > maxy) {
                maxy = n.getEastNorth().north();
            }
            if (n.getEastNorth().east() < minx) {
                minx = n.getEastNorth().east();
            }
            if (!(n.getEastNorth().north() < miny)) continue;
            miny = n.getEastNorth().north();
        }
        if (minx > this.maxEN.east() || miny > this.maxEN.north() || maxx < this.minEN.east() || maxy < this.minEN.north()) {
            w.mappaintVisibleCode = viewid;
            return;
        }
        ElemStyle wayStyle = this.getPrimitiveStyle(w);
        if (!this.isZoomOk(wayStyle)) {
            w.mappaintVisibleCode = viewid;
            return;
        }
        w.mappaintVisibleCode = 0;
        if ((double)this.fillAreas > this.dist) {
            w.clearErrors();
        }
        if (wayStyle == null) {
            this.drawWay(w, null, this.untaggedColor, this.data.isSelected(w));
        } else if (wayStyle instanceof LineElemStyle) {
            this.drawWay(w, (LineElemStyle)wayStyle, this.untaggedColor, this.data.isSelected(w));
        } else if (wayStyle instanceof AreaElemStyle) {
            AreaElemStyle areaStyle = (AreaElemStyle)wayStyle;
            if ((double)this.fillAreas > this.dist) {
                this.drawArea(w, this.data.isSelected(w) ? this.selectedColor : areaStyle.color);
                if (!w.isClosed()) {
                    w.putError(I18n.tr("Area style way is not closed."), true);
                }
            }
            this.drawWay(w, areaStyle.line, areaStyle.color, this.data.isSelected(w));
        }
    }

    public void drawWay(Way w, LineElemStyle l, Color color, Boolean selected) {
        Node lastN;
        boolean showDirection = this.data.isSelected(w) || !this.useRealWidth && this.showDirectionArrow && (!this.showRelevantDirectionsOnly || w.hasDirectionKeys());
        boolean showOnlyHeadArrowOnly = showDirection && !this.data.isSelected(w) && this.showHeadArrowOnly;
        int width = this.defaultSegmentWidth;
        int realWidth = 0;
        float[] dashed = new float[]{};
        Color dashedColor = null;
        if (l != null) {
            if (l.color != null) {
                color = l.color;
            }
            width = l.width;
            realWidth = l.realWidth;
            dashed = l.dashed;
            dashedColor = l.dashedColor;
        }
        if (selected.booleanValue()) {
            color = this.selectedColor;
        }
        if (realWidth > 0 && this.useRealWidth && !showDirection) {
            String widthTag;
            int tmpWidth = (int)(100.0f / (float)(this.circum / (double)realWidth));
            if (tmpWidth > width) {
                width = tmpWidth;
            }
            if ((widthTag = w.get("width")) == null) {
                widthTag = w.get("est_width");
            }
            if (widthTag != null) {
                try {
                    width = Integer.parseInt(widthTag);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        if (w.highlighted) {
            color = this.highlightColor;
        } else if (this.data.isSelected(w)) {
            color = this.selectedColor;
        } else if (w.isDisabled()) {
            color = this.inactiveColor;
        }
        if (l != null && l.overlays != null) {
            for (LineElemStyle s : l.overlays) {
                if (s.over) continue;
                lastN = null;
                for (Node n : w.getNodes()) {
                    if (lastN != null) {
                        this.drawSeg(lastN, n, s.color != null && !this.data.isSelected(w) ? s.color : color, false, s.getWidth(width), s.dashed, s.dashedColor);
                    }
                    lastN = n;
                }
            }
        }
        lastN = null;
        Iterator<Node> it = w.getNodes().iterator();
        while (it.hasNext()) {
            Node n = it.next();
            if (lastN != null) {
                this.drawSeg(lastN, n, color, showOnlyHeadArrowOnly ? !it.hasNext() : showDirection, width, dashed, dashedColor);
            }
            lastN = n;
        }
        if (l != null && l.overlays != null) {
            for (LineElemStyle s : l.overlays) {
                if (!s.over) continue;
                lastN = null;
                for (Node n : w.getNodes()) {
                    if (lastN != null) {
                        this.drawSeg(lastN, n, s.color != null && !this.data.isSelected(w) ? s.color : color, false, s.getWidth(width), s.dashed, s.dashedColor);
                    }
                    lastN = n;
                }
            }
        }
        if (this.showOrderNumber) {
            int orderNumber = 0;
            lastN = null;
            for (Node n : w.getNodes()) {
                if (lastN != null) {
                    this.drawOrderNumber(lastN, n, ++orderNumber);
                }
                lastN = n;
            }
        }
        this.displaySegments();
    }

    public Collection<Way> joinWays(Collection<Way> join, OsmPrimitive errs) {
        LinkedList<Way> res = new LinkedList<Way>();
        Object[] joinArray = join.toArray();
        int left = join.size();
        while (left != 0) {
            Way w = null;
            Boolean selected = false;
            List<Node> n = null;
            Boolean joined = true;
            while (joined.booleanValue() && left != 0) {
                joined = false;
                for (int i = 0; i < joinArray.length && left != 0; ++i) {
                    int nl;
                    if (joinArray[i] == null) continue;
                    Way c = (Way)joinArray[i];
                    if (w == null) {
                        w = c;
                        selected = this.data.isSelected(w);
                        joinArray[i] = null;
                        --left;
                        continue;
                    }
                    int mode = 0;
                    int cl = c.getNodesCount() - 1;
                    if (n == null) {
                        nl = w.getNodesCount() - 1;
                        if (w.getNode(nl) == c.getNode(0)) {
                            mode = 21;
                        } else if (w.getNode(nl) == c.getNode(cl)) {
                            mode = 22;
                        } else if (w.getNode(0) == c.getNode(0)) {
                            mode = 11;
                        } else if (w.getNode(0) == c.getNode(cl)) {
                            mode = 12;
                        }
                    } else {
                        nl = n.size() - 1;
                        if (n.get(nl) == c.getNode(0)) {
                            mode = 21;
                        } else if (n.get(0) == c.getNode(cl)) {
                            mode = 12;
                        } else if (n.get(0) == c.getNode(0)) {
                            mode = 11;
                        } else if (n.get(nl) == c.getNode(cl)) {
                            mode = 22;
                        }
                    }
                    if (mode == 0) continue;
                    joinArray[i] = null;
                    joined = true;
                    if (this.data.isSelected(c)) {
                        selected = true;
                    }
                    --left;
                    if (n == null) {
                        n = w.getNodes();
                    }
                    n.remove(mode == 21 || mode == 22 ? nl : 0);
                    if (mode == 21) {
                        n.addAll(c.getNodes());
                        continue;
                    }
                    if (mode == 12) {
                        n.addAll(0, c.getNodes());
                        continue;
                    }
                    if (mode == 22) {
                        for (Node node : c.getNodes()) {
                            n.add(nl, node);
                        }
                        continue;
                    }
                    for (Node node : c.getNodes()) {
                        n.add(0, node);
                    }
                }
            }
            if (n != null) {
                w = new Way(w);
                w.setNodes(n);
                if (selected.booleanValue()) {
                    this.data.addSelected(Collections.singleton(w), false);
                } else {
                    this.data.clearSelection(w);
                }
            }
            if (!w.isClosed() && errs != null) {
                errs.putError(I18n.tr("multipolygon way ''{0}'' is not closed.", w.getDisplayName(DefaultNameFormatter.getInstance())), true);
            }
            res.add(w);
        }
        return res;
    }

    public void drawSelectedMember(OsmPrimitive osm, ElemStyle style, Boolean area, Boolean areaselected) {
        if (osm instanceof Way) {
            if (style instanceof AreaElemStyle) {
                Way way = (Way)osm;
                AreaElemStyle areaStyle = (AreaElemStyle)style;
                this.drawWay(way, areaStyle.line, this.selectedColor, true);
                if (area.booleanValue()) {
                    this.drawArea(way, areaselected != false ? this.selectedColor : areaStyle.color);
                }
            } else {
                this.drawWay((Way)osm, (LineElemStyle)style, this.selectedColor, true);
            }
        } else if (osm instanceof Node) {
            if (style != null && this.isZoomOk(style)) {
                this.drawNode((Node)osm, ((IconElemStyle)style).icon, ((IconElemStyle)style).annotate, true);
            } else {
                this.drawNode((Node)osm, this.selectedColor, this.selectedNodeSize, this.selectedNodeRadius, this.fillSelectedNode);
            }
        }
        osm.mappaintDrawnCode = paintid;
    }

    @Override
    public void visit(Relation r) {
        r.mappaintVisibleCode = 0;
        if (this.selectedCall.booleanValue()) {
            for (RelationMember m : r.getMembers()) {
                if (!m.isNode() || m.getMember().incomplete || m.getMember().isDeleted() || m.getMember().isFiltered()) continue;
                this.drawSelectedMember(m.getMember(), this.styles != null ? this.getPrimitiveStyle(m.getMember()) : null, true, true);
            }
            return;
        }
        if (this.drawMultipolygon && "multipolygon".equals(r.get("type"))) {
            if (this.drawMultipolygon(r).booleanValue()) {
                return;
            }
        } else if (this.drawRestriction && "restriction".equals(r.get("type"))) {
            this.drawRestriction(r);
        }
        if (this.data.isSelected(r)) {
            for (RelationMember m : r.getMembers()) {
                if (!m.isWay() || m.getMember().incomplete || m.getMember().isDeleted()) continue;
                this.drawSelectedMember(m.getMember(), this.styles != null ? this.getPrimitiveStyle(m.getMember()) : null, true, true);
            }
        }
    }

    public void drawRestriction(Relation r) {
        IconElemStyle nodeStyle;
        Node viaNode;
        r.clearErrors();
        Way fromWay = null;
        Way toWay = null;
        OsmPrimitive via = null;
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isDeleted()) {
                r.putError(I18n.tr("Deleted member ''{0}'' in relation.", m.getMember().getDisplayName(DefaultNameFormatter.getInstance())), true);
                continue;
            }
            if (m.getMember().incomplete) {
                return;
            }
            if (m.isWay()) {
                Way w = m.getWay();
                if (w.getNodesCount() < 2) {
                    r.putError(I18n.tr("Way ''{0}'' with less than two points.", w.getDisplayName(DefaultNameFormatter.getInstance())), true);
                    continue;
                }
                if ("from".equals(m.getRole())) {
                    if (fromWay != null) {
                        r.putError(I18n.tr("More than one \"from\" way found."), true);
                        continue;
                    }
                    fromWay = w;
                    continue;
                }
                if ("to".equals(m.getRole())) {
                    if (toWay != null) {
                        r.putError(I18n.tr("More than one \"to\" way found."), true);
                        continue;
                    }
                    toWay = w;
                    continue;
                }
                if ("via".equals(m.getRole())) {
                    if (via != null) {
                        r.putError(I18n.tr("More than one \"via\" found."), true);
                        continue;
                    }
                    via = w;
                    continue;
                }
                r.putError(I18n.tr("Unknown role ''{0}''.", m.getRole()), true);
                continue;
            }
            if (m.isNode()) {
                Node n = m.getNode();
                if ("via".equals(m.getRole())) {
                    if (via != null) {
                        r.putError(I18n.tr("More than one \"via\" found."), true);
                        continue;
                    }
                    via = n;
                    continue;
                }
                r.putError(I18n.tr("Unknown role ''{0}''.", m.getRole()), true);
                continue;
            }
            r.putError(I18n.tr("Unknown member type for ''{0}''.", m.getMember().getDisplayName(DefaultNameFormatter.getInstance())), true);
        }
        if (fromWay == null) {
            r.putError(I18n.tr("No \"from\" way found."), true);
            return;
        }
        if (toWay == null) {
            r.putError(I18n.tr("No \"to\" way found."), true);
            return;
        }
        if (via == null) {
            r.putError(I18n.tr("No \"via\" node or way found."), true);
            return;
        }
        if (via instanceof Node) {
            viaNode = via;
            if (!fromWay.isFirstLastNode(viaNode)) {
                r.putError(I18n.tr("The \"from\" way doesn't start or end at a \"via\" node."), true);
                return;
            }
            if (!toWay.isFirstLastNode(viaNode)) {
                r.putError(I18n.tr("The \"to\" way doesn't start or end at a \"via\" node."), true);
            }
        } else {
            Way viaWay = (Way)via;
            Node firstNode = viaWay.firstNode();
            Node lastNode = viaWay.lastNode();
            Boolean onewayvia = false;
            String onewayviastr = viaWay.get("oneway");
            if (onewayviastr != null) {
                if ("-1".equals(onewayviastr)) {
                    onewayvia = true;
                    lastNode = firstNode = lastNode;
                } else {
                    onewayvia = OsmUtils.getOsmBoolean(onewayviastr);
                }
            }
            if (fromWay.isFirstLastNode(firstNode)) {
                viaNode = firstNode;
            } else if (!onewayvia.booleanValue() && fromWay.isFirstLastNode(lastNode)) {
                viaNode = lastNode;
            } else {
                r.putError(I18n.tr("The \"from\" way doesn't start or end at the \"via\" way."), true);
                return;
            }
            if (!toWay.isFirstLastNode(viaNode == firstNode ? lastNode : firstNode)) {
                r.putError(I18n.tr("The \"to\" way doesn't start or end at the \"via\" way."), true);
            }
        }
        Node fromNode = null;
        fromNode = fromWay.firstNode() == via ? fromWay.getNode(1) : fromWay.getNode(fromWay.getNodesCount() - 2);
        Point pFrom = this.nc.getPoint(fromNode);
        Point pVia = this.nc.getPoint(viaNode);
        double distanceFromVia = 14.0;
        double dx = pFrom.x >= pVia.x ? (double)(pFrom.x - pVia.x) : (double)(pVia.x - pFrom.x);
        double dy = pFrom.y >= pVia.y ? (double)(pFrom.y - pVia.y) : (double)(pVia.y - pFrom.y);
        double fromAngle = dx == 0.0 ? 1.5707963267948966 : Math.atan(dy / dx);
        double fromAngleDeg = Math.toDegrees(fromAngle);
        double vx = distanceFromVia * Math.cos(fromAngle);
        double vy = distanceFromVia * Math.sin(fromAngle);
        if (pFrom.x < pVia.x) {
            vx = -vx;
        }
        if (pFrom.y < pVia.y) {
            vy = -vy;
        }
        double distanceFromWay = 10.0;
        double vx2 = 0.0;
        double vy2 = 0.0;
        double iconAngle = 0.0;
        if (pFrom.x >= pVia.x && pFrom.y >= pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg - 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg - 90.0));
            } else {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 90.0));
            }
            iconAngle = 270.0 + fromAngleDeg;
        }
        if (pFrom.x < pVia.x && pFrom.y >= pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg));
            } else {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 180.0));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 180.0));
            }
            iconAngle = 90.0 - fromAngleDeg;
        }
        if (pFrom.x < pVia.x && pFrom.y < pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 90.0));
            } else {
                vx2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg - 90.0));
                vy2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg - 90.0));
            }
            iconAngle = 90.0 + fromAngleDeg;
        }
        if (pFrom.x >= pVia.x && pFrom.y < pVia.y) {
            if (!this.leftHandTraffic) {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg + 180.0));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg + 180.0));
            } else {
                vx2 = distanceFromWay * Math.sin(Math.toRadians(fromAngleDeg));
                vy2 = distanceFromWay * Math.cos(Math.toRadians(fromAngleDeg));
            }
            iconAngle = 270.0 - fromAngleDeg;
        }
        if ((nodeStyle = this.getPrimitiveNodeStyle(r)) == null) {
            r.putError(I18n.tr("Style for restriction {0} not found.", r.get("restriction")), true);
            return;
        }
        ImageIcon rotatedIcon = ImageProvider.createRotatedImage(null, nodeStyle.icon, iconAngle);
        ImageIcon smallIcon = new ImageIcon(rotatedIcon.getImage().getScaledInstance(16, 16, 4));
        int w = smallIcon.getIconWidth();
        int h = smallIcon.getIconHeight();
        smallIcon.paintIcon(Main.map.mapView, this.g, (int)((double)pVia.x + vx + vx2) - w / 2, (int)((double)pVia.y + vy + vy2) - h / 2);
        if (this.data.isSelected(r)) {
            this.g.setColor(this.selectedColor);
            this.g.drawRect((int)((double)pVia.x + vx + vx2) - w / 2 - 2, (int)((double)pVia.y + vy + vy2) - h / 2 - 2, w + 4, h + 4);
        }
    }

    public Boolean drawMultipolygon(Relation r) {
        ElemStyle wayStyle;
        LinkedList<Way> inner = new LinkedList<Way>();
        LinkedList<Way> outer = new LinkedList<Way>();
        LinkedList<Way> innerclosed = new LinkedList<Way>();
        LinkedList<Way> outerclosed = new LinkedList<Way>();
        Boolean incomplete = false;
        Boolean drawn = false;
        r.clearErrors();
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isDeleted()) {
                r.putError(I18n.tr("Deleted member ''{0}'' in relation.", m.getMember().getDisplayName(DefaultNameFormatter.getInstance())), true);
                continue;
            }
            if (m.getMember().incomplete) {
                incomplete = true;
                continue;
            }
            if (m.isWay()) {
                Way w = m.getWay();
                if (w.getNodesCount() < 2) {
                    r.putError(I18n.tr("Way ''{0}'' with less than two points.", w.getDisplayName(DefaultNameFormatter.getInstance())), true);
                    continue;
                }
                if ("inner".equals(m.getRole())) {
                    inner.add(w);
                    continue;
                }
                if ("outer".equals(m.getRole())) {
                    outer.add(w);
                    continue;
                }
                r.putError(I18n.tr("No useful role ''{0}'' for Way ''{1}''.", m.getRole(), w.getDisplayName(DefaultNameFormatter.getInstance())), true);
                if (!m.hasRole()) {
                    outer.add(w);
                    continue;
                }
                if (!this.data.isSelected(r)) continue;
                this.drawSelectedMember(m.getMember(), this.styles != null ? this.getPrimitiveStyle(m.getMember()) : null, true, true);
                continue;
            }
            r.putError(I18n.tr("Non-Way ''{0}'' in multipolygon.", m.getMember().getDisplayName(DefaultNameFormatter.getInstance())), true);
        }
        ElemStyle elemStyle = wayStyle = this.styles != null ? this.getPrimitiveStyle(r) : null;
        if (!(this.styles == null || wayStyle != null && wayStyle instanceof AreaElemStyle)) {
            for (Way w : outer) {
                if (wayStyle != null) continue;
                wayStyle = this.styles.getArea(w);
            }
            r.mappaintStyle = wayStyle;
        }
        if (wayStyle != null && wayStyle instanceof AreaElemStyle) {
            Boolean zoomok = this.isZoomOk(wayStyle);
            Boolean visible = false;
            LinkedList<Way> join = new LinkedList<Way>();
            drawn = true;
            for (Way w : outer) {
                if (w.isClosed()) {
                    outerclosed.add(w);
                    continue;
                }
                join.add(w);
            }
            if (join.size() != 0) {
                for (Way w : this.joinWays(join, incomplete != false ? null : r)) {
                    outerclosed.add(w);
                }
            }
            join.clear();
            for (Way w : inner) {
                if (w.isClosed()) {
                    innerclosed.add(w);
                    continue;
                }
                join.add(w);
            }
            if (join.size() != 0) {
                for (Way w : this.joinWays(join, incomplete != false ? null : r)) {
                    innerclosed.add(w);
                }
            }
            if (outerclosed.size() == 0) {
                r.putError(I18n.tr("No outer way for multipolygon ''{0}''.", r.getDisplayName(DefaultNameFormatter.getInstance())), true);
                visible = true;
            } else if (zoomok.booleanValue()) {
                class PolyData {
                    public Polygon poly = new Polygon();
                    public Way way;
                    private Point p = null;
                    private Collection<Polygon> inner = null;

                    PolyData(Way w) {
                        this.way = w;
                        for (Node n : w.getNodes()) {
                            this.p = MapPaintVisitor.this.nc.getPoint(n);
                            this.poly.addPoint(this.p.x, this.p.y);
                        }
                    }

                    public int contains(Polygon p) {
                        int contains = p.npoints;
                        for (int i = 0; i < p.npoints; ++i) {
                            if (!this.poly.contains(p.xpoints[i], p.ypoints[i])) continue;
                            --contains;
                        }
                        if (contains == 0) {
                            return 1;
                        }
                        if (contains == p.npoints) {
                            return 0;
                        }
                        return 2;
                    }

                    public void addInner(Polygon p) {
                        if (this.inner == null) {
                            this.inner = new ArrayList<Polygon>();
                        }
                        this.inner.add(p);
                    }

                    public boolean isClosed() {
                        return this.poly.npoints >= 3 && this.poly.xpoints[0] == this.poly.xpoints[this.poly.npoints - 1] && this.poly.ypoints[0] == this.poly.ypoints[this.poly.npoints - 1];
                    }

                    public Polygon get() {
                        if (this.inner != null) {
                            for (Polygon pp : this.inner) {
                                for (int i = 0; i < pp.npoints; ++i) {
                                    this.poly.addPoint(pp.xpoints[i], pp.ypoints[i]);
                                }
                                this.poly.addPoint(this.p.x, this.p.y);
                            }
                            this.inner = null;
                        }
                        return this.poly;
                    }
                }
                LinkedList<PolyData> poly = new LinkedList<PolyData>();
                for (Way w : outerclosed) {
                    poly.add(new PolyData(w));
                }
                for (Way wInner : innerclosed) {
                    Polygon polygon = new Polygon();
                    for (Node n : wInner.getNodes()) {
                        Point pInner = this.nc.getPoint(n);
                        polygon.addPoint(pInner.x, pInner.y);
                    }
                    if (!wInner.isClosed()) {
                        Point pInner = this.nc.getPoint(wInner.getNode(0));
                        polygon.addPoint(pInner.x, pInner.y);
                    }
                    PolyData o = null;
                    for (PolyData pd : poly) {
                        Integer c = pd.contains(polygon);
                        if (c < 1) continue;
                        if (c > 1 && pd.way.isClosed()) {
                            r.putError(I18n.tr("Intersection between ways ''{0}'' and ''{1}''.", pd.way.getDisplayName(DefaultNameFormatter.getInstance()), wInner.getDisplayName(DefaultNameFormatter.getInstance())), true);
                        }
                        if (o != null && o.contains(pd.poly) <= 0) continue;
                        o = pd;
                    }
                    if (o == null) {
                        if (!incomplete.booleanValue()) {
                            r.putError(I18n.tr("Inner way ''{0}'' is outside.", wInner.getDisplayName(DefaultNameFormatter.getInstance())), true);
                        }
                        o = (PolyData)poly.get(0);
                    }
                    o.addInner(polygon);
                }
                AreaElemStyle areaStyle = (AreaElemStyle)wayStyle;
                for (PolyData pd : poly) {
                    Polygon p = pd.get();
                    if (!this.isPolygonVisible(p)) continue;
                    this.drawAreaPolygon(p, this.data.isSelected(pd.way) || this.data.isSelected(r) ? this.selectedColor : areaStyle.color);
                    visible = true;
                }
            }
            if (!visible.booleanValue()) {
                r.mappaintVisibleCode = viewid;
                for (Way wInner : inner) {
                    wInner.mappaintVisibleCode = viewid;
                }
                for (Way wOuter : outer) {
                    wOuter.mappaintVisibleCode = viewid;
                }
                return drawn;
            }
            for (Way wInner : inner) {
                ElemStyle innerStyle = this.getPrimitiveStyle(wInner);
                if (innerStyle == null) {
                    if (zoomok.booleanValue() && (wInner.mappaintDrawnCode != paintid || outer.size() == 0)) {
                        this.drawWay(wInner, ((AreaElemStyle)wayStyle).line, ((AreaElemStyle)wayStyle).color, this.data.isSelected(wInner) || this.data.isSelected(r));
                    }
                    wInner.mappaintDrawnCode = paintid;
                    continue;
                }
                if (this.data.isSelected(r)) {
                    this.drawSelectedMember(wInner, innerStyle, wayStyle.equals(innerStyle) == false, this.data.isSelected(wInner));
                }
                if (!wayStyle.equals(innerStyle).booleanValue()) continue;
                r.putError(I18n.tr("Style for inner way ''{0}'' equals multipolygon.", wInner.getDisplayName(DefaultNameFormatter.getInstance())), false);
                if (this.data.isSelected(r)) continue;
                wInner.mappaintDrawnAreaCode = paintid;
            }
            for (Way wOuter : outer) {
                ElemStyle outerStyle = this.getPrimitiveStyle(wOuter);
                if (outerStyle == null) {
                    if (zoomok.booleanValue()) {
                        this.drawWay(wOuter, ((AreaElemStyle)wayStyle).line, ((AreaElemStyle)wayStyle).color, this.data.isSelected(wOuter) || this.data.isSelected(r));
                    }
                    wOuter.mappaintDrawnCode = paintid;
                    continue;
                }
                if (outerStyle instanceof AreaElemStyle && !wayStyle.equals(outerStyle).booleanValue()) {
                    r.putError(I18n.tr("Style for outer way ''{0}'' mismatches.", wOuter.getDisplayName(DefaultNameFormatter.getInstance())), true);
                }
                if (this.data.isSelected(r)) {
                    this.drawSelectedMember(wOuter, outerStyle, false, false);
                    continue;
                }
                if (!(outerStyle instanceof AreaElemStyle)) continue;
                wOuter.mappaintDrawnAreaCode = paintid;
            }
        }
        return drawn;
    }

    protected Polygon getPolygon(Way w) {
        Polygon polygon = new Polygon();
        for (Node n : w.getNodes()) {
            Point p = this.nc.getPoint(n);
            polygon.addPoint(p.x, p.y);
        }
        return polygon;
    }

    protected Point2D getCentroid(Polygon p) {
        double cx = 0.0;
        double cy = 0.0;
        double a = 0.0;
        for (int i = 0; i < p.npoints; ++i) {
            int j = i + 1 == p.npoints ? 0 : i + 1;
            a += (double)(p.xpoints[i] * p.ypoints[j] - p.ypoints[i] * p.xpoints[j]);
            cx += (double)((p.xpoints[i] + p.xpoints[j]) * (p.xpoints[i] * p.ypoints[j] - p.ypoints[i] * p.xpoints[j]));
            cy += (double)((p.ypoints[i] + p.ypoints[j]) * (p.xpoints[i] * p.ypoints[j] - p.ypoints[i] * p.xpoints[j]));
        }
        return new Point2D.Double(cx / (3.0 * a), cy / (3.0 * a));
    }

    protected double getArea(Polygon p) {
        double sum = 0.0;
        for (int i = 0; i < p.npoints; ++i) {
            int j = i + 1 == p.npoints ? 0 : i + 1;
            sum = sum + (double)(p.xpoints[i] * p.ypoints[j]) - (double)(p.ypoints[i] * p.xpoints[j]);
        }
        return Math.abs(sum / 2.0);
    }

    protected void drawArea(Way w, Color color) {
        String name;
        Polygon polygon = this.getPolygon(w);
        this.g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.fillAlpha));
        this.g.fillPolygon(polygon);
        if ((double)this.showNames > this.dist && (name = this.getWayName(w)) != null) {
            Rectangle pb = polygon.getBounds();
            FontMetrics fontMetrics = this.g.getFontMetrics(this.orderFont);
            Rectangle2D nb = fontMetrics.getStringBounds(name, this.g);
            Rectangle centeredNBounds = new Rectangle(pb.x + (int)(((double)pb.width - nb.getWidth()) / 2.0), pb.y + (int)(((double)pb.height - nb.getHeight()) / 2.0), (int)nb.getWidth(), (int)nb.getHeight());
            if ((double)pb.width >= nb.getWidth() && (double)pb.height >= nb.getHeight() && polygon.contains(centeredNBounds)) {
                this.g.setColor(this.areaTextColor);
                Font defaultFont = this.g.getFont();
                this.g.setFont(this.orderFont);
                this.g.drawString(name, (int)(centeredNBounds.getMinX() - nb.getMinX()), (int)(centeredNBounds.getMinY() - nb.getMinY()));
                this.g.setFont(defaultFont);
            }
        }
    }

    protected String getWayName(Way w) {
        String name;
        block1: {
            String rn;
            name = null;
            if (!w.hasKeys()) break block1;
            Iterator<String> i$ = this.regionalNameOrder.iterator();
            while (i$.hasNext() && (name = w.get(rn = i$.next())) == null) {
            }
        }
        return name;
    }

    protected void drawAreaPolygon(Polygon polygon, Color color) {
        this.g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), this.fillAlpha));
        this.g.fillPolygon(polygon);
    }

    protected void drawNode(Node n, ImageIcon icon, boolean annotate, Boolean selected) {
        String name;
        Point p = this.nc.getPoint(n);
        if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
            return;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        icon.paintIcon(Main.map.mapView, this.g, p.x - w / 2, p.y - h / 2);
        if ((double)this.showNames > this.dist && (name = this.getNodeName(n)) != null && annotate) {
            this.g.setColor(this.textColor);
            Font defaultFont = this.g.getFont();
            this.g.setFont(this.orderFont);
            this.g.drawString(name, p.x + w / 2 + 2, p.y + h / 2 + 2);
            this.g.setFont(defaultFont);
        }
        if (selected.booleanValue()) {
            this.g.setColor(this.selectedColor);
            this.g.drawRect(p.x - w / 2 - 2, p.y - h / 2 - 2, w + 4, h + 4);
        }
    }

    protected String getNodeName(Node n) {
        String name;
        block1: {
            String rn;
            name = null;
            if (!n.hasKeys()) break block1;
            Iterator<String> i$ = this.regionalNameOrder.iterator();
            while (i$.hasNext() && (name = n.get(rn = i$.next())) == null) {
            }
        }
        return name;
    }

    private void drawSeg(Node n1, Node n2, Color col, boolean showDirection, int width, float[] dashed, Color dashedColor) {
        Point p2;
        Point p1;
        if (col != this.currentColor || width != this.currentWidth || !Arrays.equals(dashed, this.currentDashed) || dashedColor != this.currentDashedColor) {
            this.displaySegments(col, width, dashed, dashedColor);
        }
        if (!this.isSegmentVisible(p1 = this.nc.getPoint(n1), p2 = this.nc.getPoint(n2))) {
            return;
        }
        this.currentPath.moveTo(p1.x, p1.y);
        this.currentPath.lineTo(p2.x, p2.y);
        if (showDirection) {
            double t = Math.atan2(p2.y - p1.y, p2.x - p1.x) + Math.PI;
            this.currentPath.lineTo((int)((double)p2.x + 10.0 * Math.cos(t - PHI)), (int)((double)p2.y + 10.0 * Math.sin(t - PHI)));
            this.currentPath.moveTo((int)((double)p2.x + 10.0 * Math.cos(t + PHI)), (int)((double)p2.y + 10.0 * Math.sin(t + PHI)));
            this.currentPath.lineTo(p2.x, p2.y);
        }
    }

    @Override
    protected void displaySegments() {
        this.displaySegments(null, 0, new float[0], null);
    }

    protected void displaySegments(Color newColor, int newWidth, float[] newDash, Color newDashedColor) {
        if (this.currentPath != null) {
            Graphics2D g2d = (Graphics2D)this.g;
            g2d.setColor(this.inactive ? this.inactiveColor : this.currentColor);
            if (this.currentStroke == null && (double)this.useStrokes > this.dist) {
                if (this.currentDashed.length > 0) {
                    try {
                        g2d.setStroke(new BasicStroke(this.currentWidth, 0, 1, 0.0f, this.currentDashed, 0.0f));
                    }
                    catch (IllegalArgumentException e) {
                        g2d.setStroke(new BasicStroke(this.currentWidth, 1, 1));
                    }
                } else {
                    g2d.setStroke(new BasicStroke(this.currentWidth, 1, 1));
                }
            }
            g2d.draw(this.currentPath);
            if (this.currentDashedColor != null) {
                g2d.setColor(this.currentDashedColor);
                if (this.currentStroke == null && (double)this.useStrokes > this.dist) {
                    if (this.currentDashed.length > 0) {
                        float[] currentDashedOffset = new float[this.currentDashed.length];
                        System.arraycopy(this.currentDashed, 1, currentDashedOffset, 0, this.currentDashed.length - 1);
                        currentDashedOffset[this.currentDashed.length - 1] = this.currentDashed[0];
                        float offset = currentDashedOffset[0];
                        try {
                            g2d.setStroke(new BasicStroke(this.currentWidth, 0, 1, 0.0f, currentDashedOffset, offset));
                        }
                        catch (IllegalArgumentException e) {
                            g2d.setStroke(new BasicStroke(this.currentWidth, 1, 1));
                        }
                    } else {
                        g2d.setStroke(new BasicStroke(this.currentWidth, 1, 1));
                    }
                }
                g2d.draw(this.currentPath);
            }
            if ((double)this.useStrokes > this.dist) {
                g2d.setStroke(new BasicStroke(1.0f));
            }
            this.currentPath = new GeneralPath();
            this.currentColor = newColor;
            this.currentWidth = newWidth;
            this.currentDashed = newDash;
            this.currentDashedColor = newDashedColor;
            this.currentStroke = null;
        }
    }

    @Override
    public void drawNode(Node n, Color color, int size, int radius, boolean fill) {
        if (this.isZoomOk(null) && size > 1) {
            String name;
            Point p = this.nc.getPoint(n);
            if (p.x < 0 || p.y < 0 || p.x > this.nc.getWidth() || p.y > this.nc.getHeight()) {
                return;
            }
            this.g.setColor(color);
            if (fill) {
                this.g.fillRect(p.x - radius, p.y - radius, size, size);
                this.g.drawRect(p.x - radius, p.y - radius, size, size);
            } else {
                this.g.drawRect(p.x - radius, p.y - radius, size, size);
            }
            if ((double)this.showNames > this.dist && (name = this.getNodeName(n)) != null) {
                this.g.setColor(this.textColor);
                Font defaultFont = this.g.getFont();
                this.g.setFont(this.orderFont);
                this.g.drawString(name, p.x + radius + 2, p.y + radius + 2);
                this.g.setFont(defaultFont);
            }
        }
    }

    @Override
    public void getColors() {
        super.getColors();
        this.untaggedColor = Main.pref.getColor(I18n.marktr("untagged"), Color.GRAY);
        this.textColor = Main.pref.getColor(I18n.marktr("text"), Color.WHITE);
        this.areaTextColor = Main.pref.getColor(I18n.marktr("areatext"), Color.GRAY);
    }

    @Override
    public void visitAll(DataSet data, Boolean virtual) {
        this.data = data;
        this.useStyleCache = Main.pref.getBoolean("mappaint.cache", true);
        this.fillAreas = Main.pref.getInteger("mappaint.fillareas", 10000000);
        this.fillAlpha = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fillalpha", 50)));
        this.showNames = Main.pref.getInteger("mappaint.shownames", 10000000);
        this.showIcons = Main.pref.getInteger("mappaint.showicons", 10000000);
        this.useStrokes = Main.pref.getInteger("mappaint.strokes", 10000000);
        LatLon ll1 = this.nc.getLatLon(0, 0);
        LatLon ll2 = this.nc.getLatLon(100, 0);
        this.dist = ll1.greatCircleDistance(ll2);
        this.getSettings(virtual);
        this.useRealWidth = Main.pref.getBoolean("mappaint.useRealWidth", false);
        this.zoomLevelDisplay = Main.pref.getBoolean("mappaint.zoomLevelDisplay", false);
        this.circum = Main.map.mapView.getDist100Pixel();
        this.styles = MapPaintStyles.getStyles().getStyleSet();
        this.drawMultipolygon = Main.pref.getBoolean("mappaint.multipolygon", true);
        this.drawRestriction = Main.pref.getBoolean("mappaint.restriction", true);
        this.leftHandTraffic = Main.pref.getBoolean("mappaint.lefthandtraffic", false);
        this.orderFont = new Font(Main.pref.get("mappaint.font", "Helvetica"), 0, Main.pref.getInteger("mappaint.fontsize", 8));
        String[] names = new String[]{"name:" + LanguageInfo.getJOSMLocaleCode(), "name", "int_name", "ref", "operator", "brand", "addr:housenumber"};
        this.regionalNameOrder = Main.pref.getCollection("mappaint.nameOrder", Arrays.asList(names));
        this.minEN = this.nc.getEastNorth(0, this.nc.getHeight() - 1);
        this.maxEN = this.nc.getEastNorth(this.nc.getWidth() - 1, 0);
        this.selectedCall = false;
        ++paintid;
        viewid = this.nc.getViewID();
        if ((double)this.fillAreas > this.dist && this.styles != null && this.styles.hasAreas()) {
            LinkedList<Way> noAreaWays = new LinkedList<Way>();
            for (Relation relation : data.relations) {
                if (relation.isDeleted() || relation.isFiltered() || relation.incomplete || relation.mappaintVisibleCode == viewid) continue;
                relation.visit(this);
            }
            for (Way way : data.ways) {
                if (way.incomplete || way.isDeleted() || way.isFiltered() || way.mappaintVisibleCode == viewid || way.mappaintDrawnCode == paintid) continue;
                if (this.isPrimitiveArea(way) && way.mappaintDrawnAreaCode != paintid) {
                    way.visit(this);
                    continue;
                }
                noAreaWays.add(way);
            }
            this.fillAreas = 0;
            for (OsmPrimitive osmPrimitive : noAreaWays) {
                osmPrimitive.visit(this);
            }
        } else {
            for (OsmPrimitive osmPrimitive : data.ways) {
                if (osmPrimitive.incomplete || osmPrimitive.isDeleted() || osmPrimitive.isFiltered() || data.isSelected(osmPrimitive) || osmPrimitive.mappaintVisibleCode == viewid) continue;
                osmPrimitive.visit(this);
            }
        }
        this.selectedCall = true;
        for (OsmPrimitive osmPrimitive : data.getSelected()) {
            if (osmPrimitive.incomplete || osmPrimitive.isDeleted() || osmPrimitive instanceof Node || osmPrimitive.mappaintVisibleCode == viewid || osmPrimitive.mappaintDrawnCode == paintid) continue;
            osmPrimitive.visit(this);
        }
        this.displaySegments();
        for (OsmPrimitive osmPrimitive : data.nodes) {
            if (osmPrimitive.incomplete || osmPrimitive.isDeleted() || !data.isSelected(osmPrimitive) && osmPrimitive.isFiltered() || osmPrimitive.mappaintVisibleCode == viewid || osmPrimitive.mappaintDrawnCode == paintid) continue;
            osmPrimitive.visit(this);
        }
        if (this.virtualNodeSize != 0) {
            this.currentColor = this.nodeColor;
            for (OsmPrimitive osmPrimitive : data.ways) {
                if (!osmPrimitive.isUsable() || osmPrimitive.isFiltered() || osmPrimitive.mappaintVisibleCode == viewid) continue;
                this.visitVirtual((Way)osmPrimitive);
            }
            this.displaySegments(null);
        }
    }

    protected void drawOrderNumber(Node n1, Node n2, int orderNumber) {
        Point p1 = this.nc.getPoint(n1);
        Point p2 = this.nc.getPoint(n2);
        this.drawOrderNumber(p1, p2, orderNumber);
    }
}

