/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.tools.I18n;

public class MergeSourceBuildingVisitor
extends AbstractVisitor {
    private DataSet selectionBase;
    private DataSet hull;
    private HashMap<OsmPrimitive, OsmPrimitive> mappedPrimitives;

    public MergeSourceBuildingVisitor(DataSet selectionBase) throws IllegalArgumentException {
        if (selectionBase == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "selectionBase"));
        }
        this.selectionBase = selectionBase;
        this.hull = new DataSet();
        this.mappedPrimitives = new HashMap();
    }

    protected void rememberNode(Node n) {
        if (this.isAlreadyRemembered(n)) {
            return;
        }
        Node clone = new Node(n);
        this.mappedPrimitives.put(n, clone);
    }

    protected void rememberWay(Way w) {
        if (this.isAlreadyRemembered(w)) {
            return;
        }
        Way clone = new Way(w);
        ArrayList<Node> newNodes = new ArrayList<Node>();
        for (Node n : w.getNodes()) {
            newNodes.add((Node)this.mappedPrimitives.get(n));
        }
        clone.setNodes(newNodes);
        this.mappedPrimitives.put(w, clone);
    }

    protected void rememberRelation(Relation r) {
        Relation clone;
        if (this.mappedPrimitives.keySet().contains(r)) {
            clone = (Relation)this.mappedPrimitives.get(r);
            clone.cloneFrom(r);
        } else {
            clone = new Relation(r);
        }
        ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
        for (RelationMember member : r.getMembers()) {
            newMembers.add(new RelationMember(member.getRole(), this.mappedPrimitives.get(member.getMember())));
        }
        clone.setMembers(newMembers);
        if (!this.mappedPrimitives.keySet().contains(r)) {
            this.mappedPrimitives.put(r, clone);
        }
    }

    protected void rememberRelationPartial(Relation r) {
        if (this.isAlreadyRemembered(r)) {
            return;
        }
        Relation clone = new Relation(r);
        clone.setMembers(null);
        this.mappedPrimitives.put(r, clone);
    }

    protected void rememberIncomplete(OsmPrimitive primitive) {
        if (this.isAlreadyRemembered(primitive)) {
            return;
        }
        OsmPrimitive clone = null;
        if (primitive instanceof Node) {
            clone = new Node(primitive.getId());
        } else if (primitive instanceof Way) {
            clone = new Way(primitive.getId());
        } else if (primitive instanceof Relation) {
            clone = new Relation(primitive.getId());
        }
        this.mappedPrimitives.put(primitive, clone);
    }

    protected void rememberNodeIncomplete(Node n) {
        if (this.isAlreadyRemembered(n)) {
            return;
        }
        Node clone = new Node(n);
        clone.incomplete = true;
        this.mappedPrimitives.put(n, clone);
    }

    protected void rememberWayIncomplete(Way w) {
        if (this.isAlreadyRemembered(w)) {
            return;
        }
        Way clone = new Way(w);
        clone.setNodes(null);
        clone.incomplete = true;
        this.mappedPrimitives.put(w, clone);
    }

    protected void rememberRelationIncomplete(Relation r) {
        Relation clone;
        if (this.isAlreadyRemembered(r)) {
            clone = (Relation)this.mappedPrimitives.get(r);
            clone.cloneFrom(r);
        } else {
            clone = new Relation(r);
        }
        clone.setMembers(null);
        clone.incomplete = true;
        if (!this.isAlreadyRemembered(r)) {
            this.mappedPrimitives.put(r, clone);
        }
    }

    public void visit(Node n) {
        this.rememberNode(n);
    }

    public void visit(Way w) {
        for (Node n : w.getNodes()) {
            if (this.isAlreadyRemembered(n)) continue;
            n.visit(this);
        }
        this.rememberWay(w);
    }

    protected boolean isInSelectionBase(OsmPrimitive primitive) {
        return this.selectionBase.getSelected().contains(primitive);
    }

    protected boolean isAlreadyRemembered(OsmPrimitive primitive) {
        return this.mappedPrimitives.keySet().contains(primitive);
    }

    public void visit(Relation r) {
        this.rememberRelationPartial(r);
        for (RelationMember member : r.getMembers()) {
            if (this.isAlreadyRemembered(member.getMember())) continue;
            if (member.isNode()) {
                Node node = member.getNode();
                if (this.isInSelectionBase(node)) {
                    this.rememberNode(node);
                    continue;
                }
                if (node.isNew()) {
                    this.rememberNode(node);
                    continue;
                }
                this.rememberNodeIncomplete(node);
                continue;
            }
            if (member.isWay()) {
                Way way = member.getWay();
                if (this.isInSelectionBase(way)) {
                    way.visit(this);
                    continue;
                }
                if (way.isNew()) {
                    way.visit(this);
                    continue;
                }
                this.rememberWayIncomplete(way);
                continue;
            }
            if (!member.isRelation()) continue;
            Relation relation = member.getRelation();
            if (this.isInSelectionBase(member.getMember())) {
                relation.visit(this);
                continue;
            }
            if (relation.isNew()) {
                relation.visit(this);
                continue;
            }
            this.rememberRelationIncomplete(relation);
        }
        this.rememberRelation(r);
    }

    protected void buildHull() {
        for (OsmPrimitive primitive : this.mappedPrimitives.keySet()) {
            OsmPrimitive clone = this.mappedPrimitives.get(primitive);
            if (clone instanceof Node) {
                this.hull.nodes.add((Node)clone);
                continue;
            }
            if (clone instanceof Way) {
                this.hull.ways.add((Way)clone);
                continue;
            }
            if (!(clone instanceof Relation)) continue;
            this.hull.relations.add((Relation)clone);
        }
    }

    public DataSet build() {
        for (OsmPrimitive primitive : this.selectionBase.getSelected()) {
            primitive.visit(this);
        }
        this.buildHull();
        return this.hull;
    }
}

