/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.tools.I18n;

public class GaussLaborde_Reunion
implements Projection {
    private static final double lon0 = Math.toRadians(55.53333333333333);
    private static final double lat0 = Math.toRadians(-21.116666666666667);
    private static final double x0 = 160000.0;
    private static final double y0 = 50000.0;
    private static final double k0 = 1.0;
    private static double sinLat0 = Math.sin(lat0);
    private static double cosLat0 = Math.cos(lat0);
    private static double n1 = Math.sqrt(1.0 + cosLat0 * cosLat0 * cosLat0 * cosLat0 * Ellipsoid.hayford.e2 / (1.0 - Ellipsoid.hayford.e2));
    private static double phic = Math.asin(sinLat0 / n1);
    private static double c = Ellipsoid.hayford.latitudeIsometric(phic, 0.0) - n1 * Ellipsoid.hayford.latitudeIsometric(lat0, Ellipsoid.hayford.e);
    private static double n2 = 1.0 * Ellipsoid.hayford.a * Math.sqrt(1.0 - Ellipsoid.hayford.e2) / (1.0 - Ellipsoid.hayford.e2 * sinLat0 * sinLat0);
    private static double xs = 160000.0;
    private static double ys = 50000.0 - n2 * phic;
    private static final double epsilon = 1.0E-11;
    private static final double scaleDiff = -3.23241E-5;
    private static final double Tx = 789.524;
    private static final double Ty = -626.486;
    private static final double Tz = -89.904;
    private static final double rx = Math.toRadians(1.6683333333333334E-4);
    private static final double ry = Math.toRadians(0.021331833333333335);
    private static final double rz = Math.toRadians(-0.0029385555555555554);
    private static final double rx2 = rx * rx;
    private static final double ry2 = ry * ry;
    private static final double rz2 = rz * rz;

    public LatLon eastNorth2latlon(EastNorth p) {
        LatLon geo = this.Geographic(p);
        LatLon wgs = this.PTN2GRS80(geo);
        return new LatLon(Math.toDegrees(wgs.lat()), Math.toDegrees(wgs.lon()));
    }

    private LatLon Geographic(EastNorth eastNorth) {
        double dxn = (eastNorth.east() - xs) / n2;
        double dyn = (eastNorth.north() - ys) / n2;
        double lambda = Math.atan(GaussLaborde_Reunion.sinh(dxn) / Math.cos(dyn));
        double latIso = Ellipsoid.hayford.latitudeIsometric(Math.asin(Math.sin(dyn) / GaussLaborde_Reunion.cosh(dxn)), 0.0);
        double lon = lon0 + lambda / n1;
        double lat = Ellipsoid.hayford.latitude((latIso - c) / n1, Ellipsoid.hayford.e, 1.0E-12);
        return new LatLon(lat, lon);
    }

    private LatLon PTN2GRS80(LatLon PTN) {
        double lat = PTN.lat();
        double lon = PTN.lon();
        double N = Ellipsoid.hayford.a / Math.sqrt(1.0 - Ellipsoid.hayford.e2 * Math.sin(lat) * Math.sin(lat));
        double X = N * Math.cos(lat) * Math.cos(lon);
        double Y = N * Math.cos(lat) * Math.sin(lon);
        double Z = N * (1.0 - Ellipsoid.hayford.e2) * Math.sin(lat);
        double[] coord = this.sevenParametersTransformation(X, Y, Z);
        return this.cart2LatLon(coord[0], coord[1], coord[2], Ellipsoid.GRS80);
    }

    private double[] sevenParametersTransformation(double Xa, double Ya, double Za) {
        double Xb = 789.524 + Xa * 0.9999676759 + Za * ry - Ya * rz;
        double Yb = -626.486 + Ya * 0.9999676759 + Xa * rz - Za * rx;
        double Zb = -89.904 + Za * 0.9999676759 + Ya * rx - Xa * ry;
        return new double[]{Xb, Yb, Zb};
    }

    public EastNorth latlon2eastNorth(LatLon wgs) {
        LatLon geo = this.GRS802Hayford(wgs);
        return this.GaussLabordeProjection(geo);
    }

    private LatLon GRS802Hayford(LatLon wgs) {
        double lat = Math.toRadians(wgs.lat());
        double lon = Math.toRadians(wgs.lon());
        double N = Ellipsoid.GRS80.a / Math.sqrt(1.0 - Ellipsoid.GRS80.e2 * Math.sin(lat) * Math.sin(lat));
        double X = N * Math.cos(lat) * Math.cos(lon);
        double Y = N * Math.cos(lat) * Math.sin(lon);
        double Z = N * (1.0 - Ellipsoid.GRS80.e2) * Math.sin(lat);
        double[] coord = this.invSevenParametersTransformation(X, Y, Z);
        return this.Geographic(coord[0], coord[1], coord[2], Ellipsoid.hayford);
    }

    private double[] invSevenParametersTransformation(double Vx, double Vy, double Vz) {
        double e = 0.9999676759;
        double e2 = e * e;
        double det = e * (e2 + rx2 + ry2 + rz2);
        double Ux = ((e2 + rx2) * (Vx -= 789.524) + (e * rz + rx * ry) * (Vy -= -626.486) + (rx * rz - e * ry) * (Vz -= -89.904)) / det;
        double Uy = ((-e * rz + rx * ry) * Vx + (e2 + ry2) * Vy + (e * rx + ry * rz) * Vz) / det;
        double Uz = ((e * ry + rx * rz) * Vx + (-e * rx + ry * rz) * Vy + (e2 + rz2) * Vz) / det;
        return new double[]{Ux, Uy, Uz};
    }

    private LatLon Geographic(double X, double Y, double Z, Ellipsoid ell) {
        double s2;
        double norm = Math.sqrt(X * X + Y * Y);
        double lg = 2.0 * Math.atan(Y / (X + norm));
        double lt = Math.atan(Z / (norm * (1.0 - ell.a * ell.e2 / Math.sqrt(X * X + Y * Y + Z * Z))));
        double delta = 1.0;
        while (delta > 1.0E-11) {
            s2 = Math.sin(lt);
            s2 *= s2;
            double l = Math.atan(Z / norm / (1.0 - ell.a * ell.e2 * Math.cos(lt) / (norm * Math.sqrt(1.0 - ell.e2 * s2))));
            delta = Math.abs(l - lt);
            lt = l;
        }
        s2 = Math.sin(lt);
        s2 *= s2;
        return new LatLon(lt, lg);
    }

    private EastNorth GaussLabordeProjection(LatLon geo) {
        double lambda = n1 * (geo.lon() - lon0);
        double latIso = c + n1 * Ellipsoid.hayford.latitudeIsometric(geo.lat());
        double x = xs + n2 * Ellipsoid.hayford.latitudeIsometric(Math.asin(Math.sin(lambda) / ((Math.exp(latIso) + Math.exp(-latIso)) / 2.0)), 0.0);
        double y = ys + n2 * Math.atan((Math.exp(latIso) - Math.exp(-latIso)) / 2.0 / Math.cos(lambda));
        return new EastNorth(x, y);
    }

    private LatLon cart2LatLon(double X, double Y, double Z, Ellipsoid ell) {
        double s2;
        double norm = Math.sqrt(X * X + Y * Y);
        double lg = 2.0 * Math.atan(Y / (X + norm));
        double lt = Math.atan(Z / (norm * (1.0 - ell.a * ell.e2 / Math.sqrt(X * X + Y * Y + Z * Z))));
        double delta = 1.0;
        while (delta > 1.0E-11) {
            s2 = Math.sin(lt);
            s2 *= s2;
            double l = Math.atan(Z / norm / (1.0 - ell.a * ell.e2 * Math.cos(lt) / (norm * Math.sqrt(1.0 - ell.e2 * s2))));
            delta = Math.abs(l - lt);
            lt = l;
        }
        s2 = Math.sin(lt);
        s2 *= s2;
        return new LatLon(lt, lg);
    }

    public static final double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static final double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public String getCacheDirectoryName() {
        return this.toString();
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-21.5, 55.14), new LatLon(-20.76, 55.94));
    }

    public String toCode() {
        return "EPSG::3727";
    }

    public String toString() {
        return I18n.tr("Gauss-Laborde R\u00e9union 1947");
    }

    public double getDefaultZoomInPPD() {
        return 10.02;
    }
}

