/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.ImageProvider;

public class OsmPrimitivRenderer
implements ListCellRenderer,
TableCellRenderer {
    private DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
    private DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component def = this.defaultListCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        return this.renderer(def, (OsmPrimitive)value);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component def = this.defaultTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        return this.renderer(def, (OsmPrimitive)value);
    }

    private Component renderer(Component def, OsmPrimitive value) {
        if (def != null && value != null && def instanceof JLabel) {
            ((JLabel)def).setText(value.getDisplayName(DefaultNameFormatter.getInstance()));
            ((JLabel)def).setIcon(ImageProvider.get(OsmPrimitiveType.from(value)));
            ((JLabel)def).setToolTipText(this.buildToolTipText(value));
        }
        return def;
    }

    public String buildToolTipText(OsmPrimitive primitive) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<strong>id</strong>=").append(primitive.getId()).append("<br>");
        ArrayList<String> keyList = new ArrayList<String>(primitive.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            String key = keyList.get(i);
            sb.append("<strong>").append(key).append("</strong>").append("=");
            String value = primitive.get(key);
            while (value.length() != 0) {
                sb.append(value.substring(0, Math.min(50, value.length())));
                if (value.length() > 50) {
                    sb.append("<br>");
                    value = value.substring(50);
                    continue;
                }
                value = "";
            }
        }
        sb.append("</html>");
        return sb.toString();
    }
}

