/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.actionsupport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.BackreferencedDataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class DeleteFromRelationConfirmationDialog
extends JDialog
implements TableModelListener {
    private static DeleteFromRelationConfirmationDialog instance;
    private RelationMemberTableModel model;
    private JLabel lblMessage;
    private boolean canceled;
    private SideButton btnOK;

    public static DeleteFromRelationConfirmationDialog getInstance() {
        if (instance == null) {
            instance = new DeleteFromRelationConfirmationDialog();
        }
        return instance;
    }

    protected JPanel buildMessagePanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 1;
        this.lblMessage = new JLabel();
        pnl.add((Component)this.lblMessage, gc);
        this.lblMessage.setAlignmentX(0.0f);
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return pnl;
    }

    protected JPanel buildRelationMemberTablePanel() {
        JTable table = new JTable(this.model, new RelationMemberTableColumnModel());
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        pnl.add(new JScrollPane(table));
        return pnl;
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout());
        this.btnOK = new SideButton(new OKAction());
        pnl.add(this.btnOK);
        this.btnOK.setFocusable(true);
        pnl.add(new SideButton(new CancelAction()));
        pnl.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/Delete#DeleteFromRelations"))));
        return pnl;
    }

    protected void build() {
        this.model = new RelationMemberTableModel();
        this.model.addTableModelListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildMessagePanel(), "North");
        this.getContentPane().add((Component)this.buildRelationMemberTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/Delete#DeleteFromRelations"));
        this.addWindowListener(new WindowEventHandler());
    }

    protected void updateMessage() {
        int numObjectsToDelete = this.model.getNumObjectsToDelete();
        int numParentRelations = this.model.getNumParentRelations();
        String msg = numObjectsToDelete == 1 && numParentRelations == 1 ? I18n.tr("<html>Please confirm to remove <strong>1 object</strong> from <strong>1 relation</strong>.</html>") : (numObjectsToDelete == 1 && numParentRelations > 1 ? I18n.tr("<html>Please confirm to remove <strong>1 object</strong> from <strong>{0} relations</strong>.</html>", numParentRelations) : (numObjectsToDelete > 1 && numParentRelations == 1 ? I18n.tr("<html>Please confirm to remove <strong>1 object</strong> from <strong>{0} relations</strong>.</html>", numParentRelations) : I18n.tr("<html>Please confirm to remove <strong>{0} objects</strong> from <strong>{1} relations</strong>.</html>", numObjectsToDelete, numParentRelations)));
        this.lblMessage.setText(msg);
        this.invalidate();
    }

    protected void updateTitle() {
        int numObjectsToDelete = this.model.getNumObjectsToDelete();
        if (numObjectsToDelete > 0) {
            this.setTitle(I18n.trn("Deleting {0} object", "Deleting {0} objects", numObjectsToDelete, numObjectsToDelete));
        } else {
            this.setTitle(I18n.tr("Delete objects"));
        }
    }

    public DeleteFromRelationConfirmationDialog() {
        super(JOptionPane.getFrameForComponent(Main.parent), "", true);
        this.build();
    }

    public RelationMemberTableModel getModel() {
        return this.model;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(400, 200))).applySafe(this);
            this.setCanceled(false);
        } else {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(visible);
    }

    public void tableChanged(TableModelEvent e) {
        this.updateMessage();
        this.updateTitle();
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent e) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(true);
        }

        public void windowOpened(WindowEvent e) {
            DeleteFromRelationConfirmationDialog.this.btnOK.requestFocusInWindow();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and to abort deleting the objects"));
        }

        public void actionPerformed(ActionEvent e) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(true);
            DeleteFromRelationConfirmationDialog.this.setVisible(false);
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("OK"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Click to close the dialog and remove the object from the relations"));
        }

        public void actionPerformed(ActionEvent e) {
            DeleteFromRelationConfirmationDialog.this.setCanceled(false);
            DeleteFromRelationConfirmationDialog.this.setVisible(false);
        }
    }

    private static class RelationMemberTableColumnModel
    extends DefaultTableColumnModel {
        protected void createColumns() {
            TableColumn col = null;
            col = new TableColumn(0);
            col.setHeaderValue(I18n.tr("To delete"));
            col.setResizable(true);
            col.setWidth(100);
            col.setPreferredWidth(100);
            col.setCellRenderer(new OsmPrimitivRenderer());
            this.addColumn(col);
            col = new TableColumn(1);
            col.setHeaderValue(I18n.tr("From Relation"));
            col.setResizable(true);
            col.setWidth(100);
            col.setPreferredWidth(100);
            col.setCellRenderer(new OsmPrimitivRenderer());
            this.addColumn(col);
            col = new TableColumn(2);
            col.setHeaderValue(I18n.tr("Pos."));
            col.setResizable(true);
            col.setWidth(30);
            col.setPreferredWidth(30);
            this.addColumn(col);
            col = new TableColumn(3);
            col.setHeaderValue(I18n.tr("Role"));
            col.setResizable(true);
            col.setWidth(50);
            col.setPreferredWidth(50);
            this.addColumn(col);
        }

        public RelationMemberTableColumnModel() {
            this.createColumns();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RelationMemberTableModel
    extends DefaultTableModel {
        private ArrayList<BackreferencedDataSet.RelationToChildReference> data = new ArrayList();

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        protected void sort() {
            Collections.sort(this.data, new Comparator<BackreferencedDataSet.RelationToChildReference>(){
                private NameFormatter nf = DefaultNameFormatter.getInstance();

                @Override
                public int compare(BackreferencedDataSet.RelationToChildReference o1, BackreferencedDataSet.RelationToChildReference o2) {
                    int cmp = o1.getChild().getDisplayName(this.nf).compareTo(o2.getChild().getDisplayName(this.nf));
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = o1.getParent().getDisplayName(this.nf).compareTo(o2.getParent().getDisplayName(this.nf));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return new Integer(o1.getPosition()).compareTo(o2.getPosition());
                }
            });
        }

        public void populate(Collection<BackreferencedDataSet.RelationToChildReference> references) {
            this.data.clear();
            if (references != null) {
                this.data.addAll(references);
            }
            this.sort();
            this.fireTableDataChanged();
        }

        public Set<OsmPrimitive> getObjectsToDelete() {
            HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
            for (BackreferencedDataSet.RelationToChildReference ref : this.data) {
                ret.add(ref.getChild());
            }
            return ret;
        }

        public int getNumObjectsToDelete() {
            return this.getObjectsToDelete().size();
        }

        public Set<OsmPrimitive> getParentRelations() {
            HashSet<OsmPrimitive> ret = new HashSet<OsmPrimitive>();
            for (BackreferencedDataSet.RelationToChildReference ref : this.data) {
                ret.add(ref.getParent());
            }
            return ret;
        }

        public int getNumParentRelations() {
            return this.getParentRelations().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.data == null) {
                return null;
            }
            BackreferencedDataSet.RelationToChildReference ref = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ref.getChild();
                }
                case 1: {
                    return ref.getParent();
                }
                case 2: {
                    return ref.getPosition();
                }
                case 3: {
                    return ref.getRole();
                }
            }
            assert (false) : "Illegal column index";
            return null;
        }
    }
}

