/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.gui.conflict.pair.ComparePairListCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListMerger<T>
extends JPanel
implements PropertyChangeListener,
Observer {
    protected JTable myEntriesTable;
    protected JTable mergedEntriesTable;
    protected JTable theirEntriesTable;
    protected ListMergeModel<T> model;
    private CopyStartLeftAction copyStartLeftAction;
    private CopyBeforeCurrentLeftAction copyBeforeCurrentLeftAction;
    private CopyAfterCurrentLeftAction copyAfterCurrentLeftAction;
    private CopyEndLeftAction copyEndLeftAction;
    private CopyStartRightAction copyStartRightAction;
    private CopyBeforeCurrentRightAction copyBeforeCurrentRightAction;
    private CopyAfterCurrentRightAction copyAfterCurrentRightAction;
    private CopyEndRightAction copyEndRightAction;
    private MoveUpMergedAction moveUpMergedAction;
    private MoveDownMergedAction moveDownMergedAction;
    private RemoveMergedAction removeMergedAction;
    private FreezeAction freezeAction;
    private AdjustmentSynchronizer adjustmentSynchronizer;
    private JCheckBox cbLockMyScrolling;
    private JCheckBox cbLockMergedScrolling;
    private JCheckBox cbLockTheirScrolling;
    private JLabel lblMyVersion;
    private JLabel lblMergedVersion;
    private JLabel lblTheirVersion;
    private JLabel lblFrozenState;

    protected abstract JScrollPane buildMyElementsTable();

    protected abstract JScrollPane buildMergedElementsTable();

    protected abstract JScrollPane buildTheirElementsTable();

    protected JScrollPane embeddInScrollPane(JTable table) {
        JScrollPane pane = new JScrollPane(table);
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        if (this.adjustmentSynchronizer == null) {
            this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        }
        return pane;
    }

    protected void wireActionsToSelectionModels() {
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyStartLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentLeftAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentLeftAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyEndLeftAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyStartRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyEndRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.moveUpMergedAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.moveDownMergedAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.removeMergedAction);
    }

    protected JPanel buildLeftButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        this.copyStartLeftAction = new CopyStartLeftAction();
        JButton btn = new JButton(this.copyStartLeftAction);
        btn.setName("button.copystartleft");
        pnl.add((Component)btn, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        this.copyBeforeCurrentLeftAction = new CopyBeforeCurrentLeftAction();
        btn = new JButton(this.copyBeforeCurrentLeftAction);
        btn.setName("button.copybeforecurrentleft");
        pnl.add((Component)btn, gc);
        gc.gridx = 0;
        gc.gridy = 2;
        this.copyAfterCurrentLeftAction = new CopyAfterCurrentLeftAction();
        btn = new JButton(this.copyAfterCurrentLeftAction);
        btn.setName("button.copyaftercurrentleft");
        pnl.add((Component)btn, gc);
        gc.gridx = 0;
        gc.gridy = 3;
        this.copyEndLeftAction = new CopyEndLeftAction();
        btn = new JButton(this.copyEndLeftAction);
        btn.setName("button.copyendleft");
        pnl.add((Component)btn, gc);
        return pnl;
    }

    protected JPanel buildRightButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        this.copyStartRightAction = new CopyStartRightAction();
        pnl.add((Component)new JButton(this.copyStartRightAction), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        this.copyBeforeCurrentRightAction = new CopyBeforeCurrentRightAction();
        pnl.add((Component)new JButton(this.copyBeforeCurrentRightAction), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        this.copyAfterCurrentRightAction = new CopyAfterCurrentRightAction();
        pnl.add((Component)new JButton(this.copyAfterCurrentRightAction), gc);
        gc.gridx = 0;
        gc.gridy = 3;
        this.copyEndRightAction = new CopyEndRightAction();
        pnl.add((Component)new JButton(this.copyEndRightAction), gc);
        return pnl;
    }

    protected JPanel buildMergedListControlButtons() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.anchor = 10;
        gc.weightx = 0.3;
        gc.weighty = 0.0;
        this.moveUpMergedAction = new MoveUpMergedAction();
        pnl.add((Component)new JButton(this.moveUpMergedAction), gc);
        gc.gridx = 1;
        gc.gridy = 0;
        this.moveDownMergedAction = new MoveDownMergedAction();
        pnl.add((Component)new JButton(this.moveDownMergedAction), gc);
        gc.gridx = 2;
        gc.gridy = 0;
        this.removeMergedAction = new RemoveMergedAction();
        pnl.add((Component)new JButton(this.removeMergedAction), gc);
        return pnl;
    }

    protected JPanel buildAdjustmentLockControlPanel(JCheckBox cb) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        panel.add(new JLabel(I18n.tr("lock scrolling")));
        panel.add(cb);
        return panel;
    }

    protected JPanel buildComparePairSelectionPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.add(new JLabel(I18n.tr("Compare ")));
        JComboBox cbComparePair = new JComboBox(this.model.getComparePairListModel());
        cbComparePair.setRenderer(new ComparePairListCellRenderer());
        p.add(cbComparePair);
        return p;
    }

    protected JPanel buildFrozeStateControlPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        this.lblFrozenState = new JLabel();
        p.add(this.lblFrozenState);
        this.freezeAction = new FreezeAction();
        JToggleButton btn = new JToggleButton(this.freezeAction);
        this.freezeAction.adapt(btn);
        btn.setName("button.freeze");
        p.add(btn);
        return p;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.insets = new Insets(10, 0, 0, 0);
        this.lblMyVersion = new JLabel(I18n.tr("My version"));
        this.lblMyVersion.setToolTipText(I18n.tr("List of elements in my dataset, i.e. the local dataset"));
        this.add((Component)this.lblMyVersion, gc);
        gc.gridx = 2;
        gc.gridy = 0;
        this.lblMergedVersion = new JLabel(I18n.tr("Merged version"));
        this.lblMergedVersion.setToolTipText(I18n.tr("List of merged elements. They will replace the my elements when the merge decisions are applied."));
        this.add((Component)this.lblMergedVersion, gc);
        gc.gridx = 4;
        gc.gridy = 0;
        this.lblTheirVersion = new JLabel(I18n.tr("Their version"));
        this.lblTheirVersion.setToolTipText(I18n.tr("List of elements in their dataset, i.e. the server dataset"));
        this.add((Component)this.lblTheirVersion, gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.anchor = 23;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        gc.insets = new Insets(0, 0, 0, 0);
        this.cbLockMyScrolling = new JCheckBox();
        this.cbLockMyScrolling.setName("checkbox.lockmyscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(this.cbLockMyScrolling), gc);
        gc.gridx = 2;
        gc.gridy = 1;
        this.cbLockMergedScrolling = new JCheckBox();
        this.cbLockMergedScrolling.setName("checkbox.lockmergedscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(this.cbLockMergedScrolling), gc);
        gc.gridx = 4;
        gc.gridy = 1;
        this.cbLockTheirScrolling = new JCheckBox();
        this.cbLockTheirScrolling.setName("checkbox.locktheirscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(this.cbLockTheirScrolling), gc);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.33;
        gc.weighty = 1.0;
        gc.insets = new Insets(0, 0, 0, 0);
        JScrollPane pane = this.buildMyElementsTable();
        this.adjustmentSynchronizer.adapt(this.cbLockMyScrolling, pane.getVerticalScrollBar());
        this.add((Component)pane, gc);
        gc.gridx = 1;
        gc.gridy = 2;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildLeftButtonPanel(), gc);
        gc.gridx = 2;
        gc.gridy = 2;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        pane = this.buildMergedElementsTable();
        this.adjustmentSynchronizer.adapt(this.cbLockMergedScrolling, pane.getVerticalScrollBar());
        this.add((Component)pane, gc);
        gc.gridx = 3;
        gc.gridy = 2;
        gc.fill = 0;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildRightButtonPanel(), gc);
        gc.gridx = 4;
        gc.gridy = 2;
        gc.fill = 1;
        gc.anchor = 23;
        gc.weightx = 0.33;
        gc.weighty = 0.0;
        pane = this.buildTheirElementsTable();
        this.adjustmentSynchronizer.adapt(this.cbLockTheirScrolling, pane.getVerticalScrollBar());
        this.add((Component)pane, gc);
        gc.gridx = 2;
        gc.gridy = 3;
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildMergedListControlButtons(), gc);
        gc.gridx = 0;
        gc.gridy = 4;
        gc.gridwidth = 2;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.anchor = 21;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildComparePairSelectionPanel(), gc);
        gc.gridx = 2;
        gc.gridy = 4;
        gc.gridwidth = 3;
        gc.gridheight = 1;
        gc.fill = 2;
        gc.anchor = 21;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        this.add((Component)this.buildFrozeStateControlPanel(), gc);
        this.wireActionsToSelectionModels();
    }

    public ListMerger(ListMergeModel<T> model) {
        this.model = model;
        model.addObserver(this);
        this.build();
        model.addPropertyChangeListener(this);
    }

    protected void handlePropertyChangeFrozen(boolean oldValue, boolean newValue) {
        this.myEntriesTable.getSelectionModel().clearSelection();
        this.myEntriesTable.setEnabled(!newValue);
        this.theirEntriesTable.getSelectionModel().clearSelection();
        this.theirEntriesTable.setEnabled(!newValue);
        this.mergedEntriesTable.getSelectionModel().clearSelection();
        this.mergedEntriesTable.setEnabled(!newValue);
        if (this.freezeAction != null) {
            this.freezeAction.putValue(FreezeActionProperties.PROP_SELECTED, newValue);
        }
        if (newValue) {
            this.lblFrozenState.setText(I18n.tr("<html>Click <strong>{0}</strong> to start merging my and their entries.</html>", this.freezeAction.getValue("Name")));
        } else {
            this.lblFrozenState.setText(I18n.tr("<html>Click <strong>{0}</strong> to finish merging my and their entries.</html>", this.freezeAction.getValue("Name")));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ListMergeModel.FROZEN_PROP)) {
            this.handlePropertyChangeFrozen((Boolean)evt.getOldValue(), (Boolean)evt.getNewValue());
        }
    }

    public ListMergeModel<T> getModel() {
        return this.model;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.lblMyVersion.setText(I18n.trn("My version ({0} entry)", "My version ({0} entries)", this.model.getMyEntriesSize(), this.model.getMyEntriesSize()));
        this.lblMergedVersion.setText(I18n.trn("Merged version ({0} entry)", "Merged version ({0} entries)", this.model.getMergedEntriesSize(), this.model.getMergedEntriesSize()));
        this.lblTheirVersion.setText(I18n.trn("Their version ({0} entry)", "Their version ({0} entries)", this.model.getTheirEntriesSize(), this.model.getTheirEntriesSize()));
    }

    class AdjustmentSynchronizer
    implements AdjustmentListener {
        private final ArrayList<Adjustable> synchronizedAdjustables = new ArrayList();
        private final HashMap<Adjustable, Boolean> enabledMap = new HashMap();
        private final Observable observable = new Observable();

        public void participateInSynchronizedScrolling(Adjustable adjustable) {
            if (adjustable == null) {
                return;
            }
            if (this.synchronizedAdjustables.contains(adjustable)) {
                return;
            }
            this.synchronizedAdjustables.add(adjustable);
            this.setParticipatingInSynchronizedScrolling(adjustable, true);
            adjustable.addAdjustmentListener(this);
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (!this.enabledMap.get(e.getAdjustable()).booleanValue()) {
                return;
            }
            for (Adjustable a : this.synchronizedAdjustables) {
                if (a == e.getAdjustable() || !this.isParticipatingInSynchronizedScrolling(a)) continue;
                a.setValue(e.getValue());
            }
        }

        protected void setParticipatingInSynchronizedScrolling(Adjustable adjustable, boolean isParticipating) {
            if (adjustable == null) {
                throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "adjustable"));
            }
            if (!this.synchronizedAdjustables.contains(adjustable)) {
                throw new IllegalStateException(I18n.tr("Adjustable {0} not registered yet. Can't set participation in synchronized adjustment.", adjustable));
            }
            this.enabledMap.put(adjustable, isParticipating);
            this.observable.notifyObservers();
        }

        protected boolean isParticipatingInSynchronizedScrolling(Adjustable adjustable) throws IllegalStateException {
            if (!this.synchronizedAdjustables.contains(adjustable)) {
                throw new IllegalStateException(I18n.tr("Adjustable {0} not registered yet.", adjustable));
            }
            return this.enabledMap.get(adjustable);
        }

        protected void adapt(final JCheckBox view, final Adjustable adjustable) throws IllegalArgumentException, IllegalStateException {
            if (adjustable == null) {
                throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "adjustable"));
            }
            if (view == null) {
                throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "view"));
            }
            if (!this.synchronizedAdjustables.contains(adjustable)) {
                this.participateInSynchronizedScrolling(adjustable);
            }
            view.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    switch (e.getStateChange()) {
                        case 1: {
                            if (AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                            AdjustmentSynchronizer.this.setParticipatingInSynchronizedScrolling(adjustable, true);
                            break;
                        }
                        case 2: {
                            if (!AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                            AdjustmentSynchronizer.this.setParticipatingInSynchronizedScrolling(adjustable, false);
                        }
                    }
                }
            });
            this.observable.addObserver(new Observer(){

                public void update(Observable o, Object arg) {
                    boolean sync = AdjustmentSynchronizer.this.isParticipatingInSynchronizedScrolling(adjustable);
                    if (view.isSelected() != sync) {
                        view.setSelected(sync);
                    }
                }
            });
            this.setParticipatingInSynchronizedScrolling(adjustable, true);
            view.setSelected(true);
        }
    }

    class FreezeAction
    extends AbstractAction
    implements ItemListener,
    FreezeActionProperties {
        public FreezeAction() {
            this.putValue("Name", I18n.tr("Freeze"));
            this.putValue("ShortDescription", I18n.tr("Freeze the current list of merged elements."));
            this.putValue(PROP_SELECTED, false);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent arg0) {
        }

        public void adapt(final JToggleButton btn) {
            btn.addItemListener(this);
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals(FreezeActionProperties.PROP_SELECTED)) {
                        btn.setSelected((Boolean)evt.getNewValue());
                    }
                }
            });
        }

        public void itemStateChanged(ItemEvent e) {
            int state2 = e.getStateChange();
            if (state2 == 1) {
                this.putValue("Name", I18n.tr("Unfreeze"));
                this.putValue("ShortDescription", I18n.tr("Unfreeze the list of merged elements and start merging."));
                ListMerger.this.model.setFrozen(true);
            } else if (state2 == 2) {
                this.putValue("Name", I18n.tr("Freeze"));
                this.putValue("ShortDescription", I18n.tr("Freeze the current list of merged elements."));
                ListMerger.this.model.setFrozen(false);
            }
            boolean isSelected = (Boolean)this.getValue(PROP_SELECTED);
            if (isSelected != (e.getStateChange() == 1)) {
                this.putValue(PROP_SELECTED, e.getStateChange() == 1);
            }
        }
    }

    public static interface FreezeActionProperties {
        public static final String PROP_SELECTED = FreezeActionProperties.class.getName() + ".selected";
    }

    class RemoveMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveMergedAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "remove.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", I18n.tr("Remove"));
            }
            this.putValue("ShortDescription", I18n.tr("Remove the selected entries from the list of merged elements."));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] rows = ListMerger.this.mergedEntriesTable.getSelectedRows();
            ListMerger.this.model.removeMerged(rows);
        }

        public void valueChanged(ListSelectionEvent e) {
            int[] rows = ListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(rows != null && rows.length > 0);
        }
    }

    class MoveDownMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        public MoveDownMergedAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "movedown.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", I18n.tr("Down"));
            }
            this.putValue("ShortDescription", I18n.tr("Move down the selected entries by one position."));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] rows = ListMerger.this.mergedEntriesTable.getSelectedRows();
            ListMerger.this.model.moveDownMerged(rows);
        }

        public void valueChanged(ListSelectionEvent e) {
            int[] rows = ListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(rows != null && rows.length > 0 && rows[rows.length - 1] != ListMerger.this.mergedEntriesTable.getRowCount() - 1);
        }
    }

    class MoveUpMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        public MoveUpMergedAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "moveup.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", I18n.tr("Up"));
            }
            this.putValue("ShortDescription", I18n.tr("Move up the selected elements by one position."));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] rows = ListMerger.this.mergedEntriesTable.getSelectedRows();
            ListMerger.this.model.moveUpMerged(rows);
        }

        public void valueChanged(ListSelectionEvent e) {
            int[] rows = ListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(rows != null && rows.length > 0 && rows[0] != 0);
        }
    }

    class CopyAfterCurrentRightAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyAfterCurrentRightAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "copyaftercurrentright.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", "< after");
            }
            this.putValue("ShortDescription", I18n.tr("Copy their selected element after the first selected element in the list of merged elements"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] myRows = ListMerger.this.theirEntriesTable.getSelectedRows();
            int[] mergedRows = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (mergedRows == null || mergedRows.length == 0) {
                return;
            }
            int current = mergedRows[0];
            ListMerger.this.model.copyTheirAfterCurrent(myRows, current);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyBeforeCurrentRightAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyBeforeCurrentRightAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "copybeforecurrentright.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", "< before");
            }
            this.putValue("ShortDescription", I18n.tr("Copy their selected elements before the first selected element in the list of merged elements."));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] myRows = ListMerger.this.theirEntriesTable.getSelectedRows();
            int[] mergedRows = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (mergedRows == null || mergedRows.length == 0) {
                return;
            }
            int current = mergedRows[0];
            ListMerger.this.model.copyTheirBeforeCurrent(myRows, current);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyEndRightAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyEndRightAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "copyendright.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", "< bottom");
            }
            this.putValue("ShortDescription", I18n.tr("Copy their selected elements to the end of the list of merged elements."));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] rows = ListMerger.this.theirEntriesTable.getSelectedRows();
            ListMerger.this.model.copyTheirToEnd(rows);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyStartRightAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyStartRightAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "copystartright.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", "< top");
            }
            this.putValue("ShortDescription", I18n.tr("Copy their selected element to the start of the list of merged elements."));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] rows = ListMerger.this.theirEntriesTable.getSelectedRows();
            ListMerger.this.model.copyTheirToTop(rows);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyAfterCurrentLeftAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyAfterCurrentLeftAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "copyaftercurrentleft.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", "> after");
            }
            this.putValue("ShortDescription", I18n.tr("Copy my selected elements after the first selected element in the list of merged elements."));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] myRows = ListMerger.this.myEntriesTable.getSelectedRows();
            int[] mergedRows = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (mergedRows == null || mergedRows.length == 0) {
                return;
            }
            int current = mergedRows[0];
            ListMerger.this.model.copyMyAfterCurrent(myRows, current);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyBeforeCurrentLeftAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyBeforeCurrentLeftAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "copybeforecurrentleft.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", "> before");
            }
            this.putValue("ShortDescription", I18n.tr("Copy my selected elements before the first selected element in the list of merged elements."));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] myRows = ListMerger.this.myEntriesTable.getSelectedRows();
            int[] mergedRows = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (mergedRows == null || mergedRows.length == 0) {
                return;
            }
            int current = mergedRows[0];
            ListMerger.this.model.copyMyBeforeCurrent(myRows, current);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyEndLeftAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyEndLeftAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "copyendleft.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", I18n.tr("> bottom"));
            }
            this.putValue("ShortDescription", I18n.tr("Copy my selected elements to the end of the list of merged elements."));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] rows = ListMerger.this.myEntriesTable.getSelectedRows();
            ListMerger.this.model.copyMyToEnd(rows);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyStartLeftAction
    extends AbstractAction
    implements ListSelectionListener {
        public CopyStartLeftAction() {
            ImageIcon icon = ImageProvider.get("dialogs/conflict", "copystartleft.png");
            this.putValue("SmallIcon", icon);
            if (icon == null) {
                this.putValue("Name", I18n.tr("> top"));
            }
            this.putValue("ShortDescription", I18n.tr("Copy my selected nodes to the start of the merged node list"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent arg0) {
            int[] rows = ListMerger.this.myEntriesTable.getSelectedRows();
            ListMerger.this.model.copyMyToTop(rows);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }
}

