/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.relation;

import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.RelationMemberConflictResolverCommand;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberListMergeModel
extends ListMergeModel<RelationMember> {
    private static final Logger logger = Logger.getLogger(RelationMemberListMergeModel.class.getName());

    @Override
    public boolean isEqualEntry(RelationMember e1, RelationMember e2) {
        boolean ret = e1.getRole().equals(e2.getRole());
        ret = !e1.getMember().isNew() ? ret && e1.getMember().getId() == e2.getMember().getId() : ret && e1 == e2;
        return ret;
    }

    @Override
    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new ListMergeModel.EntriesTableModel(this, ListRole.MERGED_ENTRIES){
            {
                RelationMemberListMergeModel relationMemberListMergeModel2 = x0;
                relationMemberListMergeModel2.getClass();
                super(x1);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                switch (column) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected void setValueAt(DefaultTableModel model, Object value, int row, int col) {
        if (model == this.getMergedTableModel() && col == 1) {
            RelationMember memberOld = (RelationMember)this.getMergedEntries().get(row);
            RelationMember memberNew = new RelationMember((String)value, memberOld.getMember());
            this.getMergedEntries().remove(row);
            this.getMergedEntries().add(row, memberNew);
            this.fireModelDataChanged();
        }
    }

    public void populate(Relation my, Relation their) {
        if (my == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "my"));
        }
        if (their == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "their"));
        }
        this.getMergedEntries().clear();
        this.getMyEntries().clear();
        this.getTheirEntries().clear();
        for (RelationMember n : my.getMembers()) {
            this.getMyEntries().add(n);
        }
        for (RelationMember n : their.getMembers()) {
            this.getTheirEntries().add(n);
        }
        if (this.myAndTheirEntriesEqual()) {
            for (RelationMember m : this.getMyEntries()) {
                this.getMergedEntries().add(this.cloneEntryForMergedList(m));
            }
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    @Override
    protected RelationMember cloneEntryForMergedList(RelationMember entry) {
        return new RelationMember(entry);
    }

    public RelationMemberConflictResolverCommand buildResolveCommand(Relation my, Relation their) {
        if (my == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "my"));
        }
        if (their == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "their"));
        }
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("Merged nodes not frozen yet. Can't build resolution command"));
        }
        return new RelationMemberConflictResolverCommand(my, their, this.getMergedEntries());
    }
}

