/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiValueResolutionDecision {
    private MultiValueDecisionType type;
    private TagCollection tags;
    private String value;

    public MultiValueResolutionDecision() {
        this.type = MultiValueDecisionType.UNDECIDED;
        this.tags = new TagCollection();
        this.autoDecide();
    }

    public MultiValueResolutionDecision(TagCollection tags) throws IllegalArgumentException {
        if (tags == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "tags"));
        }
        if (tags.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be empty.", "tags"));
        }
        if (tags.getKeys().size() != 1) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' with tags for exactly one key expected. Got {1}.", "tags", tags.getKeys().size()));
        }
        this.tags = tags;
        this.autoDecide();
    }

    protected void autoDecide() {
        this.type = MultiValueDecisionType.UNDECIDED;
        if (this.tags.size() == 1 && this.tags.getValues().contains("")) {
            this.type = MultiValueDecisionType.KEEP_NONE;
        } else if (this.tags.size() == 1) {
            this.type = MultiValueDecisionType.KEEP_ONE;
            this.value = this.tags.getValues().iterator().next();
        }
    }

    public void keepNone() {
        this.type = MultiValueDecisionType.KEEP_NONE;
    }

    public void keepAll() {
        this.type = MultiValueDecisionType.KEEP_ALL;
    }

    public void keepOne(String value) throws IllegalArgumentException, IllegalStateException {
        if (value == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "value"));
        }
        if (!this.tags.getValues().contains(value)) {
            throw new IllegalStateException(I18n.tr("Tag collection doesn't include the selected value ''{0}''.", value));
        }
        this.value = value;
        this.type = MultiValueDecisionType.KEEP_ONE;
    }

    public void setNew(String value) {
        if (value == null) {
            value = "";
        }
        this.value = value;
        this.type = MultiValueDecisionType.KEEP_ONE;
    }

    public void undecide() {
        this.type = MultiValueDecisionType.UNDECIDED;
    }

    public String getChosenValue() throws IllegalStateException {
        switch (this.type) {
            case UNDECIDED: {
                throw new IllegalStateException(I18n.tr("Not decided yet."));
            }
            case KEEP_ONE: {
                return this.value;
            }
            case KEEP_NONE: {
                return null;
            }
            case KEEP_ALL: {
                return this.tags.getJoinedValues(this.getKey());
            }
        }
        return null;
    }

    public List<String> getValues() {
        ArrayList<String> ret = new ArrayList<String>(this.tags.getValues());
        ret.remove("");
        ret.remove(null);
        Collections.sort(ret);
        return ret;
    }

    public String getKey() {
        return this.tags.getKeys().iterator().next();
    }

    public boolean canKeepNone() {
        return this.tags.getValues().contains("");
    }

    public boolean canKeepAll() {
        return this.getValues().size() > 1;
    }

    public boolean isDecided() {
        return !this.type.equals((Object)MultiValueDecisionType.UNDECIDED);
    }

    public MultiValueDecisionType getDecisionType() {
        return this.type;
    }

    public void applyTo(OsmPrimitive primitive) throws IllegalStateException {
        if (primitive == null) {
            return;
        }
        if (!this.isDecided()) {
            throw new IllegalStateException(I18n.tr("Not decided yet."));
        }
        String key = this.tags.getKeys().iterator().next();
        String value = this.getChosenValue();
        if (this.type.equals((Object)MultiValueDecisionType.KEEP_NONE)) {
            primitive.remove(key);
        } else {
            primitive.put(key, value);
        }
    }

    public void applyTo(Collection<? extends OsmPrimitive> primtives) throws IllegalStateException {
        if (primtives == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : primtives) {
            if (osmPrimitive == null) continue;
            this.applyTo(osmPrimitive);
        }
    }

    public Command buildChangeCommand(OsmPrimitive primitive) throws IllegalArgumentException, IllegalStateException {
        if (primitive == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "primitive"));
        }
        if (!this.isDecided()) {
            throw new IllegalStateException(I18n.tr("Not decided yet."));
        }
        String key = this.tags.getKeys().iterator().next();
        String value = this.getChosenValue();
        ChangePropertyCommand cmd = new ChangePropertyCommand(primitive, key, value);
        return cmd;
    }

    public Command buildChangeCommand(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "primitives"));
        }
        if (!this.isDecided()) {
            throw new IllegalStateException(I18n.tr("Not decided yet."));
        }
        String key = this.tags.getKeys().iterator().next();
        String value = this.getChosenValue();
        ChangePropertyCommand cmd = new ChangePropertyCommand(primitives, key, value);
        return cmd;
    }

    public Tag getResolution() {
        switch (this.type) {
            case KEEP_ALL: {
                return new Tag(this.getKey(), this.tags.getJoinedValues(this.getKey()));
            }
            case KEEP_ONE: {
                return new Tag(this.getKey(), this.value);
            }
            case KEEP_NONE: {
                return new Tag(this.getKey(), "");
            }
            case UNDECIDED: {
                return null;
            }
        }
        return null;
    }
}

