/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverTable;
import org.openstreetmap.josm.gui.tagging.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberConflictResolver
extends JPanel {
    private AutoCompletingTextField tfRole;
    private AutoCompletingTextField tfKey;
    private AutoCompletingTextField tfValue;
    private JCheckBox cbTagRelations;
    private RelationMemberConflictResolverModel model;
    private RelationMemberConflictResolverTable tblResolver;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.model = new RelationMemberConflictResolverModel();
        this.tblResolver = new RelationMemberConflictResolverTable(this.model);
        this.add((Component)new JScrollPane(this.tblResolver), "Center");
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        pnl.add(this.buildRoleEditingPanel());
        pnl.add(this.buildTagRelationsPanel());
        this.add((Component)pnl, "South");
    }

    protected JPanel buildRoleEditingPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(0));
        pnl.add(new JLabel(I18n.tr("Role:")));
        this.tfRole = new AutoCompletingTextField(10);
        pnl.add(this.tfRole);
        pnl.add(new JButton(new ApplyRoleAction()));
        return pnl;
    }

    protected JPanel buildTagRelationsPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(0));
        this.cbTagRelations = new JCheckBox(I18n.tr("Tag modified relations with   "));
        this.cbTagRelations.addChangeListener(new ToggleTagRelationsAction());
        pnl.add(this.cbTagRelations);
        pnl.add(new JLabel(I18n.trc("tag", "Key:")));
        this.tfKey = new AutoCompletingTextField(10);
        pnl.add(this.tfKey);
        pnl.add(new JLabel(I18n.tr("Value:")));
        this.tfValue = new AutoCompletingTextField(10);
        pnl.add(this.tfValue);
        this.cbTagRelations.setSelected(false);
        this.tfKey.setEnabled(false);
        this.tfValue.setEnabled(false);
        return pnl;
    }

    public RelationMemberConflictResolver() {
        this.build();
    }

    public RelationMemberConflictResolverModel getModel() {
        return this.model;
    }

    public Command buildTagApplyCommands(Collection<? extends OsmPrimitive> primitives) {
        if (!this.cbTagRelations.isSelected()) {
            return null;
        }
        if (this.tfKey.getText().trim().equals("")) {
            return null;
        }
        if (this.tfValue.getText().trim().equals("")) {
            return null;
        }
        if (primitives == null || primitives.isEmpty()) {
            return null;
        }
        return new ChangePropertyCommand(primitives, this.tfKey.getText(), this.tfValue.getText());
    }

    public void prepareForEditing() {
        AutoCompletionCache.getCacheForLayer(Main.main.getEditLayer()).initFromDataSet();
        AutoCompletionList acList = new AutoCompletionList();
        AutoCompletionCache.getCacheForLayer(Main.main.getEditLayer()).populateWithMemberRoles(acList);
        this.tfRole.setAutoCompletionList(acList);
        AutoCompletingTextField editor = (AutoCompletingTextField)this.tblResolver.getColumnModel().getColumn(2).getCellEditor();
        if (editor != null) {
            editor.setAutoCompletionList(acList);
        }
        AutoCompletionList acList2 = new AutoCompletionList();
        AutoCompletionCache.getCacheForLayer(Main.main.getEditLayer()).populateWithKeys(acList2, false);
        this.tfKey.setAutoCompletionList(acList2);
    }

    class ToggleTagRelationsAction
    implements ChangeListener {
        ToggleTagRelationsAction() {
        }

        public void stateChanged(ChangeEvent e) {
            ButtonModel buttonModel = ((AbstractButton)e.getSource()).getModel();
            RelationMemberConflictResolver.this.tfKey.setEnabled(buttonModel.isSelected());
            RelationMemberConflictResolver.this.tfValue.setEnabled(buttonModel.isSelected());
            RelationMemberConflictResolver.this.tfKey.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
            RelationMemberConflictResolver.this.tfValue.setBackground(buttonModel.isSelected() ? UIManager.getColor("TextField.background") : UIManager.getColor("Panel.background"));
        }
    }

    class ApplyRoleAction
    extends AbstractAction {
        public ApplyRoleAction() {
            this.putValue("Name", I18n.tr("Apply"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Apply this role to all members"));
        }

        public void actionPerformed(ActionEvent e) {
            RelationMemberConflictResolver.this.model.applyRole(RelationMemberConflictResolver.this.tfRole.getText());
        }
    }
}

