/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.pair.ConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.properties.OperationCancelledException;
import org.openstreetmap.josm.gui.help.HelpBrowserProxy;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflictResolutionDialog
extends JDialog
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ConflictResolutionDialog.class.getName());
    public static final Dimension DEFAULT_SIZE = new Dimension(600, 400);
    private ConflictResolver resolver;

    protected void restorePositionAndDimension() {
        Point p = new Point();
        Dimension d = new Dimension();
        try {
            p.x = Integer.parseInt(Main.pref.get("conflictresolutiondialog.x", "0"));
            p.x = Math.max(0, p.x);
        }
        catch (Exception e) {
            logger.warning("unexpected value for preference conflictresolutiondialog.x, assuming 0");
            p.x = 0;
        }
        try {
            p.y = Integer.parseInt(Main.pref.get("conflictresolutiondialog.y", "0"));
            p.y = Math.max(0, p.y);
        }
        catch (Exception e) {
            logger.warning("unexpected value for preference conflictresolutiondialog.x, assuming 0");
            p.y = 0;
        }
        try {
            d.width = Integer.parseInt(Main.pref.get("conflictresolutiondialog.width", Integer.toString(ConflictResolutionDialog.DEFAULT_SIZE.width)));
            d.width = Math.max(0, d.width);
        }
        catch (Exception e) {
            logger.warning("unexpected value for preference conflictresolutiondialog.width, assuming " + ConflictResolutionDialog.DEFAULT_SIZE.width);
            p.y = 0;
        }
        try {
            d.height = Integer.parseInt(Main.pref.get("conflictresolutiondialog.height", Integer.toString(ConflictResolutionDialog.DEFAULT_SIZE.height)));
            d.height = Math.max(0, d.height);
        }
        catch (Exception e) {
            logger.warning("unexpected value for preference conflictresolutiondialog.height, assuming " + ConflictResolutionDialog.DEFAULT_SIZE.height);
            p.y = 0;
        }
        this.setLocation(p);
        this.setSize(d);
    }

    protected void rememberPositionAndDimension() {
        Point p = this.getLocation();
        Main.pref.put("conflictresolutiondialog.x", Integer.toString(p.x));
        Main.pref.put("conflictresolutiondialog.y", Integer.toString(p.y));
        Dimension d = this.getSize();
        Main.pref.put("conflictresolutiondialog.width", Integer.toString(d.width));
        Main.pref.put("conflictresolutiondialog.height", Integer.toString(d.height));
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.restorePositionAndDimension();
            this.toFront();
        } else {
            this.rememberPositionAndDimension();
        }
        super.setVisible(isVisible);
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        ApplyResolutionAction applyResolutionAction = new ApplyResolutionAction();
        this.resolver.addPropertyChangeListener(applyResolutionAction);
        JButton btn = new JButton(applyResolutionAction);
        btn.setName("button.apply");
        pnl.add(btn);
        btn = new JButton(new CancelAction());
        btn.setName("button.cancel");
        pnl.add(btn);
        btn = new JButton(new HelpAction());
        btn.setName("button.help");
        pnl.add(btn);
        pnl.setBorder(BorderFactory.createLoweredBevelBorder());
        return pnl;
    }

    protected void build() {
        this.updateTitle();
        this.getContentPane().setLayout(new BorderLayout());
        this.resolver = new ConflictResolver();
        this.resolver.setName("panel.conflictresolver");
        this.getContentPane().add((Component)this.resolver, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.resolver.addPropertyChangeListener(this);
        HelpUtil.setHelpContext(this.getRootPane(), "Dialog/ConflictDialog");
    }

    public ConflictResolutionDialog(Component parent) {
        super(JOptionPane.getFrameForComponent(parent), true);
        this.build();
    }

    public ConflictResolver getConflictResolver() {
        return this.resolver;
    }

    protected void updateTitle() {
        this.updateTitle(null);
    }

    protected void updateTitle(OsmPrimitive my) {
        if (my == null) {
            this.setTitle(I18n.tr("Resolve conflicts"));
        } else {
            this.setTitle(I18n.tr("Resolve conflicts for ''{0}''", my.getDisplayName(DefaultNameFormatter.getInstance())));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(ConflictResolver.MY_PRIMITIVE_PROP)) {
            this.updateTitle((OsmPrimitive)evt.getNewValue());
        }
    }

    class ApplyResolutionAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyResolutionAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts and close the dialog"));
            this.putValue("Name", I18n.tr("Apply Resolution"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "conflict"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(ConflictResolutionDialog.this.resolver.isResolvedCompletely());
        }

        public void actionPerformed(ActionEvent arg0) {
            if (!ConflictResolutionDialog.this.resolver.isResolvedCompletely()) {
                Object[] options = new Object[]{I18n.tr("Close anyway"), I18n.tr("Continue resolving")};
                int ret = JOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>You didn''t finish to merge the differences in this conflict.<br>Conflict resolutions won't be applied unless all differences<br>are resolved.Click <strong>{0}</strong> to close anyway.<strong>Already<br>resolved differences won't be applied.</strong><br>Click <strong>{1}</strong> to return to resolving conflicts.</html>", options[0].toString(), options[1].toString()), I18n.tr("Conflict not resolved completely"), 0, 2, null, options, options[1]);
                switch (ret) {
                    case 0: {
                        ConflictResolutionDialog.this.setVisible(false);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            try {
                Command cmd = ConflictResolutionDialog.this.resolver.buildResolveCommand();
                Main.main.undoRedo.add(cmd);
                ConflictResolutionDialog.this.setVisible(false);
            }
            catch (OperationCancelledException operationCancelledException) {
                // empty catch block
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(ConflictResolver.RESOLVED_COMPLETELY_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information"));
            this.putValue("Name", I18n.tr("Help"));
            this.putValue("SmallIcon", ImageProvider.get("help"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent arg0) {
            HelpBrowserProxy.getInstance().setUrlForHelpTopic("/Dialog/ConflictDialog");
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution and close the dialog"));
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent arg0) {
            ConflictResolutionDialog.this.setVisible(false);
        }
    }
}

