/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.widgets.AutoCompleteComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDialog
extends ToggleDialog
implements SelectionChangedListener,
Layer.LayerChangeListener {
    private final Map<String, Map<String, Integer>> valueCount = new TreeMap<String, Map<String, Integer>>();
    private String objKey;
    private final DefaultTableModel propertyData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    };
    private final DefaultTableModel membershipData = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }
    };
    private final JTable propertyTable = new JTable(this.propertyData);
    private final JTable membershipTable = new JTable(this.membershipData);
    public JComboBox taggingPresets = new JComboBox();
    private final SideButton btnAdd;
    private final SideButton btnEdit;
    private final SideButton btnDel;
    private final JPanel presets = new JPanel(new GridBagLayout());
    private final JLabel selectSth = new JLabel("<html><p>" + I18n.tr("Please select the objects you want to change properties for.") + "</p></html>");

    void propertyEdit(int row) {
        String newkey;
        String key;
        Collection<OsmPrimitive> sel = Main.main.getCurrentDataSet().getSelected();
        if (sel.isEmpty()) {
            return;
        }
        this.objKey = key = this.propertyData.getValueAt(row, 0).toString();
        String msg = "<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", sel.size(), sel.size()) + "<br><br>(" + I18n.tr("An empty value deletes the key.", key) + ")</html>";
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(msg), "North");
        TreeMap<String, TreeSet<String>> allData = this.createAutoCompletionInfo(true);
        JPanel p = new JPanel(new GridBagLayout());
        panel.add((Component)p, "Center");
        AutoCompleteComboBox keys = new AutoCompleteComboBox();
        keys.setPossibleItems(allData.keySet());
        keys.setEditable(true);
        keys.setSelectedItem(key);
        p.add((Component)new JLabel(I18n.tr("Key")), GBC.std());
        p.add(Box.createHorizontalStrut(10), GBC.std());
        p.add((Component)keys, GBC.eol().fill(2));
        final AutoCompleteComboBox values = new AutoCompleteComboBox();
        values.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel) {
                    Map m;
                    String str = null;
                    str = (String)value;
                    if (PropertiesDialog.this.valueCount.containsKey(PropertiesDialog.this.objKey) && (m = (Map)PropertiesDialog.this.valueCount.get(PropertiesDialog.this.objKey)).containsKey(str)) {
                        str = str + "(" + m.get(str) + ")";
                        c.setFont(c.getFont().deriveFont(3));
                    }
                    ((JLabel)c).setText(str);
                }
                return c;
            }
        });
        values.setEditable(true);
        this.updateListData(key, allData, values);
        Map m = (Map)this.propertyData.getValueAt(row, 1);
        String selection = m.size() != 1 ? I18n.tr("<different>") : (String)m.entrySet().iterator().next().getKey();
        values.setSelectedItem(selection);
        values.getEditor().setItem(selection);
        p.add((Component)new JLabel(I18n.tr("Value")), GBC.std());
        p.add(Box.createHorizontalStrut(10), GBC.std());
        p.add((Component)values, GBC.eol().fill(2));
        this.addFocusAdapter(row, allData, keys, values);
        final JOptionPane optionPane = new JOptionPane(panel, 3, 2){

            public void selectInitialValue() {
                values.requestFocusInWindow();
                values.getEditor().selectAll();
            }
        };
        final JDialog dlg = optionPane.createDialog(Main.parent, I18n.tr("Change values?"));
        values.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dlg.setVisible(false);
                optionPane.setValue(0);
            }
        });
        String oldValue = values.getEditor().getItem().toString();
        dlg.setVisible(true);
        Object answer = optionPane.getValue();
        if (answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0) {
            values.getEditor().setItem(oldValue);
            return;
        }
        String value = values.getEditor().getItem().toString().trim();
        if (value.equals("")) {
            value = null;
        }
        if ((newkey = keys.getEditor().getItem().toString().trim()).equals("")) {
            newkey = key;
            value = null;
        }
        if (key.equals(newkey) || value == null) {
            Main.main.undoRedo.add(new ChangePropertyCommand(sel, newkey, value));
        } else {
            Vector<Command> commands = new Vector<Command>();
            commands.add(new ChangePropertyCommand(sel, key, null));
            if (value.equals(I18n.tr("<different>"))) {
                HashMap map = new HashMap();
                for (OsmPrimitive osmPrimitive : sel) {
                    String val = osmPrimitive.get(key);
                    if (val == null) continue;
                    if (map.containsKey(val)) {
                        ((Vector)map.get(val)).add(osmPrimitive);
                        continue;
                    }
                    Vector<OsmPrimitive> v = new Vector<OsmPrimitive>();
                    v.add(osmPrimitive);
                    map.put(val, v);
                }
                for (Map.Entry entry : map.entrySet()) {
                    commands.add(new ChangePropertyCommand((Collection)entry.getValue(), newkey, (String)entry.getKey()));
                }
            } else {
                commands.add(new ChangePropertyCommand(sel, newkey, value));
            }
            Main.main.undoRedo.add(new SequenceCommand(I18n.trn("Change properties of up to {0} object", "Change properties of up to {0} objects", sel.size(), sel.size()), commands));
        }
        DataSet.fireSelectionChanged(sel);
        this.selectionChanged(sel);
        Main.parent.repaint();
        if (!key.equals(newkey)) {
            for (int i = 0; i < this.propertyTable.getRowCount(); ++i) {
                if (this.propertyData.getValueAt(i, 0).toString() != newkey) continue;
                row = i;
                break;
            }
        }
        this.propertyTable.changeSelection(row, 0, false, false);
    }

    private void updateListData(String key, TreeMap<String, TreeSet<String>> allData, AutoCompleteComboBox values) {
        Collection<String> newItems = allData.containsKey(key) ? (Collection)allData.get(key) : Collections.emptyList();
        values.setPossibleItems(newItems);
    }

    void membershipEdit(int row) {
        Relation relation = (Relation)this.membershipData.getValueAt(row, 0);
        Main.map.relationListDialog.selectRelation(relation);
        RelationEditor.getEditor(Main.map.mapView.getEditLayer(), relation, (Collection)this.membershipData.getValueAt(row, 1)).setVisible(true);
    }

    void add() {
        Collection<OsmPrimitive> sel = Main.main.getCurrentDataSet().getSelected();
        if (sel.isEmpty()) {
            return;
        }
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new JLabel("<html>" + I18n.trn("This will change up to {0} object.", "This will change up to {0} objects.", sel.size(), sel.size()) + "<br><br>" + I18n.tr("Please select a key")), "North");
        TreeMap<String, TreeSet<String>> allData = this.createAutoCompletionInfo(false);
        final AutoCompleteComboBox keys = new AutoCompleteComboBox();
        keys.setPossibleItems(allData.keySet());
        keys.setEditable(true);
        p.add((Component)keys, "Center");
        JPanel p2 = new JPanel(new BorderLayout());
        p.add((Component)p2, "South");
        p2.add((Component)new JLabel(I18n.tr("Please select a value")), "North");
        AutoCompleteComboBox values = new AutoCompleteComboBox();
        values.setEditable(true);
        p2.add((Component)values, "Center");
        this.addFocusAdapter(-1, allData, keys, values);
        JOptionPane pane = new JOptionPane(p, -1, 2){

            public void selectInitialValue() {
                keys.requestFocusInWindow();
                keys.getEditor().selectAll();
            }
        };
        JDialog dialog = pane.createDialog(Main.parent, I18n.tr("Change values?"));
        dialog.setVisible(true);
        if (!Integer.valueOf(0).equals(pane.getValue())) {
            return;
        }
        String key = keys.getEditor().getItem().toString().trim();
        String value = values.getEditor().getItem().toString().trim();
        if (value.equals("")) {
            return;
        }
        Main.main.undoRedo.add(new ChangePropertyCommand(sel, key, value));
        DataSet.fireSelectionChanged(sel);
        this.selectionChanged(sel);
        Main.parent.repaint();
    }

    private void addFocusAdapter(int row, final TreeMap<String, TreeSet<String>> allData, final AutoCompleteComboBox keys, final AutoCompleteComboBox values) {
        JTextComponent editor = (JTextComponent)values.getEditor().getEditorComponent();
        editor.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                String key = keys.getEditor().getItem().toString();
                PropertiesDialog.this.updateListData(key, allData, values);
                PropertiesDialog.this.objKey = key;
            }
        });
    }

    private TreeMap<String, TreeSet<String>> createAutoCompletionInfo(boolean edit) {
        TreeMap<String, TreeSet<String>> allData = new TreeMap<String, TreeSet<String>>();
        for (OsmPrimitive osm : Main.main.getCurrentDataSet().allNonDeletedPrimitives()) {
            for (String key : osm.keySet()) {
                TreeSet<Object> values = null;
                if (allData.containsKey(key)) {
                    values = allData.get(key);
                } else {
                    values = new TreeSet();
                    allData.put(key, values);
                }
                values.add(osm.get(key));
            }
        }
        if (!edit) {
            for (int i = 0; i < this.propertyData.getRowCount(); ++i) {
                allData.remove(this.propertyData.getValueAt(i, 0));
            }
        }
        return allData;
    }

    public PropertiesDialog(MapFrame mapFrame) {
        super(I18n.tr("Properties/Memberships"), "propertiesdialog", I18n.tr("Properties for selected objects."), Shortcut.registerShortcut("subwindow:properties", I18n.tr("Toggle: {0}", I18n.tr("Properties/Memberships")), 80, 4, 1), 150, true);
        this.propertyData.setColumnIdentifiers(new String[]{I18n.tr("Key"), I18n.tr("Value")});
        this.propertyTable.setSelectionMode(0);
        this.propertyTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (c instanceof JLabel) {
                    String str = null;
                    if (value instanceof String) {
                        str = (String)value;
                    } else if (value instanceof Map) {
                        Map v = (Map)value;
                        if (v.size() != 1) {
                            str = I18n.tr("<different>");
                            c.setFont(c.getFont().deriveFont(2));
                        } else {
                            Map.Entry entry = v.entrySet().iterator().next();
                            str = (String)entry.getKey();
                        }
                    }
                    ((JLabel)c).setText(str);
                }
                return c;
            }
        });
        this.membershipData.setColumnIdentifiers(new String[]{I18n.tr("Member Of"), I18n.tr("Role")});
        this.membershipTable.setSelectionMode(0);
        this.membershipTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (c instanceof JLabel) {
                    ((JLabel)c).setText(((Relation)value).getDisplayName(DefaultNameFormatter.getInstance()));
                }
                return c;
            }
        });
        this.membershipTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (c instanceof JLabel) {
                    Collection col = (Collection)value;
                    String text = null;
                    for (RelationMember r : col) {
                        if (text == null) {
                            text = r.getRole();
                            continue;
                        }
                        if (text.equals(r.getRole())) continue;
                        text = I18n.tr("<different>");
                        break;
                    }
                    ((JLabel)c).setText(text);
                }
                return c;
            }
        });
        JPanel bothTables = new JPanel();
        boolean top = Main.pref.getBoolean("properties.presets.top", true);
        bothTables.setLayout(new GridBagLayout());
        if (top) {
            bothTables.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        bothTables.add((Component)this.selectSth, GBC.eol().fill().insets(10, 10, 10, 10));
        bothTables.add((Component)this.propertyTable.getTableHeader(), GBC.eol().fill(2));
        bothTables.add((Component)this.propertyTable, GBC.eol().fill(1));
        bothTables.add((Component)this.membershipTable.getTableHeader(), GBC.eol().fill(2));
        bothTables.add((Component)this.membershipTable, GBC.eol().fill(1));
        if (!top) {
            bothTables.add((Component)this.presets, GBC.eol().fill(2).insets(5, 2, 5, 2));
        }
        DblClickWatch dblClickWatch = new DblClickWatch();
        this.propertyTable.addMouseListener(dblClickWatch);
        this.membershipTable.addMouseListener(dblClickWatch);
        JScrollPane scrollPane = new JScrollPane(bothTables);
        scrollPane.addMouseListener(dblClickWatch);
        this.add((Component)scrollPane, "Center");
        this.selectSth.setPreferredSize(scrollPane.getSize());
        this.presets.setSize(scrollPane.getSize());
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        ActionListener buttonAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = PropertiesDialog.this.membershipTable.getSelectedRow();
                if (e.getActionCommand().equals("Add")) {
                    PropertiesDialog.this.add();
                } else if (row >= 0) {
                    if (e.getActionCommand().equals("Edit")) {
                        PropertiesDialog.this.membershipEdit(row);
                    }
                } else {
                    int sel = PropertiesDialog.this.propertyTable.getSelectedRow();
                    if (e.getActionCommand().equals("Edit")) {
                        PropertiesDialog.this.propertyEdit(sel >= 0 ? sel : 0);
                    }
                }
            }
        };
        Shortcut s = Shortcut.registerShortcut("properties:add", I18n.tr("Add Properties"), 66, 6);
        this.btnAdd = new SideButton(I18n.marktr("Add"), "add", "Properties", I18n.tr("Add a new key/value pair to all objects"), s, buttonAction);
        buttonPanel.add(this.btnAdd);
        s = Shortcut.registerShortcut("properties:edit", I18n.tr("Edit Properties"), 73, 6);
        this.btnEdit = new SideButton(I18n.marktr("Edit"), "edit", "Properties", I18n.tr("Edit the value of the selected key for all objects"), s, buttonAction);
        buttonPanel.add(this.btnEdit);
        DeleteAction deleteAction = new DeleteAction();
        this.btnDel = new SideButton(deleteAction);
        this.membershipTable.getSelectionModel().addListSelectionListener(deleteAction);
        this.propertyTable.getSelectionModel().addListSelectionListener(deleteAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", deleteAction);
        buttonPanel.add(this.btnDel);
        this.add((Component)buttonPanel, "South");
        DataSet.selListeners.add(this);
        Layer.listeners.add(this);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && Main.main.getCurrentDataSet() != null) {
            this.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    private void checkPresets(int nodes, int ways, int relations, int closedways) {
        this.presets.removeAll();
        int total = nodes + ways + relations + closedways;
        if (total == 0) {
            this.presets.setVisible(false);
            return;
        }
        for (TaggingPreset t : TaggingPresetPreference.taggingPresets) {
            if (t.types != null && relations > 0 && !t.types.contains("relation") && nodes > 0 && !t.types.contains("node") && ways + closedways > 0 && !t.types.contains("way") && closedways > 0 && !t.types.contains("closedway") || !t.isShowable()) continue;
            int found = 0;
            for (TaggingPreset.Item i : t.data) {
                Map<String, Integer> v;
                if (!(i instanceof TaggingPreset.Key)) continue;
                String val = ((TaggingPreset.Key)i).value;
                String key = ((TaggingPreset.Key)i).key;
                found -= 100;
                if (!this.valueCount.containsKey(key) || (v = this.valueCount.get(key)).size() != 1 || !v.containsKey(val) || v.get(val) != total) continue;
                found += 101;
            }
            if (found <= 0) continue;
            JLabel lbl = new JLabel(t.getName());
            class PresetLabelML
            implements MouseListener {
                JLabel label;
                Font bold;
                Font normal;
                TaggingPreset tag;

                PresetLabelML(JLabel lbl, TaggingPreset t) {
                    this.label = lbl;
                    lbl.setCursor(new Cursor(12));
                    this.normal = this.label.getFont();
                    this.bold = this.normal.deriveFont(this.normal.getStyle() ^ 1);
                    this.tag = t;
                }

                public void mouseClicked(MouseEvent arg0) {
                    this.tag.actionPerformed(null);
                }

                public void mouseEntered(MouseEvent arg0) {
                    this.label.setFont(this.bold);
                }

                public void mouseExited(MouseEvent arg0) {
                    this.label.setFont(this.normal);
                }

                public void mousePressed(MouseEvent arg0) {
                }

                public void mouseReleased(MouseEvent arg0) {
                }
            }
            lbl.addMouseListener(new PresetLabelML(lbl, t));
            this.presets.add((Component)lbl, GBC.eol().fill(2));
        }
        if (this.presets.getComponentCount() > 0) {
            this.presets.setVisible(true);
            int height = this.presets.getComponentCount() * this.presets.getComponent(0).getHeight();
            Dimension size = new Dimension(this.presets.getWidth(), height);
            this.presets.setMaximumSize(size);
            this.presets.setMinimumSize(size);
        } else {
            this.presets.setVisible(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> newSelection) {
        if (!this.isVisible()) {
            return;
        }
        if (this.propertyTable == null) {
            return;
        }
        if (this.propertyTable.getCellEditor() != null) {
            this.propertyTable.getCellEditor().cancelCellEditing();
        }
        this.propertyData.setRowCount(0);
        int nodes = 0;
        int ways = 0;
        int relations = 0;
        int closedways = 0;
        HashMap<String, Integer> keyCount = new HashMap<String, Integer>();
        this.valueCount.clear();
        for (OsmPrimitive osmPrimitive : newSelection) {
            if (osmPrimitive instanceof Node) {
                ++nodes;
            } else if (osmPrimitive instanceof Relation) {
                ++relations;
            } else if (((Way)osmPrimitive).isClosed()) {
                ++closedways;
            } else {
                ++ways;
            }
            for (Map.Entry<String, String> e : osmPrimitive.entrySet()) {
                Map<Object, Object> v;
                keyCount.put(e.getKey(), keyCount.containsKey(e.getKey()) ? (Integer)keyCount.get(e.getKey()) + 1 : 1);
                if (this.valueCount.containsKey(e.getKey())) {
                    v = this.valueCount.get(e.getKey());
                    v.put(e.getValue(), v.containsKey(e.getValue()) ? (Integer)v.get(e.getValue()) + 1 : 1);
                    continue;
                }
                v = new TreeMap<String, Integer>();
                ((TreeMap)v).put(e.getValue(), 1);
                this.valueCount.put(e.getKey(), v);
            }
        }
        for (Map.Entry entry : this.valueCount.entrySet()) {
            void var9_17;
            boolean bl = false;
            for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                var9_17 += ((Integer)e1.getValue()).intValue();
            }
            if (var9_17 < newSelection.size()) {
                ((Map)entry.getValue()).put("", newSelection.size() - var9_17);
            }
            this.propertyData.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        this.membershipData.setRowCount(0);
        HashMap<Relation, HashSet<RelationMember>> roles = new HashMap<Relation, HashSet<RelationMember>>();
        if (Main.main.getCurrentDataSet() != null) {
            for (Relation relation : Main.main.getCurrentDataSet().relations) {
                if (relation.isFiltered() || relation.incomplete || relation.isDeleted()) continue;
                for (RelationMember m : relation.getMembers()) {
                    if (!newSelection.contains(m.getMember())) continue;
                    HashSet<RelationMember> value = (HashSet<RelationMember>)roles.get(relation);
                    if (value == null) {
                        value = new HashSet<RelationMember>();
                        roles.put(relation, value);
                    }
                    value.add(m);
                }
            }
        }
        for (Map.Entry entry : roles.entrySet()) {
            this.membershipData.addRow(new Object[]{entry.getKey(), entry.getValue()});
        }
        this.checkPresets(nodes, ways, relations, closedways);
        this.membershipTable.getTableHeader().setVisible(this.membershipData.getRowCount() > 0);
        this.membershipTable.setVisible(this.membershipData.getRowCount() > 0);
        boolean bl = !newSelection.isEmpty();
        boolean bl2 = bl && this.propertyData.getRowCount() > 0;
        boolean hasMemberships = bl && this.membershipData.getRowCount() > 0;
        this.btnAdd.setEnabled(bl);
        this.btnEdit.setEnabled(bl2 || hasMemberships);
        this.btnDel.setEnabled(bl2 || hasMemberships);
        this.propertyTable.setVisible(bl);
        this.propertyTable.getTableHeader().setVisible(bl);
        this.selectSth.setVisible(!bl);
        if (bl2) {
            this.propertyTable.changeSelection(0, 0, false, false);
        } else if (hasMemberships) {
            this.membershipTable.changeSelection(0, 0, false, false);
        }
        if (this.propertyData.getRowCount() != 0 || this.membershipData.getRowCount() != 0) {
            this.setTitle(I18n.tr("Properties: {0} / Memberships: {1}", this.propertyData.getRowCount(), this.membershipData.getRowCount()));
        } else {
            this.setTitle(I18n.tr("Properties / Memberships"));
        }
    }

    @Override
    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        if (newLayer instanceof OsmDataLayer) {
            OsmDataLayer dataLayer = (OsmDataLayer)newLayer;
            this.selectionChanged(dataLayer.data.getSelected());
        } else {
            List selection = Collections.emptyList();
            this.selectionChanged(selection);
        }
    }

    @Override
    public void layerAdded(Layer newLayer) {
    }

    @Override
    public void layerRemoved(Layer oldLayer) {
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        protected void deleteProperty(int row) {
            String key = PropertiesDialog.this.propertyData.getValueAt(row, 0).toString();
            Collection<OsmPrimitive> sel = Main.main.getCurrentDataSet().getSelected();
            Main.main.undoRedo.add(new ChangePropertyCommand(sel, key, null));
            DataSet.fireSelectionChanged(sel);
            PropertiesDialog.this.selectionChanged(sel);
            int rowCount = PropertiesDialog.this.propertyTable.getRowCount();
            PropertiesDialog.this.propertyTable.changeSelection(row < rowCount ? row : rowCount - 1, 0, false, false);
        }

        protected void deleteFromRelation(int row) {
            Relation cur = (Relation)PropertiesDialog.this.membershipData.getValueAt(row, 0);
            ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Change relation"), new String[]{I18n.tr("Delete from relation"), I18n.tr("Cancel")});
            ed.setButtonIcons(new String[]{"dialogs/delete.png", "cancel.png"});
            ed.setContent(I18n.tr("Really delete selection from relation {0}?", cur.getDisplayName(DefaultNameFormatter.getInstance())));
            ed.showDialog();
            if (ed.getValue() != 1) {
                return;
            }
            Relation rel = new Relation(cur);
            Collection<OsmPrimitive> sel = Main.main.getCurrentDataSet().getSelected();
            for (OsmPrimitive primitive : sel) {
                rel.removeMembersFor(primitive);
            }
            Main.main.undoRedo.add(new ChangeCommand(cur, rel));
            DataSet.fireSelectionChanged(sel);
            PropertiesDialog.this.selectionChanged(sel);
        }

        public DeleteAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selected key in all objects"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            Shortcut s = Shortcut.registerShortcut("properties:delete", I18n.tr("Delete Properties"), 81, 6);
            this.putValue("MnemonicKey", KeyEvent.getKeyText(s.getAssignedKey()).charAt(0));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (PropertiesDialog.this.propertyTable.getSelectedRowCount() > 0) {
                int row = PropertiesDialog.this.propertyTable.getSelectedRow();
                this.deleteProperty(row);
            } else if (PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0) {
                int row = PropertiesDialog.this.membershipTable.getSelectedRow();
                this.deleteFromRelation(row);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(PropertiesDialog.this.propertyTable.getSelectedRowCount() > 0 || PropertiesDialog.this.membershipTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    public class DblClickWatch
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                if (e.getSource() == PropertiesDialog.this.propertyTable) {
                    PropertiesDialog.this.membershipTable.clearSelection();
                } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                    PropertiesDialog.this.propertyTable.clearSelection();
                }
            } else if (e.getSource() == PropertiesDialog.this.propertyTable) {
                int row = PropertiesDialog.this.propertyTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    PropertiesDialog.this.propertyEdit(row);
                }
            } else if (e.getSource() == PropertiesDialog.this.membershipTable) {
                int row = PropertiesDialog.this.membershipTable.rowAtPoint(e.getPoint());
                if (row > -1) {
                    PropertiesDialog.this.membershipEdit(row);
                }
            } else {
                PropertiesDialog.this.add();
            }
        }
    }
}

