/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.DataChangeListener;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationListDialog
extends ToggleDialog
implements Layer.LayerChangeListener,
DataChangeListener {
    private static final Logger logger = Logger.getLogger(RelationListDialog.class.getName());
    private JList displaylist;
    private RelationListModel model = new RelationListModel();
    private EditAction editAction;
    private DeleteAction deleteAction;

    public RelationListDialog() {
        super(I18n.tr("Relations"), "relationlist", I18n.tr("Open a list of all relations."), Shortcut.registerShortcut("subwindow:relations", I18n.tr("Toggle: {0}", I18n.tr("Relations")), 82, 4), 150);
        this.displaylist = new JList(this.model);
        this.displaylist.setCellRenderer(new OsmPrimitivRenderer());
        this.displaylist.setSelectionMode(2);
        this.displaylist.addMouseListener(new DoubleClickAdapter());
        this.add((Component)new JScrollPane(this.displaylist), "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        NewAction newAction = new NewAction();
        Layer.listeners.add(newAction);
        buttonPanel.add((Component)new SideButton(newAction), GBC.std());
        this.editAction = new EditAction();
        this.displaylist.addListSelectionListener(this.editAction);
        buttonPanel.add((Component)new SideButton(this.editAction), GBC.std());
        DuplicateAction duplicateAction = new DuplicateAction();
        this.displaylist.addListSelectionListener(duplicateAction);
        buttonPanel.add((Component)new SideButton(duplicateAction), GBC.std());
        this.deleteAction = new DeleteAction();
        this.displaylist.addListSelectionListener(this.deleteAction);
        buttonPanel.add((Component)new SideButton(this.deleteAction), GBC.eol());
        SelectAction selectAction = new SelectAction();
        this.displaylist.addListSelectionListener(selectAction);
        buttonPanel.add((Component)new SideButton(selectAction), GBC.eol());
        this.add((Component)buttonPanel, "South");
        this.displaylist.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "deleteRelation");
        this.displaylist.getActionMap().put("deleteRelation", this.deleteAction);
        Layer.listeners.add(this);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.updateList();
        }
    }

    protected int getNumRelations() {
        if (Main.main.getCurrentDataSet() == null) {
            return 0;
        }
        return Main.main.getCurrentDataSet().relations.size();
    }

    protected ArrayList<Relation> getDisplayedRelationsInSortOrder(DataSet ds) {
        ArrayList<Relation> relations = new ArrayList<Relation>(ds.relations.size());
        for (Relation r : ds.relations) {
            if (!r.isUsable() || !r.isVisible()) continue;
            relations.add(r);
        }
        Collections.sort(relations, new Comparator<Relation>(){
            NameFormatter formatter = DefaultNameFormatter.getInstance();

            @Override
            public int compare(Relation r1, Relation r2) {
                return r1.getDisplayName(this.formatter).compareTo(r2.getDisplayName(this.formatter));
            }
        });
        return relations;
    }

    public void updateList() {
        if (Main.main.getCurrentDataSet() == null) {
            this.model.setRelations(null);
            return;
        }
        Relation selected = this.getSelected();
        this.model.setRelations(this.getDisplayedRelationsInSortOrder(Main.main.getCurrentDataSet()));
        if (this.model.getSize() > 0) {
            this.setTitle(I18n.tr("Relations: {0}", this.model.getSize()));
        } else {
            this.setTitle(I18n.tr("Relations"));
        }
        this.selectRelation(selected);
    }

    @Override
    public void activeLayerChange(Layer a, Layer b) {
        this.updateList();
    }

    @Override
    public void layerRemoved(Layer a) {
        if (a instanceof OsmDataLayer) {
            ((OsmDataLayer)a).listenerDataChanged.remove(this);
        }
        this.updateList();
    }

    @Override
    public void layerAdded(Layer a) {
        if (a instanceof OsmDataLayer) {
            ((OsmDataLayer)a).listenerDataChanged.add(this);
        }
    }

    @Override
    public void dataChanged(OsmDataLayer l) {
        this.updateList();
    }

    public Relation getCurrentRelation() {
        return (Relation)this.displaylist.getSelectedValue();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.displaylist.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.displaylist.removeListSelectionListener(listener);
    }

    private Relation getSelected() {
        if (this.model.getSize() == 1) {
            this.displaylist.setSelectedIndex(0);
        }
        return (Relation)this.displaylist.getSelectedValue();
    }

    public void selectRelation(Relation relation) {
        if (relation == null) {
            this.displaylist.clearSelection();
            return;
        }
        int idx = this.model.getIndexOfRelation(relation);
        if (idx == -1) {
            this.displaylist.clearSelection();
        } else {
            this.displaylist.setSelectedIndex(idx);
            this.displaylist.scrollRectToVisible(this.displaylist.getCellBounds(idx, idx));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelationListModel
    extends AbstractListModel {
        private ArrayList<Relation> relations;

        private RelationListModel() {
        }

        public ArrayList<Relation> getRelations() {
            return this.relations;
        }

        public Relation getRelation(int idx) {
            return this.relations.get(idx);
        }

        public void setRelations(ArrayList<Relation> relations) {
            this.relations = relations;
            this.fireIntervalAdded(this, 0, this.getSize());
        }

        @Override
        public Object getElementAt(int index) {
            if (this.relations == null) {
                return null;
            }
            return this.relations.get(index);
        }

        @Override
        public int getSize() {
            if (this.relations == null) {
                return 0;
            }
            return this.relations.size();
        }

        public int getIndexOfRelation(Relation relation) {
            if (relation == null) {
                return -1;
            }
            return this.relations.indexOf(relation);
        }
    }

    class SelectAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectAction() {
            this.putValue("ShortDescription", I18n.tr("Set the current selection to the list of selected relations"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            int[] idx = RelationListDialog.this.displaylist.getSelectedIndices();
            if (idx == null || idx.length == 0) {
                return;
            }
            ArrayList<Relation> selection = new ArrayList<Relation>(idx.length);
            for (int i : idx) {
                selection.add(RelationListDialog.this.model.getRelation(i));
            }
            Main.map.mapView.getEditLayer().data.setSelected(selection);
            DataSet.fireSelectionChanged(selection);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }
    }

    class DuplicateAction
    extends AbstractAction
    implements ListSelectionListener {
        public DuplicateAction() {
            this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window"));
            this.putValue("SmallIcon", ImageProvider.get("duplicate"));
            this.updateEnabledState();
        }

        public void launchEditorForDuplicate(Relation original) {
            Relation copy = new Relation(original.getId());
            copy.cloneFrom(original);
            copy.clearOsmId();
            copy.setModified(true);
            RelationEditor editor = RelationEditor.getEditor(Main.main.getEditLayer(), copy, null);
            editor.setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.launchEditorForDuplicate(RelationListDialog.this.getSelected());
        }

        protected void updateEnabledState() {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length == 1);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class NewAction
    extends AbstractAction
    implements Layer.LayerChangeListener {
        public NewAction() {
            this.putValue("ShortDescription", I18n.tr("Create a new relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "addrelation"));
            this.setEnabled(false);
        }

        public void run() {
            RelationEditor.getEditor(Main.map.mapView.getEditLayer(), null, null).setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        protected void updateEnabledState() {
            this.setEnabled(Main.main != null && Main.main.getEditLayer() != null);
        }

        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer newLayer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer oldLayer) {
            this.updateEnabledState();
        }
    }

    class DeleteAction
    extends AbstractAction
    implements ListSelectionListener {
        public DeleteAction() {
            this.putValue("ShortDescription", I18n.tr("Delete the selected relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.setEnabled(false);
        }

        protected void deleteRelation(Relation toDelete) {
            if (toDelete == null) {
                return;
            }
            org.openstreetmap.josm.actions.mapmode.DeleteAction.deleteRelation(Main.main.getEditLayer(), toDelete);
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            int[] idx = RelationListDialog.this.displaylist.getSelectedIndices();
            ArrayList<Relation> toDelete = new ArrayList<Relation>(idx.length);
            for (int i : idx) {
                toDelete.add(RelationListDialog.this.model.getRelation(i));
            }
            for (Relation r : toDelete) {
                this.deleteRelation(r);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length > 0);
        }

        class AbortException
        extends Exception {
            AbortException() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Open an editor for the selected relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.setEnabled(false);
        }

        protected Collection<RelationMember> getMembersForCurrentSelection(Relation r) {
            HashSet<RelationMember> members = new HashSet<RelationMember>();
            Collection<OsmPrimitive> selection = Main.map.mapView.getEditLayer().data.getSelected();
            for (RelationMember member : r.getMembers()) {
                if (!selection.contains(member.getMember())) continue;
                members.add(member);
            }
            return members;
        }

        public void launchEditor(Relation toEdit) {
            if (toEdit == null) {
                return;
            }
            RelationEditor.getEditor(Main.map.mapView.getEditLayer(), toEdit, this.getMembersForCurrentSelection(toEdit)).setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.launchEditor(RelationListDialog.this.getSelected());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(RelationListDialog.this.displaylist.getSelectedIndices() != null && RelationListDialog.this.displaylist.getSelectedIndices().length == 1);
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        protected void setCurrentRelationAsSelection() {
            Main.main.getCurrentDataSet().setSelected((Relation)RelationListDialog.this.displaylist.getSelectedValue());
        }

        protected void editCurrentRelation() {
            new EditAction().launchEditor(RelationListDialog.this.getSelected());
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                if (e.isControlDown()) {
                    this.editCurrentRelation();
                } else {
                    this.setCurrentRelationAsSelection();
                }
            }
        }
    }
}

