/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ConflictAddCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.visitor.MergeVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.relation.ChildRelationBrowser;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowser;
import org.openstreetmap.josm.gui.dialogs.relation.ReferringRelationsBrowserModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.SelectionTableModel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.tagging.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.TagEditorPanel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionCache;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRelationEditor
extends RelationEditor {
    private static final Logger logger = Logger.getLogger(GenericRelationEditor.class.getName());
    private TagEditorPanel tagEditorPanel;
    private ReferringRelationsBrowser referrerBrowser;
    private ReferringRelationsBrowserModel referrerModel;
    private MemberTable memberTable;
    private MemberTableModel memberTableModel;
    private SelectionTableModel selectionTableModel;
    private AutoCompletingTextField tfRole;

    public GenericRelationEditor(OsmDataLayer layer, Relation relation, Collection<RelationMember> selectedMembers) {
        super(layer, relation, selectedMembers);
        AutoCompletionCache.getCacheForLayer(this.getLayer()).initFromDataSet();
        this.memberTableModel = new MemberTableModel(this.getLayer());
        this.selectionTableModel = new SelectionTableModel(this.getLayer());
        this.referrerModel = new ReferringRelationsBrowserModel(relation);
        this.tagEditorPanel = new TagEditorPanel();
        if (relation != null) {
            this.tagEditorPanel.getModel().initFromPrimitive(relation);
            this.memberTableModel.populate(relation);
            if (!this.getLayer().data.relations.contains(relation)) {
                this.setRelation(null);
            }
        } else {
            this.tagEditorPanel.getModel().clear();
            this.memberTableModel.populate(null);
        }
        this.tagEditorPanel.getModel().ensureOneTag();
        JSplitPane pane = this.buildSplitPane();
        pane.setPreferredSize(new Dimension(100, 100));
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        pnl.add((Component)pane, "Center");
        pnl.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(I18n.tr("Tags and Members"), pnl);
        this.referrerBrowser = new ReferringRelationsBrowser(this.getLayer(), this.referrerModel, this);
        tabbedPane.add(I18n.tr("Parent Relations"), this.referrerBrowser);
        tabbedPane.add(I18n.tr("Child Relations"), new ChildRelationBrowser(this.getLayer(), relation));
        tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int index;
                JTabbedPane sourceTabbedPane = (JTabbedPane)e.getSource();
                String title = sourceTabbedPane.getTitleAt(index = sourceTabbedPane.getSelectedIndex());
                if (title.equals(I18n.tr("Parent Relations"))) {
                    GenericRelationEditor.this.referrerBrowser.init();
                }
            }
        });
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.getContentPane().add((Component)this.buildOkCancelButtonPanel(), "South");
        this.setSize(this.findMaxDialogSize());
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                GenericRelationEditor.this.cleanSelfReferences();
            }
        });
        this.memberTableModel.setSelectedMembers(selectedMembers);
    }

    protected JPanel buildOkCancelButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        pnl.add(new SideButton(new OKAction()));
        pnl.add(new SideButton(new CancelAction()));
        return pnl;
    }

    protected JPanel buildTagEditorPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.fill = 2;
        gc.anchor = 23;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Tags")), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        pnl.add((Component)this.tagEditorPanel, gc);
        return pnl;
    }

    protected JPanel buildMemberEditorPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        this.memberTable = new MemberTable(this.getLayer(), this.memberTableModel);
        this.memberTable.addMouseListener(new MemberTableDblClickAdapter());
        this.memberTableModel.addMemberModelListener(this.memberTable);
        JScrollPane scrollPane = new JScrollPane(this.memberTable);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.gridwidth = 3;
        gc.fill = 2;
        gc.anchor = 23;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        pnl.add((Component)new JLabel(I18n.tr("Members")), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.fill = 3;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        pnl.add((Component)this.buildLeftButtonPanel(), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.fill = 1;
        gc.anchor = 10;
        gc.weightx = 0.6;
        gc.weighty = 1.0;
        pnl.add((Component)scrollPane, gc);
        JPanel pnl2 = new JPanel();
        pnl2.setLayout(new GridBagLayout());
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.gridwidth = 3;
        gc.fill = 2;
        gc.anchor = 23;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        pnl2.add((Component)new JLabel(I18n.tr("Selection")), gc);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.fill = 3;
        gc.anchor = 18;
        gc.weightx = 0.0;
        gc.weighty = 1.0;
        pnl2.add((Component)this.buildSelectionControlButtonPanel(), gc);
        gc.gridx = 1;
        gc.gridy = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl2.add((Component)this.buildSelectionTablePanel(), gc);
        final JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(pnl);
        splitPane.setRightComponent(pnl2);
        splitPane.setOneTouchExpandable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                splitPane.setDividerLocation(0.6);
            }
        });
        JPanel pnl3 = new JPanel();
        pnl3.setLayout(new BorderLayout());
        pnl3.add((Component)splitPane, "Center");
        pnl3.add((Component)this.buildButtonPanel(), "South");
        return pnl3;
    }

    protected JPanel buildSelectionTablePanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new BorderLayout());
        JTable tbl = new JTable(this.selectionTableModel, new SelectionTableColumnModel(this.memberTableModel));
        tbl.setEnabled(false);
        JScrollPane pane = new JScrollPane(tbl);
        pnl.add((Component)pane, "Center");
        return pnl;
    }

    protected JSplitPane buildSplitPane() {
        final JSplitPane pane = new JSplitPane(0);
        pane.setTopComponent(this.buildTagEditorPanel());
        pane.setBottomComponent(this.buildMemberEditorPanel());
        pane.setOneTouchExpandable(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                pane.setDividerLocation(0.3);
            }
        });
        return pane;
    }

    protected JPanel buildLeftButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.fill = 2;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridy = 0;
        MoveUpAction moveUpAction = new MoveUpAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(moveUpAction);
        pnl.add((Component)new JButton(moveUpAction), gc);
        gc.gridy = 1;
        MoveDownAction moveDownAction = new MoveDownAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(moveDownAction);
        pnl.add((Component)new JButton(moveDownAction), gc);
        gc.gridy = 2;
        EditAction editAction = new EditAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(editAction);
        pnl.add((Component)new JButton(editAction), gc);
        gc.gridy = 3;
        RemoveAction removeSelectedAction = new RemoveAction();
        this.memberTable.getSelectionModel().addListSelectionListener(removeSelectedAction);
        pnl.add((Component)new JButton(removeSelectedAction), gc);
        gc.gridy = 4;
        SelectPrimitivesForSelectedMembersAction selectAction = new SelectPrimitivesForSelectedMembersAction();
        this.memberTable.getSelectionModel().addListSelectionListener(selectAction);
        pnl.add((Component)new JButton(selectAction), gc);
        gc.gridy = 5;
        SortAction sortAction = new SortAction();
        pnl.add((Component)new JButton(sortAction), gc);
        gc.gridy = 6;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected JPanel buildSelectionControlButtonPanel() {
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 1;
        gc.gridwidth = 1;
        gc.insets = new Insets(0, 5, 0, 5);
        gc.fill = 2;
        gc.anchor = 10;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        AddSelectedAtEndAction addSelectedAtEndAction = new AddSelectedAtEndAction();
        this.selectionTableModel.addTableModelListener(addSelectedAtEndAction);
        pnl.add((Component)new JButton(addSelectedAtEndAction), gc);
        gc.gridy = 1;
        SelectedMembersForSelectionAction selectMembersForSelectionAction = new SelectedMembersForSelectionAction();
        this.selectionTableModel.addTableModelListener(selectMembersForSelectionAction);
        this.memberTableModel.addTableModelListener(selectMembersForSelectionAction);
        pnl.add((Component)new JButton(selectMembersForSelectionAction), gc);
        gc.gridy = 2;
        RemoveSelectedAction removeSelectedAction = new RemoveSelectedAction();
        this.selectionTableModel.addTableModelListener(removeSelectedAction);
        pnl.add((Component)new JButton(removeSelectedAction), gc);
        gc.gridy = 3;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl.add((Component)new JPanel(), gc);
        gc.gridy = 4;
        gc.weighty = 0.0;
        AddSelectedAtStartAction addSelectionAction = new AddSelectedAtStartAction();
        this.selectionTableModel.addTableModelListener(addSelectionAction);
        pnl.add((Component)new JButton(addSelectionAction), gc);
        gc.gridy = 5;
        AddSelectedBeforeSelection addSelectedBeforeSelectionAction = new AddSelectedBeforeSelection();
        this.selectionTableModel.addTableModelListener(addSelectedBeforeSelectionAction);
        this.memberTableModel.getSelectionModel().addListSelectionListener(addSelectedBeforeSelectionAction);
        pnl.add((Component)new JButton(addSelectedBeforeSelectionAction), gc);
        gc.gridy = 6;
        AddSelectedAfterSelection addSelectedAfterSelectionAction = new AddSelectedAfterSelection();
        this.selectionTableModel.addTableModelListener(addSelectedAfterSelectionAction);
        this.memberTableModel.getSelectionModel().addListSelectionListener(addSelectedAfterSelectionAction);
        pnl.add((Component)new JButton(addSelectedAfterSelectionAction), gc);
        return pnl;
    }

    protected JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(new SideButton(new DownlaodAction()));
        buttonPanel.add(new JLabel(I18n.tr("Role:")));
        this.tfRole = new AutoCompletingTextField(10);
        this.tfRole.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                GenericRelationEditor.this.tfRole.selectAll();
            }
        });
        this.tfRole.setAutoCompletionList(new AutoCompletionList());
        this.tfRole.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                AutoCompletionList list = GenericRelationEditor.this.tfRole.getAutoCompletionList();
                AutoCompletionCache.getCacheForLayer(Main.main.getEditLayer()).populateWithMemberRoles(list);
            }
        });
        buttonPanel.add(this.tfRole);
        SetRoleAction setRoleAction = new SetRoleAction();
        this.memberTableModel.getSelectionModel().addListSelectionListener(setRoleAction);
        buttonPanel.add(new SideButton(setRoleAction));
        this.tfRole.getDocument().addDocumentListener(setRoleAction);
        this.tfRole.addActionListener(setRoleAction);
        buttonPanel.add(new SideButton(new DuplicateRelationAction()));
        buttonPanel.add(new SideButton(new ApplyAction()));
        buttonPanel.add(new SideButton(new DeleteCurrentRelationAction()));
        return buttonPanel;
    }

    @Override
    protected Dimension findMaxDialogSize() {
        return new Dimension(700, 500);
    }

    @Override
    public void dispose() {
        this.selectionTableModel.unregister();
        DataSet.selListeners.remove(this.memberTableModel);
        super.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.tagEditorPanel.initAutoCompletion(Main.main.getEditLayer());
        }
        super.setVisible(visible);
        if (!visible) {
            this.dispose();
        }
    }

    protected void cleanSelfReferences() {
        ArrayList<OsmPrimitive> toCheck = new ArrayList<OsmPrimitive>();
        toCheck.add(this.getRelation());
        if (this.memberTableModel.hasMembersReferringTo(toCheck)) {
            int ret = ConditionalOptionPaneUtil.showOptionDialog("clean_relation_self_references", Main.parent, I18n.tr("<html>There is at least one member in this relation referring<br>to the relation itself.<br>This creates circular dependencies and is discouraged.<br>How do you want to proceed with circular dependencies?</html>"), I18n.tr("Warning"), 0, 2, new String[]{I18n.tr("Remove them, clean up relation"), I18n.tr("Ignore them, leave relation as is")}, I18n.tr("Remove them, clean up relation"));
            switch (ret) {
                case -2147483648: {
                    return;
                }
                case -1: {
                    return;
                }
                case 1: {
                    return;
                }
                case 0: {
                    this.memberTableModel.removeMembersReferringTo(toCheck);
                }
            }
        }
    }

    class DownloadTask
    extends PleaseWaitRunnable {
        private boolean cancelled;
        private int conflictsCount;
        private Exception lastException;

        public DownloadTask(Dialog parent) {
            super(I18n.tr("Download relation members"), new PleaseWaitProgressMonitor(parent), false);
        }

        protected void cancel() {
            this.cancelled = true;
            OsmApi.getOsmApi().cancel();
        }

        protected void finish() {
            if (this.cancelled) {
                return;
            }
            GenericRelationEditor.this.memberTableModel.updateMemberReferences(GenericRelationEditor.this.getLayer().data);
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
            }
            if (this.conflictsCount > 0) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("There were {0} conflicts during import.", this.conflictsCount), I18n.tr("Warning"), 2);
            }
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.progressMonitor.indeterminateSubTask("");
                OsmServerObjectReader reader = new OsmServerObjectReader(GenericRelationEditor.this.getRelation().getId(), OsmPrimitiveType.RELATION, true);
                DataSet dataSet = reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
                if (dataSet != null) {
                    MergeVisitor visitor = new MergeVisitor(GenericRelationEditor.this.getLayer().data, dataSet);
                    visitor.merge();
                    for (DataSource src : dataSet.dataSources) {
                        GenericRelationEditor.this.getLayer().data.dataSources.add(src);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GenericRelationEditor.this.getLayer().fireDataChange();
                        }
                    });
                    if (!visitor.getConflicts().isEmpty()) {
                        GenericRelationEditor.this.getLayer().getConflicts().add(visitor.getConflicts());
                        this.conflictsCount = visitor.getConflicts().size();
                    }
                }
            }
            catch (Exception e) {
                if (this.cancelled) {
                    System.out.println(I18n.tr("Warning: ignoring exception because task is cancelled. Exception: {0}", e.toString()));
                    return;
                }
                this.lastException = e;
            }
        }
    }

    class MemberTableDblClickAdapter
    extends MouseAdapter {
        MemberTableDblClickAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                new EditAction().run();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EditAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditAction() {
            this.putValue("ShortDescription", I18n.tr("Edit the relation the currently selected relation member refers to"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() == 1 && GenericRelationEditor.this.memberTableModel.isEditableRelation(GenericRelationEditor.this.memberTable.getSelectedRow()));
        }

        protected Collection<RelationMember> getMembersForCurrentSelection(Relation r) {
            HashSet<RelationMember> members = new HashSet<RelationMember>();
            Collection<OsmPrimitive> selection = GenericRelationEditor.this.getLayer().data.getSelected();
            for (RelationMember member : r.getMembers()) {
                if (!selection.contains(member.getMember())) continue;
                members.add(member);
            }
            return members;
        }

        public void run() {
            int idx = GenericRelationEditor.this.memberTable.getSelectedRow();
            if (idx < 0) {
                return;
            }
            OsmPrimitive primitive = GenericRelationEditor.this.memberTableModel.getReferredPrimitive(idx);
            if (!(primitive instanceof Relation)) {
                return;
            }
            Relation r = (Relation)primitive;
            if (r.incomplete) {
                return;
            }
            RelationEditor editor = RelationEditor.getEditor(GenericRelationEditor.this.getLayer(), r, this.getMembersForCurrentSelection(r));
            editor.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.run();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.refreshEnabled();
        }
    }

    class DuplicateRelationAction
    extends AbstractAction {
        public DuplicateRelationAction() {
            this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window"));
            this.putValue("SmallIcon", ImageProvider.get("duplicate"));
            this.putValue("Name", I18n.tr("Duplicate"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            Relation copy = new Relation();
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(copy);
            GenericRelationEditor.this.memberTableModel.applyToRelation(copy);
            RelationEditor editor = RelationEditor.getEditor(GenericRelationEditor.this.getLayer(), copy, GenericRelationEditor.this.memberTableModel.getSelectedMembers());
            editor.setVisible(true);
        }
    }

    class SetRoleAction
    extends AbstractAction
    implements ListSelectionListener,
    DocumentListener {
        public SetRoleAction() {
            this.putValue("ShortDescription", I18n.tr("Sets a role for the selected members"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("Name", I18n.tr("Apply Role"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() > 0);
        }

        protected boolean isEmptyRole() {
            return GenericRelationEditor.this.tfRole.getText() == null || GenericRelationEditor.this.tfRole.getText().trim().equals("");
        }

        protected boolean confirmSettingEmptyRole(int onNumMembers) {
            String message = I18n.tr("<html>You are setting an empty role on {0} primitives.<br>This is equal to deleting the roles of these primitives.<br>Do you really want to apply the new role?</html>", onNumMembers);
            Object[] options = new String[]{I18n.tr("Yes, apply it"), I18n.tr("No, don't apply")};
            int ret = ConditionalOptionPaneUtil.showOptionDialog("relation_editor.confirm_applying_empty_role", Main.parent, message, I18n.tr("Confirm empty role"), 0, 2, options, options[0]);
            switch (ret) {
                case 0: {
                    return true;
                }
                case -2147483648: {
                    return true;
                }
            }
            return false;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isEmptyRole() && !this.confirmSettingEmptyRole(GenericRelationEditor.this.memberTable.getSelectedRowCount())) {
                return;
            }
            GenericRelationEditor.this.memberTableModel.updateRole(GenericRelationEditor.this.memberTable.getSelectedRows(), GenericRelationEditor.this.tfRole.getText());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.refreshEnabled();
        }

        public void changedUpdate(DocumentEvent e) {
            this.refreshEnabled();
        }

        public void insertUpdate(DocumentEvent e) {
            this.refreshEnabled();
        }

        public void removeUpdate(DocumentEvent e) {
            this.refreshEnabled();
        }
    }

    class DownlaodAction
    extends AbstractAction {
        public DownlaodAction() {
            this.putValue("ShortDescription", I18n.tr("Download all incomplete ways and nodes in relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "downloadincomplete"));
            this.putValue("Name", I18n.tr("Download Members"));
            Shortcut.registerShortcut("relationeditor:downloadincomplete", I18n.tr("Relation Editor: Download Members"), 75, 6);
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            Main.worker.submit(new DownloadTask(GenericRelationEditor.this));
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.getRelation() != null && !GenericRelationEditor.this.getRelation().isNew());
        }
    }

    class AddTagAction
    extends AbstractAction {
        public AddTagAction() {
            this.putValue("ShortDescription", I18n.tr("Add an empty tag"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            GenericRelationEditor.this.tagEditorPanel.getModel().appendNewTag();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel the updates and close the dialog"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("Name", I18n.tr("Cancel"));
            GenericRelationEditor.this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
            GenericRelationEditor.this.getRootPane().getActionMap().put("ESCAPE", this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            GenericRelationEditor.this.setVisible(false);
        }
    }

    class OKAction
    extends SavingAction {
        public OKAction() {
            this.putValue("ShortDescription", I18n.tr("Apply the updates and close the dialog"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("Name", I18n.tr("OK"));
            this.setEnabled(true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            if (GenericRelationEditor.this.getRelation() == null) {
                this.applyNewRelation();
            } else if (!GenericRelationEditor.this.memberTableModel.hasSameMembersAs(GenericRelationEditor.this.getRelationSnapshot()) || GenericRelationEditor.this.tagEditorPanel.getModel().isDirty()) {
                if (GenericRelationEditor.this.isDirtyRelation()) {
                    if (!this.confirmClosingBecauseOfDirtyState()) return;
                    if (GenericRelationEditor.this.getLayer().getConflicts().hasConflictForMy(GenericRelationEditor.this.getRelation())) {
                        this.warnDoubleConflict();
                        return;
                    }
                    this.applyExistingConflictingRelation();
                } else {
                    this.applyExistingNonConflictingRelation();
                }
            }
            GenericRelationEditor.this.setVisible(false);
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }

    class ApplyAction
    extends SavingAction {
        public ApplyAction() {
            this.putValue("ShortDescription", I18n.tr("Apply the current updates"));
            this.putValue("SmallIcon", ImageProvider.get("save"));
            this.putValue("Name", I18n.tr("Apply"));
            this.setEnabled(true);
        }

        public void run() {
            if (GenericRelationEditor.this.getRelation() == null) {
                this.applyNewRelation();
            } else if (!GenericRelationEditor.this.memberTableModel.hasSameMembersAs(GenericRelationEditor.this.getRelationSnapshot()) || GenericRelationEditor.this.tagEditorPanel.getModel().isDirty()) {
                if (GenericRelationEditor.this.isDirtyRelation()) {
                    if (this.confirmClosingBecauseOfDirtyState()) {
                        if (GenericRelationEditor.this.getLayer().getConflicts().hasConflictForMy(GenericRelationEditor.this.getRelation())) {
                            this.warnDoubleConflict();
                            return;
                        }
                        this.applyExistingConflictingRelation();
                        GenericRelationEditor.this.setVisible(false);
                    }
                } else {
                    this.applyExistingNonConflictingRelation();
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }
    }

    abstract class SavingAction
    extends AbstractAction {
        SavingAction() {
        }

        protected void applyNewRelation() {
            if (GenericRelationEditor.this.memberTableModel.getRowCount() == 0 && GenericRelationEditor.this.tagEditorPanel.getModel().getKeys().isEmpty()) {
                return;
            }
            Relation newRelation = new Relation();
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(newRelation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(newRelation);
            Main.main.undoRedo.add(new AddCommand(GenericRelationEditor.this.getLayer(), newRelation));
            DataSet.fireSelectionChanged(GenericRelationEditor.this.getLayer().data.getSelected());
            GenericRelationEditor.this.getLayer().fireDataChange();
            GenericRelationEditor.this.setRelation(newRelation);
            RelationDialogManager.getRelationDialogManager().updateContext(GenericRelationEditor.this.getLayer(), GenericRelationEditor.this.getRelation(), GenericRelationEditor.this);
        }

        protected void applyExistingConflictingRelation() {
            Relation editedRelation = new Relation(GenericRelationEditor.this.getRelation());
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(editedRelation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(editedRelation);
            Conflict<Relation> conflict = new Conflict<Relation>(GenericRelationEditor.this.getRelation(), editedRelation);
            Main.main.undoRedo.add(new ConflictAddCommand(GenericRelationEditor.this.getLayer(), conflict));
        }

        protected void applyExistingNonConflictingRelation() {
            Relation editedRelation = new Relation(GenericRelationEditor.this.getRelation());
            GenericRelationEditor.this.tagEditorPanel.getModel().applyToPrimitive(editedRelation);
            GenericRelationEditor.this.memberTableModel.applyToRelation(editedRelation);
            Main.main.undoRedo.add(new ChangeCommand(GenericRelationEditor.this.getRelation(), editedRelation));
            DataSet.fireSelectionChanged(GenericRelationEditor.this.getLayer().data.getSelected());
            GenericRelationEditor.this.getLayer().fireDataChange();
            GenericRelationEditor.this.setRelation(GenericRelationEditor.this.getRelation());
        }

        protected boolean confirmClosingBecauseOfDirtyState() {
            HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, create a conflict and close"), ImageProvider.get("ok"), I18n.tr("Click to create a conflict and close this relation editor"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, continue editing"), ImageProvider.get("cancel"), I18n.tr("Click to to return to the relation editor and to resume relation editing"), null)};
            int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>This relation has been changed outside of the editor.<br>You can't apply your changes and continue editing.<br><br>Do you want to create a conflict and close the editor?</html>"), I18n.tr("Conflict in data"), 2, null, options, options[0], "/Dialog/RelationEditor#RelationChangedOutsideOfEditor");
            return ret == 0;
        }

        protected void warnDoubleConflict() {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Layer ''{0}'' already has a conflict for primitive<br>''{1}''.<br>Please resolve this conflict first, then try again.</html>", GenericRelationEditor.this.getLayer().getName(), GenericRelationEditor.this.getRelation().getDisplayName(DefaultNameFormatter.getInstance())), I18n.tr("Double conflict"), 2);
        }
    }

    class DeleteCurrentRelationAction
    extends AbstractAction {
        public DeleteCurrentRelationAction() {
            this.putValue("ShortDescription", I18n.tr("Delete the currently edited relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("Name", I18n.tr("Delete"));
            this.updateEnabledState();
        }

        public void run() {
            Relation toDelete = GenericRelationEditor.this.getRelation();
            if (toDelete == null) {
                return;
            }
            DeleteAction.deleteRelation(GenericRelationEditor.this.getLayer(), toDelete);
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.getRelation() != null);
        }
    }

    class RemoveAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveAction() {
            this.putValue("ShortDescription", I18n.tr("Remove the currently selected members from this relation"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "remove"));
            Shortcut.registerShortcut("relationeditor:remove", I18n.tr("Relation Editor: Remove"), 74, 6);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GenericRelationEditor.this.memberTableModel.remove(GenericRelationEditor.this.memberTable.getSelectedRows());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.canRemove(GenericRelationEditor.this.memberTable.getSelectedRows()));
        }
    }

    class MoveDownAction
    extends AbstractAction
    implements ListSelectionListener {
        public MoveDownAction() {
            this.putValue("ShortDescription", I18n.tr("Move the currently selected members down"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "movedown"));
            Shortcut.registerShortcut("relationeditor:moveup", I18n.tr("Relation Editor: Move Down"), 74, 6);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GenericRelationEditor.this.memberTableModel.moveDown(GenericRelationEditor.this.memberTable.getSelectedRows());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.canMoveDown(GenericRelationEditor.this.memberTable.getSelectedRows()));
        }
    }

    class MoveUpAction
    extends AbstractAction
    implements ListSelectionListener {
        public MoveUpAction() {
            this.putValue("ShortDescription", I18n.tr("Move the currently selected members up"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "moveup"));
            Shortcut.registerShortcut("relationeditor:moveup", I18n.tr("Relation Editor: Move Up"), 78, 6);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            GenericRelationEditor.this.memberTableModel.moveUp(GenericRelationEditor.this.memberTable.getSelectedRows());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(GenericRelationEditor.this.memberTableModel.canMoveUp(GenericRelationEditor.this.memberTable.getSelectedRows()));
        }
    }

    class SortAction
    extends AbstractAction {
        public SortAction() {
            this.putValue("ShortDescription", I18n.tr("Sort the relation members"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "sort"));
            Shortcut.registerShortcut("relationeditor:sort", I18n.tr("Relation Editor: Sort"), 84, 6);
        }

        public void actionPerformed(ActionEvent e) {
            GenericRelationEditor.this.memberTableModel.sort();
        }
    }

    class SelectPrimitivesForSelectedMembersAction
    extends AbstractAction
    implements ListSelectionListener {
        public SelectPrimitivesForSelectedMembersAction() {
            this.putValue("ShortDescription", I18n.tr("Select primitives for selected relation members"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "selectprimitives"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(GenericRelationEditor.this.memberTable.getSelectedRowCount() > 0);
        }

        public void actionPerformed(ActionEvent e) {
            GenericRelationEditor.this.getLayer().data.setSelected(GenericRelationEditor.this.memberTableModel.getSelectedChildPrimitives());
            DataSet.fireSelectionChanged(GenericRelationEditor.this.getLayer().data.getSelected());
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class SelectedMembersForSelectionAction
    extends AbstractAction
    implements TableModelListener {
        public SelectedMembersForSelectionAction() {
            this.putValue("ShortDescription", I18n.tr("Select relation members which refer to primitives in the current selection"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "selectmembers"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            boolean enabled;
            boolean bl = enabled = GenericRelationEditor.this.selectionTableModel.getRowCount() > 0 && !GenericRelationEditor.this.memberTableModel.getChildPrimitives(GenericRelationEditor.this.getLayer().data.getSelected()).isEmpty();
            if (enabled) {
                this.putValue("ShortDescription", I18n.tr("Select relation members which refer to {0} primitives in the current selection", GenericRelationEditor.this.memberTableModel.getChildPrimitives(GenericRelationEditor.this.getLayer().data.getSelected()).size()));
            } else {
                this.putValue("ShortDescription", I18n.tr("Select relation members which refer to primitives in the current selection"));
            }
            this.setEnabled(enabled);
        }

        public void actionPerformed(ActionEvent e) {
            GenericRelationEditor.this.memberTableModel.selectMembersReferringTo(GenericRelationEditor.this.getLayer().data.getSelected());
        }

        public void tableChanged(TableModelEvent e) {
            this.updateEnabledState();
        }
    }

    class RemoveSelectedAction
    extends AbstractAction
    implements TableModelListener {
        public RemoveSelectedAction() {
            this.putValue("ShortDescription", I18n.tr("Remove all members referring to one of the selected primitives"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/relation", "deletemembers"));
            Shortcut.registerShortcut("relationeditor:removeselected", I18n.tr("Relation Editor: Remove Selected"), 83, 6);
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            DataSet ds = GenericRelationEditor.this.getLayer().data;
            if (ds == null || ds.getSelected().isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(GenericRelationEditor.this.memberTableModel.hasMembersReferringTo(ds.getSelected()));
        }

        public void actionPerformed(ActionEvent e) {
            GenericRelationEditor.this.memberTableModel.removeMembersReferringTo(GenericRelationEditor.this.selectionTableModel.getSelection());
        }

        public void tableChanged(TableModelEvent e) {
            this.updateEnabledState();
        }
    }

    class AddSelectedAfterSelection
    extends AddFromSelectionAction
    implements TableModelListener,
    ListSelectionListener {
        public AddSelectedAfterSelection() {
            this.putValue("ShortDescription", I18n.tr("Add all primitives selected in the current dataset after the last selected member"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copyaftercurrentright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0 && GenericRelationEditor.this.memberTableModel.getSelectionModel().getMinSelectionIndex() >= 0);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                List<OsmPrimitive> toAdd = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                GenericRelationEditor.this.memberTableModel.addMembersAfterIdx(toAdd, GenericRelationEditor.this.memberTableModel.getSelectionModel().getMaxSelectionIndex());
            }
            catch (AddAbortException addAbortException) {
                // empty catch block
            }
        }

        public void tableChanged(TableModelEvent e) {
            this.refreshEnabled();
        }

        public void valueChanged(ListSelectionEvent e) {
            this.refreshEnabled();
        }
    }

    class AddSelectedBeforeSelection
    extends AddFromSelectionAction
    implements TableModelListener,
    ListSelectionListener {
        public AddSelectedBeforeSelection() {
            this.putValue("ShortDescription", I18n.tr("Add all primitives selected in the current dataset before the first selected member"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copybeforecurrentright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0 && GenericRelationEditor.this.memberTableModel.getSelectionModel().getMinSelectionIndex() >= 0);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                List<OsmPrimitive> toAdd = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                GenericRelationEditor.this.memberTableModel.addMembersBeforeIdx(toAdd, GenericRelationEditor.this.memberTableModel.getSelectionModel().getMinSelectionIndex());
            }
            catch (AddAbortException addAbortException) {
                // empty catch block
            }
        }

        public void tableChanged(TableModelEvent e) {
            this.refreshEnabled();
        }

        public void valueChanged(ListSelectionEvent e) {
            this.refreshEnabled();
        }
    }

    class AddSelectedAtEndAction
    extends AddFromSelectionAction
    implements TableModelListener {
        public AddSelectedAtEndAction() {
            this.putValue("ShortDescription", I18n.tr("Add all primitives selected in the current dataset after the last member"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copyendright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                List<OsmPrimitive> toAdd = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                GenericRelationEditor.this.memberTableModel.addMembersAtEnd(toAdd);
            }
            catch (AddAbortException addAbortException) {
                // empty catch block
            }
        }

        public void tableChanged(TableModelEvent e) {
            this.refreshEnabled();
        }
    }

    class AddSelectedAtStartAction
    extends AddFromSelectionAction
    implements TableModelListener {
        public AddSelectedAtStartAction() {
            this.putValue("ShortDescription", I18n.tr("Add all primitives selected in the current dataset before the first member"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "copystartright"));
            this.refreshEnabled();
        }

        protected void refreshEnabled() {
            this.setEnabled(GenericRelationEditor.this.selectionTableModel.getRowCount() > 0 && GenericRelationEditor.this.memberTableModel.getRowCount() > 0);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                List<OsmPrimitive> toAdd = this.filterConfirmedPrimitives(GenericRelationEditor.this.selectionTableModel.getSelection());
                GenericRelationEditor.this.memberTableModel.addMembersAtBeginning(toAdd);
            }
            catch (AddAbortException addAbortException) {
                // empty catch block
            }
        }

        public void tableChanged(TableModelEvent e) {
            this.refreshEnabled();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AddFromSelectionAction
    extends AbstractAction {
        AddFromSelectionAction() {
        }

        protected boolean isPotentialDuplicate(OsmPrimitive primitive) {
            return GenericRelationEditor.this.memberTableModel.hasMembersReferringTo(Collections.singleton(primitive));
        }

        protected boolean confirmAddingPrimtive(OsmPrimitive primitive) throws AddAbortException {
            String msg = I18n.tr("<html>This relation already has one or more members referring to<br>the primitive ''{0}''<br><br>Do you really want to add another relation member?</html>", primitive.getDisplayName(DefaultNameFormatter.getInstance()));
            int ret = ConditionalOptionPaneUtil.showOptionDialog("add_primitive_to_relation", Main.parent, msg, I18n.tr("Multiple members referring to same primitive"), 1, 2, null, null);
            switch (ret) {
                case -2147483648: {
                    return true;
                }
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case -1: {
                    return false;
                }
                case 2: {
                    throw new AddAbortException();
                }
            }
            return false;
        }

        protected void warnOfCircularReferences(OsmPrimitive primitive) {
            String msg = I18n.tr("<html>You are trying to add a relation to itself.<br><br>This creates circular references and is therefore discouraged.<br>Skipping relation ''{0}''.</html>", primitive.getDisplayName(DefaultNameFormatter.getInstance()));
            JOptionPane.showMessageDialog(Main.parent, msg, I18n.tr("Warning"), 2);
        }

        protected List<OsmPrimitive> filterConfirmedPrimitives(List<OsmPrimitive> primitives) throws AddAbortException {
            if (primitives == null || primitives.isEmpty()) {
                return primitives;
            }
            ArrayList<OsmPrimitive> ret = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive primitive : primitives) {
                if (primitive instanceof Relation && GenericRelationEditor.this.getRelation() != null && GenericRelationEditor.this.getRelation().equals(primitive)) {
                    this.warnOfCircularReferences(primitive);
                    continue;
                }
                if (this.isPotentialDuplicate(primitive)) {
                    if (!this.confirmAddingPrimtive(primitive)) continue;
                    ret.add(primitive);
                    continue;
                }
                ret.add(primitive);
            }
            return ret;
        }
    }

    class AddAbortException
    extends Exception {
        AddAbortException() {
        }
    }
}

