/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.relation.IMemberModelListener;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

public class MemberTable
extends JTable
implements IMemberModelListener {
    protected OsmDataLayer layer;
    protected JPopupMenu popupMenu;

    public MemberTable(OsmDataLayer layer, MemberTableModel model) {
        super(model, new MemberTableColumnModel(), model.getSelectionModel());
        this.layer = layer;
        model.addMemberModelListener(this);
        this.init();
    }

    protected void init() {
        this.setAutoResizeMode(4);
        this.setSelectionMode(2);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.getActionMap().put("selectNextColumnCell", new SelectNextColumnCellAction());
        this.getActionMap().put("selectPreviousColumnCell", new SelectPreviousColumnCellAction());
        this.addMouseListener(new PopupListener());
    }

    public Dimension getPreferredSize() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof JViewport); c = c.getParent()) {
        }
        if (c != null) {
            Dimension d = super.getPreferredSize();
            d.width = c.getSize().width;
            return d;
        }
        return super.getPreferredSize();
    }

    public void makeMemberVisible(int index) {
        this.scrollRectToVisible(this.getCellRect(index, 0, true));
    }

    protected void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        ZoomToAction zoomToAction = new ZoomToAction();
        Layer.listeners.add(zoomToAction);
        this.getSelectionModel().addListSelectionListener(zoomToAction);
        this.popupMenu.add(zoomToAction);
    }

    protected JPopupMenu getPopUpMenu() {
        if (this.popupMenu == null) {
            this.createPopupMenu();
        }
        return this.popupMenu;
    }

    protected MemberTableModel getMemberTableModel() {
        return (MemberTableModel)this.getModel();
    }

    class ZoomToAction
    extends AbstractAction
    implements Layer.LayerChangeListener,
    ListSelectionListener {
        public ZoomToAction() {
            this.putValue("Name", I18n.tr("Zoom to"));
            this.putValue("ShortDescription", I18n.tr("Zoom to primitive the first selected member refers to"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            int[] rows = MemberTable.this.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            int row = rows[0];
            OsmPrimitive primitive = MemberTable.this.getMemberTableModel().getReferredPrimitive(row);
            MemberTable.this.layer.data.setSelected(primitive);
            DataSet.fireSelectionChanged(MemberTable.this.layer.data.getSelected());
            AutoScaleAction action = new AutoScaleAction("selection");
            action.autoScale();
        }

        protected void updateEnabledState() {
            if (Main.main == null || Main.main.getEditLayer() != MemberTable.this.layer) {
                this.setEnabled(false);
                this.putValue("ShortDescription", I18n.tr("Zooming disabled because layer of this relation is not active"));
                return;
            }
            if (MemberTable.this.getSelectedRowCount() == 0) {
                this.setEnabled(false);
                this.putValue("ShortDescription", I18n.tr("Zooming disabled because there is no selected member"));
                return;
            }
            this.setEnabled(true);
            this.putValue("ShortDescription", I18n.tr("Zoom to primitive the first selected member refers to"));
        }

        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer newLayer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer oldLayer) {
            this.updateEnabledState();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                MemberTable.this.getPopUpMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int col = MemberTable.this.getSelectedColumn();
            int row = MemberTable.this.getSelectedRow();
            if (MemberTable.this.getCellEditor() != null) {
                MemberTable.this.getCellEditor().stopCellEditing();
            }
            if ((col > 0 || row > 0) && row > 0) {
                col = 0;
                --row;
            }
            MemberTable.this.changeSelection(row, col, false, false);
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int col = MemberTable.this.getSelectedColumn();
            int row = MemberTable.this.getSelectedRow();
            if (MemberTable.this.getCellEditor() != null) {
                MemberTable.this.getCellEditor().stopCellEditing();
            }
            if (col == 0 && row < MemberTable.this.getRowCount() - 1) {
                ++row;
            } else if (row < MemberTable.this.getRowCount() - 1) {
                col = 0;
                ++row;
            }
            MemberTable.this.changeSelection(row, col, false, false);
        }
    }
}

