/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class RelationDialogManager
extends WindowAdapter
implements Layer.LayerChangeListener {
    static RelationDialogManager relationDialogManager;
    private HashMap<DialogContext, RelationEditor> openDialogs = new HashMap();

    public static RelationDialogManager getRelationDialogManager() {
        if (relationDialogManager == null) {
            relationDialogManager = new RelationDialogManager();
            Layer.listeners.add(relationDialogManager);
        }
        return relationDialogManager;
    }

    public void register(OsmDataLayer layer, Relation relation, RelationEditor editor) {
        if (relation == null) {
            relation = new Relation();
        }
        DialogContext context = new DialogContext(layer, relation);
        this.openDialogs.put(context, editor);
        editor.addWindowListener(this);
    }

    public void updateContext(OsmDataLayer layer, Relation relation, RelationEditor editor) {
        for (DialogContext context : this.openDialogs.keySet()) {
            if (this.openDialogs.get(context) != editor) continue;
            this.openDialogs.remove(context);
            break;
        }
        DialogContext context = new DialogContext(layer, relation);
        this.openDialogs.put(context, editor);
    }

    public void close(OsmDataLayer layer, Relation relation) {
        DialogContext context = new DialogContext(layer, relation);
        RelationEditor editor = this.openDialogs.get(context);
        if (editor != null) {
            editor.setVisible(false);
        }
    }

    public boolean isOpenInEditor(OsmDataLayer layer, Relation relation) {
        if (relation == null) {
            return false;
        }
        DialogContext context = new DialogContext(layer, relation);
        return this.openDialogs.keySet().contains(context);
    }

    public RelationEditor getEditorForRelation(OsmDataLayer layer, Relation relation) {
        if (relation == null) {
            return null;
        }
        DialogContext context = new DialogContext(layer, relation);
        return this.openDialogs.get(context);
    }

    public void layerRemoved(Layer oldLayer) {
        if (oldLayer == null || !(oldLayer instanceof OsmDataLayer)) {
            return;
        }
        OsmDataLayer dataLayer = (OsmDataLayer)oldLayer;
        Iterator<Map.Entry<DialogContext, RelationEditor>> it = this.openDialogs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<DialogContext, RelationEditor> entry = it.next();
            if (!entry.getKey().matchesLayer(dataLayer)) continue;
            RelationEditor editor = entry.getValue();
            it.remove();
            editor.setVisible(false);
            editor.dispose();
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
    }

    public void layerAdded(Layer newLayer) {
    }

    public void windowClosed(WindowEvent e) {
        RelationEditor editor = (RelationEditor)e.getWindow();
        DialogContext context = null;
        for (DialogContext c : this.openDialogs.keySet()) {
            if (!this.openDialogs.get(c).equals(editor)) continue;
            context = c;
            break;
        }
        if (context != null) {
            this.openDialogs.remove(context);
        }
    }

    protected void centerOnScreen(RelationEditor editor) {
        Point p = new Point(0, 0);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        p.x = (d.width - editor.getSize().width) / 2;
        p.y = (d.height - editor.getSize().height) / 2;
        p.x = Math.max(p.x, 0);
        p.y = Math.max(p.y, 0);
        editor.setLocation(p);
    }

    protected boolean hasEditorWithCloseUpperLeftCorner(Point p) {
        for (RelationEditor editor : this.openDialogs.values()) {
            Point corner = editor.getLocation();
            if (p.x < corner.x - 5 || corner.x + 5 < p.x || p.y < corner.y - 5 || corner.y + 5 < p.y) continue;
            return true;
        }
        return false;
    }

    protected void positionCloseToScreenCenter(RelationEditor editor) {
        Point p = new Point(0, 0);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        p.x = (d.width - editor.getSize().width) / 2;
        p.y = (d.height - editor.getSize().height) / 2;
        p.x = Math.max(p.x, 0);
        p.y = Math.max(p.y, 0);
        while (this.hasEditorWithCloseUpperLeftCorner(p)) {
            p.x += 20;
            p.y += 20;
        }
        editor.setLocation(p);
    }

    public void positionOnScreen(RelationEditor editor) {
        if (editor == null) {
            return;
        }
        if (this.openDialogs.isEmpty()) {
            this.centerOnScreen(editor);
        } else {
            this.positionCloseToScreenCenter(editor);
        }
    }

    private static class DialogContext {
        public Relation relation;
        public OsmDataLayer layer;

        public DialogContext(OsmDataLayer layer, Relation relation) {
            this.layer = layer;
            this.relation = relation;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.layer == null ? 0 : this.layer.hashCode());
            result = 31 * result + (this.relation == null ? 0 : this.relation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DialogContext other = (DialogContext)obj;
            if (this.layer == null ? other.layer != null : !this.layer.equals(other.layer)) {
                return false;
            }
            return !(this.relation == null ? other.relation != null : !this.relation.equals(other.relation));
        }

        public boolean matchesLayer(OsmDataLayer layer) {
            if (layer == null) {
                return false;
            }
            return this.layer.equals(layer);
        }

        public String toString() {
            return "[Context: layer=" + this.layer.getName() + ",relation=" + this.relation.getId() + "]";
        }
    }
}

