/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.download;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class TileSelection
implements DownloadSelection {
    private JTextField tileX0 = new JTextField(7);
    private JTextField tileY0 = new JTextField(7);
    private JTextField tileX1 = new JTextField(7);
    private JTextField tileY1 = new JTextField(7);
    private JSpinner tileZ = new JSpinner(new SpinnerNumberModel(12, 10, 18, 1));

    public void addGui(final DownloadDialog gui) {
        JPanel smpanel = new JPanel(new GridBagLayout());
        smpanel.add((Component)new JLabel(I18n.tr("zoom level")), GBC.std().insets(0, 0, 10, 0));
        smpanel.add((Component)new JLabel(I18n.tr("x from")), GBC.std().insets(10, 0, 5, 0));
        smpanel.add((Component)this.tileX0, GBC.std());
        smpanel.add((Component)new JLabel(I18n.tr("to")), GBC.std().insets(10, 0, 5, 0));
        smpanel.add((Component)this.tileX1, GBC.eol());
        smpanel.add((Component)this.tileZ, GBC.std().insets(0, 0, 10, 0));
        smpanel.add((Component)new JLabel(I18n.tr("y from")), GBC.std().insets(10, 0, 5, 0));
        smpanel.add((Component)this.tileY0, GBC.std());
        smpanel.add((Component)new JLabel(I18n.tr("to")), GBC.std().insets(10, 0, 5, 0));
        smpanel.add((Component)this.tileY1, GBC.eol());
        FocusAdapter dialogUpdater = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                try {
                    int fromy;
                    int fromx;
                    int zoomlvl = (Integer)TileSelection.this.tileZ.getValue();
                    int tox = fromx = Integer.parseInt(TileSelection.this.tileX0.getText());
                    if (TileSelection.this.tileX1.getText().length() > 0) {
                        tox = Integer.parseInt(TileSelection.this.tileX1.getText());
                    }
                    if (tox < fromx) {
                        int i = fromx;
                        fromx = tox;
                        tox = i;
                    }
                    int toy = fromy = Integer.parseInt(TileSelection.this.tileY0.getText());
                    if (TileSelection.this.tileY1.getText().length() > 0) {
                        toy = Integer.parseInt(TileSelection.this.tileY1.getText());
                    }
                    if (toy < fromy) {
                        int i = fromy;
                        fromy = toy;
                        toy = i;
                    }
                    gui.minlat = TileSelection.tileYToLat(zoomlvl, toy + 1);
                    gui.minlon = TileSelection.tileXToLon(zoomlvl, fromx);
                    gui.maxlat = TileSelection.tileYToLat(zoomlvl, fromy);
                    gui.maxlon = TileSelection.tileXToLon(zoomlvl, tox + 1);
                    gui.boundingBoxChanged(TileSelection.this);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        for (JTextField f : new JTextField[]{this.tileX0, this.tileX1, this.tileY0, this.tileY1}) {
            f.setMinimumSize(new Dimension(100, new JTextField().getMinimumSize().height));
            f.addFocusListener(dialogUpdater);
        }
        gui.tabpane.addTab(I18n.tr("Tile Numbers"), smpanel);
    }

    public void boundingBoxChanged(DownloadDialog gui) {
        this.updateBboxFields(gui);
    }

    private void updateBboxFields(DownloadDialog gui) {
        int z = (Integer)this.tileZ.getValue();
        this.tileX0.setText(Integer.toString(TileSelection.lonToTileX(z, gui.minlon)));
        this.tileX1.setText(Integer.toString(TileSelection.lonToTileX(z, gui.maxlon - 1.0E-5)));
        this.tileY0.setText(Integer.toString(TileSelection.latToTileY(z, gui.maxlat - 1.0E-5)));
        this.tileY1.setText(Integer.toString(TileSelection.latToTileY(z, gui.minlat)));
    }

    public static int latToTileY(int zoom, double lat) {
        if (zoom < 3 || zoom > 18) {
            return -1;
        }
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return (int)((double)(1 << zoom - 1) * (Math.PI - pf) / Math.PI);
    }

    public static int lonToTileX(int zoom, double lon) {
        if (zoom < 3 || zoom > 18) {
            return -1;
        }
        return (int)((double)(1 << zoom - 3) * (lon + 180.0) / 45.0);
    }

    public static double tileYToLat(int zoom, int y) {
        if (zoom < 3 || zoom > 18) {
            return Double.MIN_VALUE;
        }
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)y / (double)(1 << zoom - 1))) * 180.0 / Math.PI;
    }

    public static double tileXToLon(int zoom, int x) {
        if (zoom < 3 || zoom > 18) {
            return Double.MIN_VALUE;
        }
        return (double)x * 45.0 / (double)(1 << zoom - 3) - 180.0;
    }
}

