/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UrlLabel;

public class VersionInfoPanel
extends JPanel
implements Observer {
    private PointInTimeType pointInTimeType;
    private HistoryBrowserModel model;
    private JLabel lblInfo;
    private UrlLabel lblUser;
    private UrlLabel lblChangeset;

    protected void build() {
        JPanel pnl1 = new JPanel();
        pnl1.setLayout(new FlowLayout(0));
        this.lblInfo = new JLabel();
        this.lblInfo.setHorizontalAlignment(2);
        pnl1.add(this.lblInfo);
        JPanel pnl2 = new JPanel();
        pnl2.setLayout(new FlowLayout(0));
        this.lblUser = new UrlLabel();
        pnl2.add(new JLabel(I18n.tr("User")));
        pnl2.add(this.lblUser);
        pnl2.add(new JLabel(I18n.tr("Changeset")));
        this.lblChangeset = new UrlLabel();
        pnl2.add(this.lblChangeset);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        this.add((Component)pnl1, gc);
        gc.gridy = 1;
        this.add((Component)pnl2, gc);
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected String getInfoText() {
        HistoryOsmPrimitive primitive = this.getPrimitive();
        if (primitive == null) {
            return "";
        }
        String text = I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong></html>", Long.toString(primitive.getVersion()), new SimpleDateFormat().format(primitive.getTimestamp()));
        return text;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel model, PointInTimeType pointInTimeType) throws IllegalArgumentException {
        if (pointInTimeType == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "pointInTimeType"));
        }
        if (model == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "model"));
        }
        this.model = model;
        this.pointInTimeType = pointInTimeType;
        model.addObserver(this);
        this.build();
    }

    public void update(Observable o, Object arg) {
        this.lblInfo.setText(this.getInfoText());
        String url = AbstractInfoAction.getBaseBrowseUrl() + "/changeset/" + this.getPrimitive().getChangesetId();
        this.lblChangeset.setUrl(url);
        this.lblChangeset.setDescription(Long.toString(this.getPrimitive().getChangesetId()));
        try {
            if (this.getPrimitive().getUid() != -1L) {
                url = AbstractInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(this.getPrimitive().getUser(), "UTF-8").replaceAll("\\+", "%20");
                this.lblUser.setUrl(url);
            } else {
                this.lblUser.setUrl(null);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.lblUser.setUrl(null);
        }
        this.lblUser.setDescription(this.getPrimitive().getUser());
    }
}

