/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.File;
import org.openstreetmap.josm.gui.io.UploadOrSaveState;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SaveLayerInfo
implements Comparable<SaveLayerInfo> {
    private OsmDataLayer layer;
    private boolean doSaveToFile;
    private boolean doUploadToServer;
    private File file;
    private UploadOrSaveState uploadState;
    private UploadOrSaveState saveState;

    public SaveLayerInfo(OsmDataLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException(I18n.tr("Parameter ''{0}'' must not be null.", "layer"));
        }
        this.layer = layer;
        this.doSaveToFile = layer.requiresSaveToFile();
        this.doUploadToServer = layer.requiresUploadToServer();
        this.file = layer.getAssociatedFile();
    }

    public OsmDataLayer getLayer() {
        return this.layer;
    }

    public boolean isDoSaveToFile() {
        return this.doSaveToFile;
    }

    public void setDoSaveToFile(boolean doSaveToFile) {
        this.doSaveToFile = doSaveToFile;
    }

    public boolean isDoUploadToServer() {
        return this.doUploadToServer;
    }

    public void setDoUploadToServer(boolean doUploadToServer) {
        this.doUploadToServer = doUploadToServer;
    }

    public boolean isDoSaveAndUpload() {
        return this.isDoSaveToFile() && this.isDoUploadToServer();
    }

    public String getName() {
        return this.layer.getName() == null ? "" : this.layer.getName();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public int compareTo(SaveLayerInfo o) {
        if (this.isDoSaveAndUpload()) {
            if (o.isDoSaveAndUpload()) {
                return this.getName().compareTo(o.getName());
            }
            return -1;
        }
        if (o.isDoSaveAndUpload()) {
            return 1;
        }
        if (this.isDoUploadToServer()) {
            if (o.isDoUploadToServer()) {
                return this.getName().compareTo(o.getName());
            }
            return -1;
        }
        if (o.isDoUploadToServer()) {
            return 1;
        }
        if (this.isDoSaveToFile()) {
            if (o.isDoSaveToFile()) {
                return this.getName().compareTo(o.getName());
            }
            return -1;
        }
        if (o.isDoSaveToFile()) {
            return 1;
        }
        return this.getName().compareTo(o.getName());
    }

    public UploadOrSaveState getUploadState() {
        return this.uploadState;
    }

    public void setUploadState(UploadOrSaveState uploadState) {
        this.uploadState = uploadState;
    }

    public UploadOrSaveState getSaveState() {
        return this.saveState;
    }

    public void setSaveState(UploadOrSaveState saveState) {
        this.saveState = saveState;
    }

    public void resetUploadAndSaveState() {
        this.uploadState = null;
        this.saveState = null;
    }
}

