/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.openstreetmap.josm.actions.GpxExportAction;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.SaveAsAction;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class Layer
implements Destroyable,
MapViewPaintable {
    public static final String VISIBLE_PROP = Layer.class.getName() + ".visible";
    public static final String NAME_PROP = Layer.class.getName() + ".name";
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final Collection<LayerChangeListener> listeners = new CopyOnWriteArrayList<LayerChangeListener>();
    private boolean visible = true;
    private boolean background = false;
    private String name;
    private File associatedFile;

    public Layer(String name) {
        this.setName(name);
    }

    public abstract void paint(Graphics var1, MapView var2);

    public abstract Icon getIcon();

    public abstract String getToolTipText();

    public abstract void mergeFrom(Layer var1);

    public abstract boolean isMergable(Layer var1);

    public abstract void visitBoundingBox(BoundingXYVisitor var1);

    public abstract Object getInfoComponent();

    public abstract Component[] getMenuEntries();

    public void destroy() {
    }

    public File getAssociatedFile() {
        return this.associatedFile;
    }

    public void setAssociatedFile(File file) {
        this.associatedFile = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        String oldValue = this.name;
        this.name = name;
        if (!this.name.equals(oldValue)) {
            this.propertyChangeSupport.firePropertyChange(NAME_PROP, oldValue, this.name);
        }
    }

    public boolean isBackgroundLayer() {
        return this.background;
    }

    public void setBackgroundLayer(boolean background) {
        this.background = background;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        if (oldValue != this.visible) {
            this.fireVisibleChanged(oldValue, this.visible);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void toggleVisible() {
        this.setVisible(!this.isVisible());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void fireVisibleChanged(boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(VISIBLE_PROP, oldValue, newValue);
    }

    public static class LayerGpxExportAction
    extends AbstractAction {
        private Layer layer;

        public LayerGpxExportAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("exportgpx"));
            this.putValue("ShortDescription", I18n.tr("Export the data to GPX file."));
            this.putValue("Name", I18n.tr("Export to GPX..."));
            this.setEnabled(true);
            this.layer = layer;
        }

        public void actionPerformed(ActionEvent e) {
            new GpxExportAction().export(this.layer);
        }
    }

    public static class LayerSaveAsAction
    extends AbstractAction {
        private Layer layer;

        public LayerSaveAsAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("save_as"));
            this.putValue("ShortDescription", I18n.tr("Save the current data to a new file."));
            this.putValue("Name", I18n.tr("Save As..."));
            this.setEnabled(true);
            this.layer = layer;
        }

        public void actionPerformed(ActionEvent e) {
            new SaveAsAction().doSave(this.layer);
        }
    }

    public static class LayerSaveAction
    extends AbstractAction {
        private Layer layer;

        public LayerSaveAction(Layer layer) {
            this.putValue("SmallIcon", ImageProvider.get("save"));
            this.putValue("ShortDescription", I18n.tr("Save the current data."));
            this.putValue("Name", I18n.tr("Save"));
            this.setEnabled(true);
            this.layer = layer;
        }

        public void actionPerformed(ActionEvent e) {
            new SaveAction().doSave(this.layer);
        }
    }

    public static interface LayerChangeListener {
        public void activeLayerChange(Layer var1, Layer var2);

        public void layerAdded(Layer var1);

        public void layerRemoved(Layer var1);
    }
}

