/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class WebMarker
extends ButtonMarker {
    public URL webUrl;

    public static WebMarker create(LatLon ll, String url, MarkerLayer parentLayer, double time, double offset) {
        try {
            return new WebMarker(ll, new URL(url), parentLayer, time, offset);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private WebMarker(LatLon ll, URL webUrl, MarkerLayer parentLayer, double time, double offset) {
        super(ll, "web.png", parentLayer, time, offset);
        this.webUrl = webUrl;
    }

    public void actionPerformed(ActionEvent ev) {
        String error = OpenBrowser.displayUrl(this.webUrl.toString());
        if (error != null) {
            JOptionPane.showMessageDialog(Main.parent, "<html><b>" + I18n.tr("There was an error while trying to display the URL for this marker") + "</b><br>" + I18n.tr("(URL was: ") + this.webUrl.toString() + ")" + "<br>" + error, I18n.tr("Error displaying URL"), 0);
        }
    }
}

