/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.gui.mappaint.Rule;

public abstract class ElemStyle {
    public long minScale;
    public long maxScale;
    public int priority;
    public String code;
    Collection<Rule> rules = null;

    public Boolean equals(ElemStyle s) {
        return s != null && s.getCode().equals(this.getCode());
    }

    public String getCode() {
        if (this.code == null && this.rules != null) {
            this.code = "";
            for (Rule r : this.rules) {
                this.code = this.code + r.toCode();
            }
        }
        return this.code;
    }

    public boolean check(OsmPrimitive primitive) {
        if (this.rules == null) {
            return true;
        }
        for (Rule r : this.rules) {
            String k = primitive.get(r.key);
            String bv = OsmUtils.getNamedOsmBoolean(r.boolValue);
            if (k != null && (r.value == null || k.equals(r.value)) && (bv == null || bv.equals(OsmUtils.getNamedOsmBoolean(k)))) continue;
            return false;
        }
        return true;
    }
}

