/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.IconElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElemStyles {
    HashMap<String, StyleSet> styleSet = new HashMap();

    public void add(String name, Rule r, Collection<Rule> rules, LineElemStyle style) {
        if (rules != null) {
            style.rules = rules;
            this.getStyleSet(name, true).linesList.add(style);
        } else {
            String key;
            style.code = key = r.getKey();
            this.getStyleSet(name, true).lines.put(key, style);
        }
    }

    public void addModifier(String name, Rule r, Collection<Rule> rules, LineElemStyle style) {
        if (rules != null) {
            style.rules = rules;
            this.getStyleSet(name, true).modifiersList.add(style);
        } else {
            String key;
            style.code = key = r.getKey();
            this.getStyleSet(name, true).modifiers.put(key, style);
        }
    }

    public void add(String name, Rule r, Collection<Rule> rules, AreaElemStyle style) {
        if (rules != null) {
            style.rules = rules;
            this.getStyleSet(name, true).areasList.add(style);
        } else {
            String key;
            style.code = key = r.getKey();
            this.getStyleSet(name, true).areas.put(key, style);
        }
    }

    public void add(String name, Rule r, Collection<Rule> rules, IconElemStyle style) {
        if (rules != null) {
            style.rules = rules;
            this.getStyleSet(name, true).iconsList.add(style);
        } else {
            String key;
            style.code = key = r.getKey();
            this.getStyleSet(name, true).icons.put(key, style);
        }
    }

    private StyleSet getStyleSet(String name, boolean create) {
        if (name == null) {
            name = Main.pref.get("mappaint.style", "standard");
        }
        StyleSet s = this.styleSet.get(name);
        if (create && s == null) {
            s = new StyleSet();
            this.styleSet.put(name, s);
        }
        return s;
    }

    public StyleSet getStyleSet() {
        return this.getStyleSet(null, false);
    }

    public Collection<String> getStyleNames() {
        return this.styleSet.keySet();
    }

    public class StyleSet {
        private HashMap<String, IconElemStyle> icons = new HashMap();
        private HashMap<String, LineElemStyle> lines = new HashMap();
        private HashMap<String, AreaElemStyle> areas;
        private HashMap<String, LineElemStyle> modifiers = new HashMap();
        private LinkedList<IconElemStyle> iconsList;
        private LinkedList<LineElemStyle> linesList;
        private LinkedList<AreaElemStyle> areasList;
        private LinkedList<LineElemStyle> modifiersList;

        public StyleSet() {
            this.areas = new HashMap();
            this.iconsList = new LinkedList();
            this.linesList = new LinkedList();
            this.modifiersList = new LinkedList();
            this.areasList = new LinkedList();
        }

        private IconElemStyle getNode(OsmPrimitive primitive) {
            IconElemStyle ret = null;
            for (Map.Entry<String, String> entry : primitive.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                IconElemStyle style = this.icons.get("n" + key + "=" + val);
                if (style != null && (ret == null || style.priority > ret.priority)) {
                    ret = style;
                }
                if ((style = this.icons.get("b" + key + "=" + OsmUtils.getNamedOsmBoolean(val))) != null && (ret == null || style.priority > ret.priority)) {
                    ret = style;
                }
                if ((style = this.icons.get("x" + key)) == null || ret != null && style.priority <= ret.priority) continue;
                ret = style;
            }
            for (IconElemStyle s : this.iconsList) {
                if (ret != null && s.priority <= ret.priority || !s.check(primitive)) continue;
                ret = s;
            }
            return ret;
        }

        private ElemStyle get(OsmPrimitive primitive, boolean noclosed) {
            AreaElemStyle retArea = null;
            LineElemStyle retLine = null;
            String linestring = null;
            HashMap<String, LineElemStyle> over = new HashMap<String, LineElemStyle>();
            for (Map.Entry<String, String> entry : primitive.entrySet()) {
                LineElemStyle styleLine;
                String key = entry.getKey();
                String val = entry.getValue();
                String idx = "n" + key + "=" + val;
                AreaElemStyle styleArea = this.areas.get(idx);
                if (!(styleArea == null || retArea != null && styleArea.priority <= retArea.priority || noclosed && styleArea.closed)) {
                    retArea = styleArea;
                }
                if ((styleLine = this.lines.get(idx)) != null && (retLine == null || styleLine.priority > retLine.priority)) {
                    retLine = styleLine;
                    linestring = idx;
                }
                if ((styleLine = this.modifiers.get(idx)) != null) {
                    over.put(idx, styleLine);
                }
                if (!((styleArea = this.areas.get(idx = "b" + key + "=" + OsmUtils.getNamedOsmBoolean(val))) == null || retArea != null && styleArea.priority <= retArea.priority || noclosed && styleArea.closed)) {
                    retArea = styleArea;
                }
                if ((styleLine = this.lines.get(idx)) != null && (retLine == null || styleLine.priority > retLine.priority)) {
                    retLine = styleLine;
                    linestring = idx;
                }
                if ((styleLine = this.modifiers.get(idx)) != null) {
                    over.put(idx, styleLine);
                }
                if (!((styleArea = this.areas.get(idx = "x" + key)) == null || retArea != null && styleArea.priority <= retArea.priority || noclosed && styleArea.closed)) {
                    retArea = styleArea;
                }
                if ((styleLine = this.lines.get(idx)) != null && (retLine == null || styleLine.priority > retLine.priority)) {
                    retLine = styleLine;
                    linestring = idx;
                }
                if ((styleLine = this.modifiers.get(idx)) == null) continue;
                over.put(idx, styleLine);
            }
            for (AreaElemStyle areaElemStyle : this.areasList) {
                if (retArea != null && areaElemStyle.priority <= retArea.priority || noclosed && areaElemStyle.closed || !areaElemStyle.check(primitive)) continue;
                retArea = areaElemStyle;
            }
            for (LineElemStyle lineElemStyle : this.linesList) {
                if (retLine != null && lineElemStyle.priority <= retLine.priority || !lineElemStyle.check(primitive)) continue;
                retLine = lineElemStyle;
            }
            for (LineElemStyle lineElemStyle : this.modifiersList) {
                if (!lineElemStyle.check(primitive)) continue;
                over.put(lineElemStyle.getCode(), lineElemStyle);
            }
            over.remove(linestring);
            if (over.size() != 0 && retLine != null) {
                LinkedList<LineElemStyle> s = new LinkedList<LineElemStyle>(over.values());
                Collections.sort(s);
                retLine = new LineElemStyle(retLine, s);
            }
            if (retArea != null) {
                if (retLine != null) {
                    return new AreaElemStyle(retArea, retLine);
                }
                return retArea;
            }
            return retLine;
        }

        public ElemStyle get(OsmPrimitive osm) {
            return !osm.hasKeys() ? null : (osm instanceof Node ? this.getNode(osm) : this.get(osm, osm instanceof Way && !((Way)osm).isClosed()));
        }

        public ElemStyle getArea(Way osm) {
            ElemStyle style;
            if (osm.hasKeys() && (style = this.get(osm, false)) != null && style instanceof AreaElemStyle) {
                return style;
            }
            return null;
        }

        public IconElemStyle getIcon(OsmPrimitive osm) {
            return osm.hasKeys() ? this.getNode(osm) : null;
        }

        public boolean isArea(OsmPrimitive o) {
            if (o.hasKeys() && !(o instanceof Node)) {
                boolean noclosed = o instanceof Way && !((Way)o).isClosed();
                for (String key : o.keySet()) {
                    String val = o.get(key);
                    AreaElemStyle s = this.areas.get("n" + key + "=" + val);
                    if (s == null || s.closed && noclosed) {
                        s = this.areas.get("b" + key + "=" + OsmUtils.getNamedOsmBoolean(val));
                    }
                    if (s == null || s.closed && noclosed) {
                        s = this.areas.get("x" + key);
                    }
                    if (s == null || s.closed && noclosed) continue;
                    return true;
                }
                for (AreaElemStyle s : this.areasList) {
                    if (s.closed && noclosed || !s.check(o)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasAreas() {
            return this.areas.size() > 0;
        }
    }
}

