/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.Collection;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineElemStyle
extends ElemStyle
implements Comparable<LineElemStyle> {
    public int width;
    public int realWidth;
    public Color color;
    public float[] dashed;
    public Color dashedColor;
    public boolean over;
    public WidthMode widthMode;
    public Collection<LineElemStyle> overlays;

    public LineElemStyle(LineElemStyle s, long maxScale, long minScale) {
        this.width = s.width;
        this.realWidth = s.realWidth;
        this.color = s.color;
        this.dashed = s.dashed;
        this.dashedColor = s.dashedColor;
        this.over = s.over;
        this.widthMode = s.widthMode;
        this.priority = s.priority;
        this.maxScale = maxScale;
        this.minScale = minScale;
        this.rules = s.rules;
    }

    public LineElemStyle(LineElemStyle s, Collection<LineElemStyle> overlays) {
        this.width = s.width;
        this.realWidth = s.realWidth;
        this.color = s.color;
        this.dashed = s.dashed;
        this.dashedColor = s.dashedColor;
        this.over = s.over;
        this.widthMode = s.widthMode;
        this.priority = s.priority;
        this.maxScale = s.maxScale;
        this.minScale = s.minScale;
        this.rules = s.rules;
        this.overlays = overlays;
        this.code = s.code;
        for (LineElemStyle o : overlays) {
            this.code = this.code + o.code;
        }
    }

    public LineElemStyle() {
        this.init();
    }

    public void init() {
        this.width = 1;
        this.realWidth = 0;
        this.dashed = new float[0];
        this.dashedColor = null;
        this.priority = 0;
        this.color = null;
        this.over = true;
        this.widthMode = WidthMode.ABSOLUTE;
        this.overlays = null;
    }

    public int getWidth(int ref) {
        int res = this.widthMode == WidthMode.ABSOLUTE ? this.width : (this.widthMode == WidthMode.OFFSET ? ref + this.width : (this.width < 0 ? 0 : ref * this.width / 100));
        return res <= 0 ? 1 : res;
    }

    @Override
    public int compareTo(LineElemStyle s) {
        if (s.priority != this.priority) {
            return s.priority > this.priority ? 1 : -1;
        }
        if (!this.over && s.over) {
            return -1;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WidthMode {
        ABSOLUTE,
        PERCENT,
        OFFSET;

    }
}

