/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.mappaint.ElemStyleHandler;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MapPaintStyles {
    private static ElemStyles styles = new ElemStyles();
    private static Collection<String> iconDirs;

    public static ElemStyles getStyles() {
        return styles;
    }

    public static ImageIcon getIcon(String name, String styleName) {
        LinkedList<String> dirs = new LinkedList<String>();
        for (String fileset : iconDirs) {
            String[] a = fileset.indexOf("=") >= 0 ? fileset.split("=", 2) : new String[]{"", fileset};
            if (a[0].length() != 0 && !styleName.equals(a[0])) continue;
            dirs.add(a[1]);
        }
        ImageIcon i = ImageProvider.getIfAvailable(dirs, "mappaint." + styleName, null, name);
        if (i == null) {
            System.out.println("Mappaint-Style \"" + styleName + "\" icon \"" + name + "\" not found.");
            i = ImageProvider.getIfAvailable(dirs, "mappaint." + styleName, null, "misc/no_icon.png");
        }
        return i;
    }

    public static void readFromPreferences() {
        iconDirs = Main.pref.getCollection("mappaint.icon.sources", Collections.<String>emptySet());
        if (Main.pref.getBoolean("mappaint.icon.enable-defaults", true)) {
            LinkedList<String> f = new LinkedList<String>(iconDirs);
            f.add("resource://images/styles/standard/");
            f.add("resource://images/styles/");
            iconDirs = f;
        }
        Collection<String> files = Main.pref.getCollection("mappaint.style.sources", Collections.<String>emptySet());
        if (Main.pref.getBoolean("mappaint.style.enable-defaults", true)) {
            LinkedList<String> f = new LinkedList<String>();
            f.add("resource://styles/standard/elemstyles.xml");
            f.addAll(files);
            files = f;
        }
        for (String fileset : files) {
            String[] a = null;
            try {
                a = fileset.indexOf("=") >= 0 ? fileset.split("=", 2) : new String[]{null, fileset};
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                ElemStyleHandler handler = new ElemStyleHandler(a[0]);
                xmlReader.setContentHandler(handler);
                xmlReader.setErrorHandler(handler);
                xmlReader.parse(new InputSource(new MirroredInputStream(a[1])));
            }
            catch (Exception e) {
                System.out.println("Mappaint-Style \"" + a[0] + "\" file \"" + a[1] + "\"");
                System.out.println("Mappaint-Style problems: " + e);
                e.printStackTrace();
            }
        }
        iconDirs = null;
    }
}

