/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.gui.preferences.PreferenceDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.prefJPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ShortcutPreference
implements PreferenceSetting {
    public void addGui(PreferenceDialog gui) {
        JPanel p = gui.createPreferenceTab("shortcuts", I18n.tr("Shortcut Preferences"), I18n.tr("Changing keyboard shortcuts manually."), false);
        prefJPanel prefpanel = new prefJPanel(new scListModel());
        p.add((Component)prefpanel, GBC.eol().fill(1));
    }

    public boolean ok() {
        return false;
    }

    private static class scListModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{I18n.tr("Action"), I18n.tr("Shortcut")};
        private Collection<Shortcut> data = Shortcut.listAll();

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            Shortcut sc = (Shortcut)this.data.toArray()[row];
            if (col == 0) {
                return sc.getLongText();
            }
            if (col == 1) {
                return sc.getKeyText();
            }
            return sc;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ShortcutPreference();
        }
    }
}

