/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class StyleSources
extends JPanel {
    private JList sourcesList = new JList(new DefaultListModel());
    private JList sourcesDefaults = new JList(new DefaultListModel());
    private JList iconsList = null;
    private String pref;
    private String iconpref;

    public StyleSources(String pref, String iconpref, final String url, boolean named, final String name) {
        this.sourcesDefaults.setCellRenderer(new MyCellRenderer());
        this.getDefaults(url);
        this.pref = pref;
        this.iconpref = iconpref;
        Collection<String> sources = Main.pref.getCollection(pref, null);
        if (sources != null) {
            for (String s : sources) {
                ((DefaultListModel)this.sourcesList.getModel()).addElement(s);
            }
        }
        JButton iconadd = null;
        JButton iconedit = null;
        JButton icondelete = null;
        if (iconpref != null) {
            this.iconsList = new JList(new DefaultListModel());
            sources = Main.pref.getCollection(iconpref, null);
            if (sources != null) {
                for (String s : sources) {
                    ((DefaultListModel)this.iconsList.getModel()).addElement(s);
                }
            }
            iconadd = new JButton(I18n.tr("Add"));
            iconadd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String source = JOptionPane.showInputDialog(Main.parent, I18n.tr("Icon paths"), I18n.tr("Icon paths"), 3);
                    if (source != null) {
                        ((DefaultListModel)StyleSources.this.iconsList.getModel()).addElement(source);
                    }
                }
            });
            iconedit = new JButton(I18n.tr("Edit"));
            iconedit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (StyleSources.this.sourcesList.getSelectedIndex() == -1) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to edit."), I18n.tr("Warning"), 2);
                    } else {
                        String source = (String)JOptionPane.showInputDialog(Main.parent, I18n.tr("Icon paths"), I18n.tr("Icon paths"), 3, null, null, StyleSources.this.iconsList.getSelectedValue());
                        if (source != null) {
                            ((DefaultListModel)StyleSources.this.iconsList.getModel()).setElementAt(source, StyleSources.this.iconsList.getSelectedIndex());
                        }
                    }
                }
            });
            icondelete = new JButton(I18n.tr("Delete"));
            icondelete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (StyleSources.this.iconsList.getSelectedIndex() == -1) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to delete."), I18n.tr("Warning"), 2);
                    } else {
                        ((DefaultListModel)StyleSources.this.iconsList.getModel()).remove(StyleSources.this.iconsList.getSelectedIndex());
                    }
                }
            });
        }
        JButton add = new JButton(I18n.tr("Add"));
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String source = JOptionPane.showInputDialog(Main.parent, name, name, 3);
                if (source != null) {
                    ((DefaultListModel)StyleSources.this.sourcesList.getModel()).addElement(source);
                }
            }
        });
        JButton edit = new JButton(I18n.tr("Edit"));
        edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StyleSources.this.sourcesList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to edit."), I18n.tr("Warning"), 2);
                } else {
                    String source = (String)JOptionPane.showInputDialog(Main.parent, name, name, 3, null, null, StyleSources.this.sourcesList.getSelectedValue());
                    if (source != null) {
                        ((DefaultListModel)StyleSources.this.sourcesList.getModel()).setElementAt(source, StyleSources.this.sourcesList.getSelectedIndex());
                    }
                }
            }
        });
        JButton delete = new JButton(I18n.tr("Delete"));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StyleSources.this.sourcesList.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to delete."), I18n.tr("Warning"), 2);
                } else {
                    ((DefaultListModel)StyleSources.this.sourcesList.getModel()).remove(StyleSources.this.sourcesList.getSelectedIndex());
                }
            }
        });
        JButton copy = new JButton(I18n.tr("Copy defaults"));
        copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (StyleSources.this.sourcesDefaults.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select the row to copy."), I18n.tr("Warning"), 2);
                } else {
                    ((DefaultListModel)StyleSources.this.sourcesList.getModel()).addElement(((SourceInfo)((StyleSources)StyleSources.this).sourcesDefaults.getSelectedValue()).url);
                }
            }
        });
        JButton update = new JButton(I18n.tr("Update"));
        update.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MirroredInputStream.cleanup(url);
                StyleSources.this.getDefaults(url);
                int num = StyleSources.this.sourcesList.getModel().getSize();
                if (num > 0) {
                    ArrayList l = new ArrayList();
                    for (int i = 0; i < num; ++i) {
                        MirroredInputStream.cleanup((String)StyleSources.this.sourcesList.getModel().getElementAt(i));
                    }
                }
            }
        });
        this.sourcesList.setToolTipText(I18n.tr("The XML source (URL or filename) for {0} definition files.", name));
        add.setToolTipText(I18n.tr("Add a new XML source to the list."));
        delete.setToolTipText(I18n.tr("Delete the selected source from the list."));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(name), GBC.eol().insets(5, 5, 5, 0));
        this.add((Component)new JScrollPane(this.sourcesList), GBC.eol().insets(5, 0, 5, 0).fill(1));
        this.add((Component)new JLabel(I18n.tr("Defaults (See tooltip for detailed information)")), GBC.eol().insets(5, 5, 5, 0));
        this.add((Component)new JScrollPane(this.sourcesDefaults), GBC.eol().insets(5, 0, 5, 0).fill(1));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.add((Component)buttonPanel, GBC.eol().insets(5, 0, 5, 5).fill(2));
        buttonPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        buttonPanel.add((Component)add, GBC.std().insets(0, 5, 0, 0));
        buttonPanel.add((Component)edit, GBC.std().insets(5, 5, 5, 0));
        buttonPanel.add((Component)delete, GBC.std().insets(0, 5, 5, 0));
        buttonPanel.add((Component)copy, GBC.std().insets(0, 5, 5, 0));
        buttonPanel.add((Component)update, GBC.std().insets(0, 5, 0, 0));
        if (this.iconsList != null) {
            this.add((Component)new JLabel(I18n.tr("Icon paths")), GBC.eol().insets(5, -5, 5, 0));
            this.add((Component)new JScrollPane(this.iconsList), GBC.eol().insets(5, 0, 5, 0).fill(1));
            buttonPanel = new JPanel(new GridBagLayout());
            this.add((Component)buttonPanel, GBC.eol().insets(5, 0, 5, 5).fill(2));
            buttonPanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
            buttonPanel.add((Component)iconadd, GBC.std().insets(0, 5, 0, 0));
            buttonPanel.add((Component)iconedit, GBC.std().insets(5, 5, 5, 0));
            buttonPanel.add((Component)icondelete, GBC.std().insets(0, 5, 0, 0));
        }
    }

    public boolean finish() {
        int i;
        ArrayList<String> l;
        boolean changed = false;
        int num = this.sourcesList.getModel().getSize();
        if (num > 0) {
            l = new ArrayList<String>();
            for (i = 0; i < num; ++i) {
                l.add((String)this.sourcesList.getModel().getElementAt(i));
            }
            if (Main.pref.putCollection(this.pref, l)) {
                changed = true;
            }
        } else if (Main.pref.putCollection(this.pref, null)) {
            changed = true;
        }
        if (this.iconsList != null) {
            num = this.iconsList.getModel().getSize();
            if (num > 0) {
                l = new ArrayList();
                for (i = 0; i < num; ++i) {
                    l.add((String)this.iconsList.getModel().getElementAt(i));
                }
                if (Main.pref.putCollection(this.iconpref, l)) {
                    changed = true;
                }
            } else if (Main.pref.putCollection(this.iconpref, null)) {
                changed = true;
            }
        }
        return changed;
    }

    public void getDefaults(String name) {
        ((DefaultListModel)this.sourcesDefaults.getModel()).removeAllElements();
        String lang = LanguageInfo.getLanguageCodeXML();
        try {
            String line;
            InputStreamReader r;
            MirroredInputStream stream = new MirroredInputStream(name);
            try {
                r = new InputStreamReader((InputStream)stream, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                r = new InputStreamReader(stream);
            }
            BufferedReader reader = new BufferedReader(r);
            SourceInfo last = null;
            while ((line = reader.readLine()) != null) {
                Matcher m;
                if (line.startsWith("\t")) {
                    m = Pattern.compile("^\t([^:]+): *(.+)$").matcher(line);
                    m.matches();
                    try {
                        if (last == null) continue;
                        String key = m.group(1);
                        String value = m.group(2);
                        if ("author".equals(key) && last.author == null) {
                            last.author = value;
                            continue;
                        }
                        if ("version".equals(key)) {
                            last.version = value;
                            continue;
                        }
                        if ("link".equals(key) && last.link == null) {
                            last.link = value;
                            continue;
                        }
                        if ("description".equals(key) && last.description == null) {
                            last.description = value;
                            continue;
                        }
                        if ("shortdescription".equals(key) && last.shortdescription == null) {
                            last.shortdescription = value;
                            continue;
                        }
                        if ((lang + "author").equals(key)) {
                            last.author = value;
                            continue;
                        }
                        if ((lang + "link").equals(key)) {
                            last.link = value;
                            continue;
                        }
                        if ((lang + "description").equals(key)) {
                            last.description = value;
                            continue;
                        }
                        if (!(lang + "shortdescription").equals(key)) continue;
                        last.shortdescription = value;
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                last = null;
                m = Pattern.compile("^(.+);(.+)$").matcher(line);
                m.matches();
                try {
                    last = new SourceInfo(m.group(1), m.group(2));
                    ((DefaultListModel)this.sourcesDefaults.getModel()).addElement(last);
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            this.setToolTipText(((SourceInfo)value).getTooltip());
            return this;
        }
    }

    public class SourceInfo {
        String version;
        String name;
        String url;
        String author;
        String link;
        String description;
        String shortdescription;

        public SourceInfo(String name, String url) {
            this.name = name;
            this.url = url;
            this.shortdescription = null;
            this.description = null;
            this.link = null;
            this.author = null;
            this.version = null;
        }

        public String getName() {
            return this.shortdescription == null ? this.name : this.shortdescription;
        }

        public String getTooltip() {
            String s = I18n.tr("Short Description: {0}", this.getName()) + "<br>" + I18n.tr("URL: {0}", this.url);
            if (this.author != null) {
                s = s + "<br>" + I18n.tr("Author: {0}", this.author);
            }
            if (this.link != null) {
                s = s + "<br>" + I18n.tr("Webpage: {0}", this.link);
            }
            if (this.description != null) {
                s = s + "<br>" + I18n.tr("Description: {0}", this.description);
            }
            if (this.version != null) {
                s = s + "<br>" + I18n.tr("Version: {0}", this.version);
            }
            return "<html>" + s + "</html>";
        }

        public String toString() {
            return this.getName() + " (" + this.url + ")";
        }
    }
}

