/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionCache {
    private static final Logger logger = Logger.getLogger(AutoCompletionCache.class.getName());
    private static HashMap<OsmDataLayer, AutoCompletionCache> caches = new HashMap();
    private HashMap<String, Set<String>> tagCache = new HashMap();
    private Set<String> roleCache = new HashSet<String>();
    private OsmDataLayer layer;

    public static AutoCompletionCache getCacheForLayer(OsmDataLayer layer) {
        AutoCompletionCache cache = caches.get(layer);
        if (cache == null) {
            cache = new AutoCompletionCache(layer);
            caches.put(layer, cache);
        }
        return cache;
    }

    public AutoCompletionCache(OsmDataLayer layer) {
        this.layer = layer;
    }

    public AutoCompletionCache() {
        this(null);
    }

    protected void cacheKey(String key) {
        if (this.tagCache.containsKey(key)) {
            return;
        }
        this.tagCache.put(key, new HashSet());
    }

    protected void cacheValue(String key, String value) {
        this.cacheKey(key);
        this.tagCache.get(key).add(value);
    }

    protected void cachePrimitive(OsmPrimitive primitive) {
        for (String key : primitive.keySet()) {
            String value = primitive.get(key);
            this.cacheValue(key, value);
        }
    }

    protected void cacheRelationMemberRoles(Relation relation) {
        for (RelationMember m : relation.getMembers()) {
            if (!m.hasRole() || this.roleCache.contains(m.getRole())) continue;
            this.roleCache.add(m.getRole());
        }
    }

    public void initFromDataSet() {
        this.tagCache = new HashMap();
        if (this.layer == null) {
            return;
        }
        Collection<OsmPrimitive> ds = this.layer.data.allNonDeletedPrimitives();
        for (OsmPrimitive primitive : ds) {
            this.cachePrimitive(primitive);
        }
        for (Relation relation : this.layer.data.relations) {
            if (relation.incomplete || relation.isDeleted()) continue;
            this.cacheRelationMemberRoles(relation);
        }
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.tagCache.keySet());
    }

    public List<String> getValues(String key) {
        if (!this.tagCache.containsKey(key)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>((Collection)this.tagCache.get(key));
    }

    public List<String> getMemberRoles() {
        return new ArrayList<String>(this.roleCache);
    }

    public void populateWithMemberRoles(AutoCompletionList list) {
        list.clear();
        list.add(this.roleCache, AutoCompletionItemPritority.IS_IN_DATASET);
    }

    public void populateWithTagValues(AutoCompletionList list, String key, boolean append) {
        if (!append) {
            list.clear();
        }
        list.add(this.getValues(key), AutoCompletionItemPritority.IS_IN_DATASET);
    }

    public void populateWithKeys(AutoCompletionList list, boolean append) {
        if (!append) {
            list.clear();
        }
        list.add(this.tagCache.keySet(), AutoCompletionItemPritority.IS_IN_DATASET);
    }

    static {
        Layer.listeners.add(new Layer.LayerChangeListener(){

            public void activeLayerChange(Layer oldLayer, Layer newLayer) {
            }

            public void layerAdded(Layer newLayer) {
            }

            public void layerRemoved(Layer oldLayer) {
                if (oldLayer instanceof OsmDataLayer) {
                    caches.remove(oldLayer);
                }
            }
        });
    }
}

