/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffResultReader
extends AbstractVisitor {
    private Map<String, Long[]> versions = new HashMap<String, Long[]>();
    private Collection<OsmPrimitive> processed;
    private Map<OsmPrimitive, Long> newIdMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseDiffResult(String source, Collection<OsmPrimitive> osm, Collection<OsmPrimitive> processed, Map<OsmPrimitive, Long> newIdMap, ProgressMonitor progressMonitor) throws SAXException, IOException {
        progressMonitor.beginTask(I18n.tr("Preparing data..."));
        try {
            DiffResultReader drr = new DiffResultReader();
            drr.processed = processed;
            drr.newIdMap = newIdMap;
            InputSource inputSource = new InputSource(new StringReader(source));
            try {
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                DiffResultReader diffResultReader = drr;
                diffResultReader.getClass();
                sAXParser.parse(inputSource, (DefaultHandler)diffResultReader.new Parser());
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
                throw new SAXException(e1);
            }
            for (OsmPrimitive p : osm) {
                p.visit(drr);
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    @Override
    public void visit(Node n) {
        String key = "node:" + (this.newIdMap.containsKey(n) ? this.newIdMap.get(n).longValue() : n.getId());
        Long[] nv = this.versions.get(key);
        if (nv != null) {
            this.processed.add(n);
            if (!n.isDeleted()) {
                n.setOsmId(nv[0], nv[1].intValue());
            }
        }
    }

    @Override
    public void visit(Way w) {
        String key = "way:" + (this.newIdMap.containsKey(w) ? this.newIdMap.get(w).longValue() : w.getId());
        Long[] nv = this.versions.get(key);
        if (nv != null) {
            this.processed.add(w);
            if (!w.isDeleted()) {
                w.setOsmId(nv[0], nv[1].intValue());
            }
        }
    }

    @Override
    public void visit(Relation r) {
        String key = "relation:" + (this.newIdMap.containsKey(r) ? this.newIdMap.get(r).longValue() : r.getId());
        Long[] nv = this.versions.get(key);
        if (nv != null) {
            this.processed.add(r);
            if (!r.isDeleted()) {
                r.setOsmId(nv[0], nv[1].intValue());
            }
        }
    }

    private class Parser
    extends DefaultHandler {
        private Parser() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (!qName.equals("osm") && (qName.equals("node") || qName.equals("way") || qName.equals("relation"))) {
                    String key = qName + ":" + atts.getValue("old_id");
                    String newid = atts.getValue("new_id");
                    String newver = atts.getValue("new_version");
                    Long[] value = new Long[]{newid == null ? null : new Long(newid), newver == null ? null : new Long(newver)};
                    DiffResultReader.this.versions.put(key, value);
                }
            }
            catch (NumberFormatException x) {
                x.printStackTrace();
                throw new SAXException(x.getMessage(), x);
            }
            catch (NullPointerException x) {
                x.printStackTrace();
                throw new SAXException(I18n.tr("NullPointerException, possibly some missing tags."), x);
            }
        }
    }
}

