/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.io.CredentialsManager;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class OsmConnection {
    private static final Logger logger = Logger.getLogger(OsmConnection.class.getName());
    protected boolean cancel = false;
    protected HttpURLConnection activeConnection;
    public static CredentialsManager credentialsManager = new PlainCredentialsManager();
    private static OsmAuth authentication = new OsmAuth();

    protected final void initAuthentication() {
        OsmConnection.authentication.authCancelled = false;
        OsmConnection.authentication.passwordtried = false;
    }

    protected final boolean isAuthCancelled() {
        return OsmConnection.authentication.authCancelled;
    }

    public void cancel() {
        this.cancel = true;
        if (this.activeConnection != null) {
            this.activeConnection.setConnectTimeout(100);
            this.activeConnection.setReadTimeout(100);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.activeConnection.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAuth(HttpURLConnection con) throws CharacterCodingException {
        String auth;
        CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
        try {
            CredentialsManager credentialsManager = OsmConnection.credentialsManager;
            synchronized (credentialsManager) {
                auth = OsmConnection.credentialsManager.lookup(CredentialsManager.Key.USERNAME) + ":" + OsmConnection.credentialsManager.lookup(CredentialsManager.Key.PASSWORD);
            }
        }
        catch (CredentialsManager.CMException e) {
            auth = ":";
        }
        ByteBuffer bytes = encoder.encode(CharBuffer.wrap(auth));
        con.addRequestProperty("Authorization", "Basic " + Base64.encode(bytes));
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    static {
        try {
            HttpURLConnection.setFollowRedirects(true);
            Authenticator.setDefault(authentication);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static class PlainCredentialsManager
    implements CredentialsManager {
        public String lookup(CredentialsManager.Key key) throws CredentialsManager.CMException {
            String secret = Main.pref.get("osm-server." + key.toString(), null);
            if (secret == null) {
                throw new CredentialsManager.NoContentException();
            }
            return secret;
        }

        public void store(CredentialsManager.Key key, String secret) {
            Main.pref.put("osm-server." + key.toString(), secret);
        }

        public PasswordAuthentication getPasswordAuthentication(OsmAuth caller) {
            String password;
            String username;
            try {
                username = this.lookup(CredentialsManager.Key.USERNAME);
            }
            catch (CredentialsManager.CMException e) {
                username = "";
            }
            try {
                password = this.lookup(CredentialsManager.Key.PASSWORD);
            }
            catch (CredentialsManager.CMException e) {
                password = "";
            }
            if (caller.passwordtried || username.equals("") || password.equals("")) {
                JPanel p = new JPanel(new GridBagLayout());
                if (!username.equals("") && !password.equals("")) {
                    p.add((Component)new JLabel(I18n.tr("Incorrect password or username.")), GBC.eop());
                }
                p.add((Component)new JLabel(I18n.tr("Username")), GBC.std().insets(0, 0, 10, 0));
                JTextField usernameField = new JTextField(username, 20);
                p.add((Component)usernameField, GBC.eol());
                p.add((Component)new JLabel(I18n.tr("Password")), GBC.std().insets(0, 0, 10, 0));
                JPasswordField passwordField = new JPasswordField(password, 20);
                p.add((Component)passwordField, GBC.eol());
                JLabel warning = new JLabel(I18n.tr("Warning: The password is transferred unencrypted."));
                warning.setFont(warning.getFont().deriveFont(2));
                p.add((Component)warning, GBC.eop());
                JCheckBox savePassword = new JCheckBox(I18n.tr("Save user and password (unencrypted)"), !username.equals("") && !password.equals(""));
                p.add((Component)savePassword, GBC.eop());
                ExtendedDialog dialog = new ExtendedDialog(Main.parent, I18n.tr("Enter Password"), new String[]{I18n.tr("Login"), I18n.tr("Cancel")});
                dialog.setContent(p);
                dialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
                dialog.showDialog();
                if (dialog.getValue() != 1) {
                    caller.authCancelled = true;
                    return null;
                }
                username = usernameField.getText();
                password = String.valueOf(passwordField.getPassword());
                if (savePassword.isSelected()) {
                    this.store(CredentialsManager.Key.USERNAME, username);
                    this.store(CredentialsManager.Key.PASSWORD, password);
                }
                if (username.equals("")) {
                    return null;
                }
            }
            caller.passwordtried = true;
            return new PasswordAuthentication(username, password.toCharArray());
        }

        public CredentialsManager.PreferenceAdditions newPreferenceAdditions() {
            return new CredentialsManager.PreferenceAdditions(){
                private final JTextField osmDataServerURL = new JTextField(20);
                private final JTextField osmDataUsername = new JTextField(20);
                private final JPasswordField osmDataPassword = new JPasswordField(20);
                private String oldServerURL = "";
                private String oldUsername = "";
                private String oldPassword = "";

                public void addPreferenceOptions(JPanel panel) {
                    try {
                        this.oldServerURL = PlainCredentialsManager.this.lookup(CredentialsManager.Key.OSM_SERVER_URL);
                    }
                    catch (CredentialsManager.CMException e) {
                        this.oldServerURL = "";
                    }
                    if (this.oldServerURL.equals("")) {
                        this.oldServerURL = "http://api.openstreetmap.org/api";
                    }
                    try {
                        this.oldUsername = PlainCredentialsManager.this.lookup(CredentialsManager.Key.USERNAME);
                    }
                    catch (CredentialsManager.CMException e) {
                        this.oldUsername = "";
                    }
                    try {
                        this.oldPassword = PlainCredentialsManager.this.lookup(CredentialsManager.Key.PASSWORD);
                    }
                    catch (CredentialsManager.CMException e) {
                        this.oldPassword = "";
                    }
                    this.osmDataServerURL.setText(this.oldServerURL);
                    this.osmDataUsername.setText(this.oldUsername);
                    this.osmDataPassword.setText(this.oldPassword);
                    this.osmDataServerURL.setToolTipText(I18n.tr("The base URL for the OSM server (REST API)"));
                    this.osmDataUsername.setToolTipText(I18n.tr("Login name (e-mail) to the OSM account."));
                    this.osmDataPassword.setToolTipText(I18n.tr("Login password to the OSM account. Leave blank to not store any password."));
                    panel.add((Component)new JLabel(I18n.tr("Base Server URL")), GBC.std());
                    panel.add((Component)this.osmDataServerURL, GBC.eol().fill(2).insets(5, 0, 0, 5));
                    panel.add((Component)new JLabel(I18n.tr("OSM username (e-mail)")), GBC.std());
                    panel.add((Component)this.osmDataUsername, GBC.eol().fill(2).insets(5, 0, 0, 5));
                    panel.add((Component)new JLabel(I18n.tr("OSM password")), GBC.std());
                    panel.add((Component)this.osmDataPassword, GBC.eol().fill(2).insets(5, 0, 0, 0));
                    JLabel warning = new JLabel(I18n.tr("<html>WARNING: The password is stored in plain text in the preferences file.<br>The password is transferred in plain text to the server, encoded in the URL.<br><b>Do not use a valuable Password.</b></html>"));
                    warning.setFont(warning.getFont().deriveFont(2));
                    panel.add((Component)warning, GBC.eop().fill(2));
                }

                public void preferencesChanged() {
                    String newServerURL = this.osmDataServerURL.getText();
                    String newUsername = this.osmDataUsername.getText();
                    String newPassword = String.valueOf(this.osmDataPassword.getPassword());
                    if (!this.oldServerURL.equals(newServerURL)) {
                        PlainCredentialsManager.this.store(CredentialsManager.Key.OSM_SERVER_URL, newServerURL);
                    }
                    if (!this.oldUsername.equals(newUsername)) {
                        PlainCredentialsManager.this.store(CredentialsManager.Key.USERNAME, newUsername);
                    }
                    if (!this.oldPassword.equals(newPassword)) {
                        PlainCredentialsManager.this.store(CredentialsManager.Key.PASSWORD, newPassword);
                    }
                }
            };
        }
    }

    public static class OsmAuth
    extends Authenticator {
        public boolean passwordtried = false;
        public boolean authCancelled = false;

        protected PasswordAuthentication getPasswordAuthentication() {
            return credentialsManager.getPasswordAuthentication(this);
        }
    }
}

