/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmIdReader
extends DefaultHandler {
    private boolean cancel;
    Map<Long, String> entries = new HashMap<Long, String>();
    private Reader in;

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("node") || qName.equals("way") || qName.equals("relation")) {
            try {
                this.entries.put(Long.valueOf(atts.getValue("id")), qName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SAXException(I18n.tr("Error during parse."));
            }
        }
    }

    public Map<Long, String> parseIds(InputStream in) throws IOException, SAXException {
        block4: {
            this.in = new InputStreamReader(in, "UTF-8");
            try {
                SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(this.in), (DefaultHandler)this);
            }
            catch (ParserConfigurationException e) {
                if (!this.cancel) {
                    e.printStackTrace();
                    throw new SAXException(e);
                }
            }
            catch (SAXException e) {
                if (this.cancel) break block4;
                throw e;
            }
        }
        return this.entries;
    }

    public void cancel() {
        this.cancel = true;
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

